/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.validation.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.dozer.fieldmap.FieldMapUtils;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.DeepHierarchyElement;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;
import org.openl.rules.mapping.OpenLReflectionUtils;
import org.openl.rules.mapping.validation.FieldPathHierarchyElement;
import org.openl.rules.mapping.validation.JavaBeanHierarchyElement;
import org.openl.rules.mapping.validation.ThisHierarchyElement;
import org.openl.rules.mapping.validation.utils.JavaMethodMetaInfo;
import org.openl.rules.mapping.validation.utils.MethodMetaInfo;
import org.openl.rules.mapping.validation.utils.OpenlMethodMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationUtils {
    private ValidationUtils() {
    }

    public static boolean isDeepFieldHierarchy(String fieldPath) {
        return MappingUtils.isDeepMapping((String)fieldPath);
    }

    public static boolean isSimpleCollectionIndex(String index) {
        return MappingUtils.isSimpleCollectionIndex((String)index);
    }

    public static int getCollectionIndex(String index) {
        return MappingUtils.getCollectionIndex((String)index);
    }

    public static boolean isSupportedCollection(Class<?> type) {
        return MappingUtils.isSupportedCollection(type);
    }

    public static Class<?> getCollectionFieldType(Class<?> collectionClass, Class<?> entryTypeHint) {
        if (entryTypeHint != null && collectionClass.isArray() && collectionClass.getComponentType() != entryTypeHint) {
            return Array.newInstance(entryTypeHint, 0).getClass();
        }
        return collectionClass;
    }

    public static Class<?> getSupportedCollectionEntryType(Class<?> collectionClass, Class<?> entryTypeHint) {
        if (entryTypeHint != null) {
            return entryTypeHint;
        }
        return MappingUtils.getSupportedCollectionEntryType(collectionClass);
    }

    public static FieldPathHierarchyElement[] getFieldHierarchy(Class<?> parentClass, String field, Class<?>[] hint) {
        PropertyDescriptor propDescriptor;
        HintContainer hintContainer = ValidationUtils.getHint(hint);
        if (ValidationUtils.isDeepFieldHierarchy(field)) {
            DeepHierarchyElement[] deepHierarchy = ReflectionUtils.getDeepFieldHierarchy(parentClass, (String)field, (HintContainer)hintContainer);
            FieldPathHierarchyElement[] fieldPathHierarchy = new FieldPathHierarchyElement[deepHierarchy.length];
            for (int i = 0; i < deepHierarchy.length; ++i) {
                DeepHierarchyElement element = deepHierarchy[i];
                fieldPathHierarchy[i] = new JavaBeanHierarchyElement(element.getPropDescriptor(), element.getIndex(), element.getHintType());
            }
            return fieldPathHierarchy;
        }
        if ("this".equals(field)) {
            return new FieldPathHierarchyElement[]{new ThisHierarchyElement(parentClass)};
        }
        String fieldName = field;
        String indexExpression = null;
        if (field.contains("[")) {
            fieldName = field.substring(0, field.indexOf(91));
            indexExpression = field.substring(field.indexOf(91) + 1, field.indexOf(93));
        }
        if ((propDescriptor = ReflectionUtils.findPropertyDescriptor(parentClass, (String)fieldName, (HintContainer)hintContainer)) == null) {
            MappingUtils.throwMappingException((String)("Exception occurred determining field hierarchy for Class --> " + parentClass.getName() + ", Field --> " + field));
        }
        return new FieldPathHierarchyElement[]{new JavaBeanHierarchyElement(propDescriptor, indexExpression, null)};
    }

    public static MethodMetaInfo findMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        return ValidationUtils.findMatchingAccessibleMethod(clazz, methodName, paramTypes);
    }

    public static MethodMetaInfo findMethod(IOpenClass clazz, String methodName, Class<?>[] paramTypes) {
        return ValidationUtils.findMatchingAccessibleMethod(clazz, methodName, paramTypes);
    }

    private static HintContainer getHint(Class<?> ... types) {
        if (types == null || types.length == 0) {
            return null;
        }
        Object[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            names[i] = types[i] == null ? "" : types[i].getName();
        }
        return FieldMapUtils.hint((String)StringUtils.join((Object[])names, (String)","));
    }

    private static MethodMetaInfo findMatchingAccessibleMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        Method method = ReflectionUtils.findMatchingAccessibleMethod(clazz, (String)methodName, (Class[])paramTypes);
        if (method != null) {
            return new JavaMethodMetaInfo(method);
        }
        return null;
    }

    private static MethodMetaInfo findMatchingAccessibleMethod(IOpenClass clazz, String methodName, Class<?>[] paramTypes) {
        IOpenMethod method = OpenLReflectionUtils.findMatchingAccessibleMethod(clazz, methodName, paramTypes);
        if (method != null) {
            return new OpenlMethodMetaInfo(method);
        }
        return null;
    }
}

