/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.dozer.CollectionItemDiscriminator;
import org.dozer.ConfigurableCustomConverter;
import org.dozer.CustomConverter;
import org.dozer.CustomFieldMapper;
import org.dozer.FieldMappingCondition;
import org.dozer.MapIdConverterAggregator;
import org.dozer.MappedFieldsTracker;
import org.dozer.Mapper;
import org.dozer.MapperAware;
import org.dozer.MappingContext;
import org.dozer.MappingException;
import org.dozer.MappingParamsAware;
import org.dozer.MappingParentObjects;
import org.dozer.cache.Cache;
import org.dozer.cache.CacheKeyFactory;
import org.dozer.cache.CacheManager;
import org.dozer.cache.DozerCacheType;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.ClassMapBuilder;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.CopyByReferenceContainer;
import org.dozer.classmap.RelationshipType;
import org.dozer.converters.DateFormatContainer;
import org.dozer.converters.PrimitiveOrWrapperConverter;
import org.dozer.event.DozerEvent;
import org.dozer.event.DozerEventManager;
import org.dozer.event.DozerEventType;
import org.dozer.event.EventManager;
import org.dozer.factory.BeanCreationDirective;
import org.dozer.factory.DestBeanCreator;
import org.dozer.fieldmap.CustomGetSetMethodFieldMap;
import org.dozer.fieldmap.ExcludeFieldMap;
import org.dozer.fieldmap.FieldMap;
import org.dozer.fieldmap.HintContainer;
import org.dozer.fieldmap.MapFieldMap;
import org.dozer.fieldmap.MultiSourceFieldMap;
import org.dozer.stats.StatisticType;
import org.dozer.stats.StatisticsManager;
import org.dozer.util.CollectionUtils;
import org.dozer.util.DozerConstants;
import org.dozer.util.IteratorUtils;
import org.dozer.util.LogMsgFactory;
import org.dozer.util.MappingUtils;
import org.dozer.util.MappingValidator;
import org.dozer.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingProcessor
implements Mapper {
    private static final Logger log = LoggerFactory.getLogger(MappingProcessor.class);
    private final ClassMappings classMappings;
    private final Configuration globalConfiguration;
    private final List<CustomConverter> customConverterObjects;
    private final Map<String, CustomConverter> customConverterObjectsWithId;
    private final StatisticsManager statsMgr;
    private final EventManager eventMgr;
    private final CustomFieldMapper customFieldMapper;
    private final List<FieldMappingCondition> conditionObjects;
    private final Map<String, FieldMappingCondition> conditionObjectsWithId;
    private final List<CollectionItemDiscriminator> collectionItemDiscriminatorObjects;
    private final Map<String, CollectionItemDiscriminator> collectionItemDiscriminatorObjectsWithId;
    private final MappedFieldsTracker mappedFields = new MappedFieldsTracker();
    private final Cache converterByDestTypeCache;
    private final Cache superTypeCache;
    private final PrimitiveOrWrapperConverter primitiveConverter = new PrimitiveOrWrapperConverter();
    private Stack<FieldMap> fieldMapStack = new Stack();
    private MappingParentObjects parentObjects = new MappingParentObjects();
    private String srcFullFieldMap;
    private String dstFullFieldMap;
    private MapIdConverterAggregator mapIdConverterAggregator = new MapIdConverterAggregator();

    protected MappingProcessor(ClassMappings classMappings, Configuration globalConfiguration, CacheManager cacheMgr, StatisticsManager statsMgr, List<CustomConverter> customConverterObjects, DozerEventManager eventManager, CustomFieldMapper customFieldMapper, Map<String, CustomConverter> customConverterObjectsWithId, List<FieldMappingCondition> conditionObjects, Map<String, FieldMappingCondition> conditionObjectsWithId, List<CollectionItemDiscriminator> collectionItemDiscriminatorObjects, Map<String, CollectionItemDiscriminator> collectionItemDiscriminatorObjectsWithId) {
        this.classMappings = classMappings;
        this.globalConfiguration = globalConfiguration;
        this.statsMgr = statsMgr;
        this.customConverterObjects = customConverterObjects;
        this.eventMgr = eventManager;
        this.customFieldMapper = customFieldMapper;
        this.converterByDestTypeCache = cacheMgr.getCache(DozerCacheType.CONVERTER_BY_DEST_TYPE.name());
        this.superTypeCache = cacheMgr.getCache(DozerCacheType.SUPER_TYPE_CHECK.name());
        this.customConverterObjectsWithId = customConverterObjectsWithId;
        this.conditionObjects = conditionObjects;
        this.conditionObjectsWithId = conditionObjectsWithId;
        this.collectionItemDiscriminatorObjects = collectionItemDiscriminatorObjects;
        this.collectionItemDiscriminatorObjectsWithId = collectionItemDiscriminatorObjectsWithId;
        if (customConverterObjectsWithId != null) {
            for (CustomConverter converter : customConverterObjectsWithId.values()) {
                if (!(converter instanceof MapIdConverterAggregator)) continue;
                this.mapIdConverterAggregator = (MapIdConverterAggregator)converter;
            }
        }
    }

    static void removeOrphans(Collection<?> mappedElements, List<Object> result) {
        Iterator<Object> iterator = result.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (mappedElements.contains(object)) continue;
            iterator.remove();
        }
        for (Object object : mappedElements) {
            if (result.contains(object)) continue;
            result.add(object);
        }
    }

    static List<?> prepareDestinationList(Collection<?> srcCollectionValue, Object field) {
        if (field == null) {
            return new ArrayList(srcCollectionValue.size());
        }
        if (CollectionUtils.isList(field.getClass())) {
            return (List)field;
        }
        if (CollectionUtils.isArray(field.getClass())) {
            return new ArrayList<Object>(Arrays.asList((Object[])field));
        }
        return new ArrayList(srcCollectionValue.size());
    }

    @Override
    public <T> T map(Object srcObj, Class<T> destClass) {
        return this.map(srcObj, destClass, null, this.getContextOrNewEmptyContext(null));
    }

    @Override
    public <T> T map(Object srcObj, Class<T> destClass, MappingContext context) {
        MappingValidator.validateMappingRequest(srcObj, destClass);
        return this.map(srcObj, destClass, null, this.getContextOrNewEmptyContext(context));
    }

    @Override
    public void map(Object srcObj, Object destObj) {
        this.map(srcObj, destObj, this.getContextOrNewEmptyContext(null));
    }

    @Override
    public void map(Object srcObj, Object destObj, MappingContext context) {
        MappingValidator.validateMappingRequest(srcObj, destObj);
        this.map(srcObj, null, destObj, this.getContextOrNewEmptyContext(context));
    }

    private MappingContext getContextOrNewEmptyContext(MappingContext contextFromParams) {
        return contextFromParams == null ? new MappingContext() : contextFromParams;
    }

    private <T> T map(Object srcObj, Class<T> destClass, T destObj, MappingContext context) {
        Object result;
        Class<Object> destType;
        srcObj = MappingUtils.deProxy(srcObj);
        if (destClass == null) {
            destType = destObj.getClass();
            result = destObj;
        } else {
            destType = destClass;
            result = null;
        }
        ClassMap classMap = null;
        try {
            Object alreadyMappedValue;
            classMap = this.getClassMap(srcObj.getClass(), destType, this.getMapId(context));
            this.eventMgr.fireEvent(new DozerEvent(DozerEventType.MAPPING_STARTED, classMap, null, srcObj, result, null));
            CustomConverter converter = MappingUtils.findCustomConverter(this.converterByDestTypeCache, this.customConverterObjects, classMap.getCustomConverters(), srcObj.getClass(), destType);
            if (converter != null) {
                return (T)this.mapUsingCustomConverterInstance(converter, srcObj.getClass(), srcObj, destType, result, null, context, true);
            }
            if (result == null) {
                result = DestBeanCreator.create(context.getParams(), new BeanCreationDirective(srcObj, classMap.getSrcClassToMap(), classMap.getDestClassToMap(), destType, classMap.getDestClassBeanFactory(), classMap.getDestClassBeanFactoryId(), classMap.getDestClassCreateMethod()));
            }
            if ((alreadyMappedValue = this.mappedFields.getMappedValue(srcObj, destClass)) != null) {
                return (T)alreadyMappedValue;
            }
            this.map(classMap, srcObj, result, false, this.getMapId(context), context);
        }
        catch (Throwable e) {
            MappingUtils.throwMappingException(e);
        }
        this.eventMgr.fireEvent(new DozerEvent(DozerEventType.MAPPING_FINISHED, classMap, null, srcObj, result, null));
        return (T)result;
    }

    private void map(ClassMap classMap, Object srcObj, Object destObj, boolean bypassSuperMappings, String mapId, MappingContext context) {
        CustomConverter converter;
        srcObj = MappingUtils.deProxy(srcObj);
        this.mappedFields.put(srcObj, destObj);
        if (classMap == null) {
            classMap = this.getClassMap(srcObj.getClass(), destObj.getClass(), mapId);
        }
        Class<?> srcClass = srcObj.getClass();
        Class<?> destClass = destObj.getClass();
        if (log.isDebugEnabled()) {
            log.debug(String.format("VALUES TO MAP: %s->%s\nCLASS MAP: %s->%s", LogMsgFactory.getLogOutput(srcObj), LogMsgFactory.getLogOutput(destObj), classMap.getSrcClassToMap(), classMap.getDestClassToMap()));
        }
        if ((converter = MappingUtils.findCustomConverter(this.converterByDestTypeCache, this.customConverterObjects, classMap.getCustomConverters(), srcClass, destClass)) != null) {
            this.mapUsingCustomConverterInstance(converter, srcClass, srcObj, destClass, destObj, null, context, true);
            return;
        }
        List<String> mappedParentFields = null;
        if (!bypassSuperMappings) {
            mappedParentFields = this.mapParentFields(classMap, srcObj, destObj, mapId, context);
        }
        Collection<FieldMap> fieldMappings = this.getFieldMappings(classMap, mapId);
        for (FieldMap fieldMapping : fieldMappings) {
            String key = MappingUtils.getMappedParentFieldKey(destObj, fieldMapping);
            if (mappedParentFields != null && mappedParentFields.contains(key)) continue;
            if (log.isTraceEnabled()) {
                this.updateFullFieldMapInfo(fieldMapping);
            }
            this.parentObjects.push(srcObj, destObj);
            if (context != null && context.getParams() != null) {
                context.getParams().put("PARENTOBJECTS", this.parentObjects);
            }
            this.mapField(fieldMapping, srcObj, destObj, context);
            this.parentObjects.pop();
            if (!log.isTraceEnabled()) continue;
            this.fieldMapStack.pop();
        }
    }

    private void updateFullFieldMapInfo(FieldMap fieldMap) {
        this.fieldMapStack.push(fieldMap);
        StringBuffer src = new StringBuffer();
        StringBuffer dst = new StringBuffer();
        if (!this.fieldMapStack.empty()) {
            for (FieldMap f : this.fieldMapStack) {
                this.prependDot(src);
                this.prependDot(dst);
                src.append(f.getSrcFieldName());
                dst.append(f.getDestFieldName());
            }
        }
        this.srcFullFieldMap = src.toString();
        this.dstFullFieldMap = dst.toString();
        log.trace("FULL FIELD PATH: [" + this.srcFullFieldMap + "] -> [" + this.dstFullFieldMap + "]");
    }

    private void prependDot(StringBuffer src) {
        if (src.length() > 0) {
            src.append(".");
        }
    }

    private Collection<FieldMap> getFieldMappings(ClassMap classMap, String mapId) {
        if (MappingUtils.isBlankOrNull(mapId)) {
            return this.getGeneralFieldMaps(classMap);
        }
        return this.getMapIdSpecificFieldMaps(classMap, mapId);
    }

    private Collection<FieldMap> getMapIdSpecificFieldMaps(ClassMap classMap, String mapId) {
        LinkedHashMap<String, FieldMap> mappings = new LinkedHashMap<String, FieldMap>();
        for (FieldMap fieldMapping : classMap.getFieldMaps()) {
            String key;
            if (!MappingUtils.isBlankOrNull(fieldMapping.getMapId()) && !mapId.equals(fieldMapping.getMapId()) || mappings.containsKey(key = MappingUtils.fieldMapKey(fieldMapping)) && !MappingUtils.isBlankOrNull(((FieldMap)mappings.get(key)).getMapId()) && MappingUtils.isBlankOrNull(fieldMapping.getMapId())) continue;
            mappings.put(key, fieldMapping);
        }
        return mappings.values();
    }

    private Collection<FieldMap> getGeneralFieldMaps(ClassMap classMap) {
        LinkedHashMap<String, FieldMap> mappings = new LinkedHashMap<String, FieldMap>();
        for (FieldMap fieldMapping : classMap.getFieldMaps()) {
            String key = MappingUtils.fieldMapKey(fieldMapping);
            if (!MappingUtils.isBlankOrNull(fieldMapping.getMapId())) continue;
            mappings.put(key, fieldMapping);
        }
        return mappings.values();
    }

    private List<String> mapParentFields(ClassMap classMap, Object srcObj, Object destObj, String mapId, MappingContext context) {
        ArrayList<ClassMap> superMappings = new ArrayList<ClassMap>();
        List<String> mappedParentFields = new ArrayList<String>();
        Collection<ClassMap> superClasses = this.checkForSuperTypeMapping(srcObj.getClass(), destObj.getClass());
        superMappings.addAll(superClasses);
        List<String> overridedFieldMappings = this.getFieldMapKeys(destObj, classMap.getFieldMaps(), mapId);
        if (!superMappings.isEmpty()) {
            mappedParentFields = this.processSuperTypeMapping(superMappings, srcObj, destObj, mapId, context, overridedFieldMappings);
        }
        return mappedParentFields;
    }

    private List<String> getFieldMapKeys(Object destObj, List<FieldMap> fieldMaps, String mapId) {
        ArrayList<String> keys = new ArrayList<String>();
        for (FieldMap fieldMap : fieldMaps) {
            String key;
            if (!MappingUtils.isBlankOrNull(fieldMap.getMapId()) && !fieldMap.getMapId().equals(mapId) || keys.contains(key = MappingUtils.getMappedParentFieldKey(destObj, fieldMap))) continue;
            keys.add(key);
        }
        return keys;
    }

    private void mapField(FieldMap fieldMapping, Object srcObj, Object destObj, MappingContext context) {
        if (fieldMapping instanceof ExcludeFieldMap) {
            return;
        }
        Object srcFieldValue = null;
        try {
            srcFieldValue = fieldMapping.getSrcFieldValue(srcObj);
            boolean fieldMapped = false;
            if (this.customFieldMapper != null) {
                fieldMapped = this.customFieldMapper.mapField(srcObj, destObj, srcFieldValue, fieldMapping.getClassMap(), fieldMapping);
            }
            if (!fieldMapped) {
                if (!(fieldMapping instanceof MultiSourceFieldMap) && fieldMapping.getDestFieldType() != null && "iterate".equals(fieldMapping.getDestFieldType())) {
                    this.mapFromIterateMethodFieldMap(srcObj, destObj, srcFieldValue, fieldMapping, context);
                } else {
                    this.mapFromFieldMap(srcObj, destObj, srcFieldValue, fieldMapping, context);
                }
            }
            this.statsMgr.increment(StatisticType.FIELD_MAPPING_SUCCESS_COUNT);
        }
        catch (Throwable e) {
            log.error(LogMsgFactory.createFieldMappingErrorMsg(srcObj, fieldMapping, srcFieldValue, destObj), e);
            this.statsMgr.increment(StatisticType.FIELD_MAPPING_FAILURE_COUNT);
            if (fieldMapping.isStopOnErrors()) {
                MappingUtils.throwMappingException(e);
            }
            if (!fieldMapping.getClassMap().getAllowedExceptions().isEmpty() && e.getCause() instanceof InvocationTargetException) {
                Throwable thrownType = ((InvocationTargetException)e.getCause()).getTargetException();
                Class<?> exceptionClass = thrownType.getClass();
                if (fieldMapping.getClassMap().getAllowedExceptions().contains(exceptionClass)) {
                    throw (RuntimeException)thrownType;
                }
            }
            this.statsMgr.increment(StatisticType.FIELD_MAPPING_FAILURE_IGNORED_COUNT);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mapFromFieldMap(Object srcObj, Object destObj, Object srcFieldValue, FieldMap fieldMapping, MappingContext context) {
        Object destFieldValue;
        Class<?> srcFieldClass;
        Class<?> destFieldType;
        if (fieldMapping instanceof CustomGetSetMethodFieldMap) {
            try {
                destFieldType = fieldMapping.getDestFieldWriteMethod(destObj.getClass()).getParameterTypes()[0];
            }
            catch (Throwable e) {
                destFieldType = fieldMapping.getDestFieldType(destObj.getClass());
            }
        } else {
            destFieldType = fieldMapping.getDestFieldType(destObj.getClass());
        }
        boolean mapField = true;
        if (!MappingUtils.isBlankOrNull(fieldMapping.getMappingConditionId())) {
            if (this.conditionObjectsWithId == null || !this.conditionObjectsWithId.containsKey(fieldMapping.getMappingConditionId()) || this.conditionObjectsWithId.get(fieldMapping.getMappingConditionId()) == null) throw new MappingException("Mapping condition instance not found with id:" + fieldMapping.getMappingConditionId());
            srcFieldClass = srcFieldValue != null ? srcFieldValue.getClass() : fieldMapping.getSrcFieldType(srcObj.getClass());
            FieldMappingCondition conditionInstance = this.conditionObjectsWithId.get(fieldMapping.getMappingConditionId());
            Object existingValue = this.getExistingValue(fieldMapping, srcFieldClass, srcFieldValue, destObj, destFieldType, context);
            mapField = this.evaluateConditionInstance(conditionInstance, srcFieldClass, srcFieldValue, destFieldType, existingValue, context);
        } else if (!MappingUtils.isBlankOrNull(fieldMapping.getMappingCondition())) {
            srcFieldClass = srcFieldValue != null ? srcFieldValue.getClass() : fieldMapping.getSrcFieldType(srcObj.getClass());
            Class<?> conditionClass = MappingUtils.loadClass(fieldMapping.getMappingCondition());
            Object existingValue = this.getExistingValue(fieldMapping, srcFieldClass, srcFieldValue, destObj, destFieldType, context);
            mapField = this.evaluateCondition(conditionClass, srcFieldClass, srcFieldValue, destFieldType, existingValue, fieldMapping, context);
        }
        if (!mapField) {
            return;
        }
        if (!MappingUtils.isBlankOrNull(fieldMapping.getCustomConverterId())) {
            if (this.customConverterObjectsWithId == null || !this.customConverterObjectsWithId.containsKey(fieldMapping.getCustomConverterId()) || this.customConverterObjectsWithId.get(fieldMapping.getCustomConverterId()) == null) throw new MappingException("CustomConverter instance not found with id:" + fieldMapping.getCustomConverterId());
            srcFieldClass = srcFieldValue != null ? srcFieldValue.getClass() : fieldMapping.getSrcFieldType(srcObj.getClass());
            CustomConverter converterInstance = this.customConverterObjectsWithId.get(fieldMapping.getCustomConverterId());
            destFieldValue = this.mapUsingCustomConverterInstance(converterInstance, srcFieldClass, srcFieldValue, destFieldType, destObj, fieldMapping, context, false);
        } else if (MappingUtils.isBlankOrNull(fieldMapping.getCustomConverter())) {
            if (fieldMapping instanceof MultiSourceFieldMap) {
                MappingUtils.throwMappingException("Custom converter should be provided");
            }
            destFieldValue = this.mapOrRecurseObject(srcObj, srcFieldValue, destFieldType, destObj, fieldMapping, context);
        } else {
            srcFieldClass = srcFieldValue != null ? srcFieldValue.getClass() : fieldMapping.getSrcFieldType(srcObj.getClass());
            Class<?> converterClass = MappingUtils.loadClass(fieldMapping.getCustomConverter());
            destFieldValue = this.mapUsingCustomConverter(converterClass, srcFieldClass, srcFieldValue, destFieldType, destObj, fieldMapping, context, false);
        }
        Object destDefaultValue = null;
        if (fieldMapping.getDestFieldDefaultValue() != null) {
            if ("this".equals(fieldMapping.getDestFieldDefaultValue())) {
                Class<?> srcFieldClass2 = fieldMapping.getSrcFieldType(srcObj.getClass());
                destDefaultValue = DestBeanCreator.create(context.getParams(), new BeanCreationDirective(srcFieldValue, srcFieldClass2, destFieldType, destFieldType, null, null, fieldMapping.getDestFieldCreateMethod() != null ? fieldMapping.getDestFieldCreateMethod() : null));
            } else {
                destDefaultValue = this.primitiveConverter.convert(fieldMapping.getDestFieldDefaultValue(), destFieldType, new DateFormatContainer(fieldMapping.getDateFormat()));
            }
        }
        this.writeDestinationValue(destObj, destFieldValue, fieldMapping, srcObj, destDefaultValue);
        if (!log.isDebugEnabled()) return;
        log.debug(LogMsgFactory.createFieldMappingSuccessMsg(srcObj.getClass(), destObj.getClass(), fieldMapping.getSrcFieldName(), fieldMapping.getDestFieldName(), srcFieldValue, destFieldValue, fieldMapping.getMapId()));
    }

    private boolean evaluateConditionInstance(FieldMappingCondition conditionInstance, Class<?> srcFieldClass, Object srcFieldValue, Class<?> destFieldType, Object destFieldValue, MappingContext context) {
        if (conditionInstance instanceof MappingParamsAware) {
            ((MappingParamsAware)((Object)conditionInstance)).setMappingParams(context.getParams());
        }
        return conditionInstance.mapField(srcFieldValue, destFieldValue, srcFieldClass, destFieldType);
    }

    private boolean evaluateCondition(Class<?> conditionClass, Class<?> srcFieldClass, Object srcFieldValue, Class<?> destFieldType, Object destFieldValue, FieldMap fieldMapping, MappingContext context) {
        FieldMappingCondition conditionInstance = null;
        if (this.conditionObjects != null) {
            for (FieldMappingCondition conditionObject : this.conditionObjects) {
                if (!conditionObject.getClass().isAssignableFrom(conditionClass)) continue;
                conditionInstance = conditionObject;
            }
        }
        if (conditionInstance == null) {
            conditionInstance = (FieldMappingCondition)ReflectionUtils.newInstance(conditionClass);
        }
        return this.evaluateConditionInstance(conditionInstance, srcFieldClass, srcFieldValue, destFieldType, destFieldValue, context);
    }

    private Object evaluateCollectionItemDiscriminator(Class<?> discriminatorClass, Class<?> srcFieldClass, Object srcFieldValue, Class<?> destFieldType, Object destCollection, FieldMap fieldMapping, MappingContext context) {
        CollectionItemDiscriminator collectionItemDiscriminatorInstance = null;
        if (this.collectionItemDiscriminatorObjects != null) {
            for (CollectionItemDiscriminator disciminatorObject : this.collectionItemDiscriminatorObjects) {
                if (!disciminatorObject.getClass().isAssignableFrom(discriminatorClass)) continue;
                collectionItemDiscriminatorInstance = disciminatorObject;
            }
        }
        if (collectionItemDiscriminatorInstance == null) {
            collectionItemDiscriminatorInstance = (CollectionItemDiscriminator)ReflectionUtils.newInstance(discriminatorClass);
        }
        return this.evaluateCollectionItemDiscriminatorInstance(collectionItemDiscriminatorInstance, srcFieldClass, srcFieldValue, destFieldType, destCollection, context);
    }

    private Object evaluateCollectionItemDiscriminatorInstance(CollectionItemDiscriminator discriminatorInstance, Class<?> srcFieldClass, Object srcFieldValue, Class<?> destFieldType, Object destCollection, MappingContext context) {
        if (discriminatorInstance instanceof MappingParamsAware) {
            ((MappingParamsAware)((Object)discriminatorInstance)).setMappingParams(context.getParams());
        }
        return discriminatorInstance.discriminate(srcFieldClass, srcFieldValue, destCollection.getClass(), destFieldType, destCollection);
    }

    private Object mapOrRecurseObject(Object srcObj, Object srcFieldValue, Class<?> destFieldType, Object destObj, FieldMap fieldMap, MappingContext context) {
        Object alreadyMappedValue;
        Class<?> srcFieldClass = srcFieldValue != null ? srcFieldValue.getClass() : fieldMap.getSrcFieldType(srcObj.getClass());
        CustomConverter converter = MappingUtils.determineCustomConverter(fieldMap, this.converterByDestTypeCache, this.customConverterObjects, fieldMap.getClassMap().getCustomConverters(), srcFieldClass, destFieldType);
        if (converter != null) {
            return this.mapUsingCustomConverterInstance(converter, srcFieldClass, srcFieldValue, destFieldType, destObj, fieldMap, context, false);
        }
        if (srcFieldValue == null) {
            return null;
        }
        String srcFieldName = fieldMap.getSrcFieldName();
        String destFieldName = fieldMap.getDestFieldName();
        if (!("this".equals(srcFieldName) && "this".equals(destFieldName) || (alreadyMappedValue = this.mappedFields.getMappedValue(srcFieldValue, destFieldType)) == null)) {
            return alreadyMappedValue;
        }
        if (fieldMap.isCopyByReference()) {
            return srcFieldValue;
        }
        boolean isSrcFieldClassSupportedMap = MappingUtils.isSupportedMap(srcFieldClass);
        boolean isDestFieldTypeSupportedMap = MappingUtils.isSupportedMap(destFieldType);
        if (isSrcFieldClassSupportedMap && isDestFieldTypeSupportedMap) {
            return this.mapMap(srcObj, (Map)srcFieldValue, fieldMap, destObj, context);
        }
        if (fieldMap instanceof MapFieldMap && destFieldType.equals(Object.class)) {
            Class<?> clazz = destFieldType = fieldMap.getDestHintContainer() != null ? fieldMap.getDestHintContainer().getHint() : srcFieldClass;
        }
        if (this.primitiveConverter.accepts(srcFieldClass) || this.primitiveConverter.accepts(destFieldType)) {
            if (fieldMap.getDestHintContainer() != null) {
                destFieldType = fieldMap.getDestHintContainer().getHint();
            }
            DateFormatContainer dfContainer = new DateFormatContainer(fieldMap.getDateFormat());
            Object convertSrcFieldValue = srcFieldValue;
            if (fieldMap.isTrimStrings() && srcFieldValue.getClass().equals(String.class)) {
                convertSrcFieldValue = ((String)srcFieldValue).trim();
            }
            if (fieldMap instanceof MapFieldMap && !this.primitiveConverter.accepts(destFieldType)) {
                return this.primitiveConverter.convert(convertSrcFieldValue, convertSrcFieldValue.getClass(), dfContainer);
            }
            return this.primitiveConverter.convert(convertSrcFieldValue, destFieldType, dfContainer);
        }
        if (MappingUtils.isSupportedCollection(srcFieldClass) && MappingUtils.isSupportedCollection(destFieldType)) {
            return this.mapCollection(srcObj, srcFieldValue, fieldMap, destObj, context);
        }
        if (!(!MappingUtils.isSupportedCollection(destFieldType) || MappingUtils.isBlankOrNull(fieldMap.getCollectionItemDiscriminator()) && MappingUtils.isBlankOrNull(fieldMap.getCollectionItemDiscriminatorId()))) {
            Object[] arrayValue = new Object[]{srcFieldValue};
            return this.mapCollection(srcObj, arrayValue, fieldMap, destObj, context);
        }
        if (MappingUtils.isEnumType(srcFieldClass, destFieldType)) {
            return this.mapEnum((Enum)srcFieldValue, destFieldType);
        }
        return this.mapCustomObject(fieldMap, destObj, destFieldType, srcFieldClass, srcFieldValue, context);
    }

    private <T extends Enum<T>> T mapEnum(Enum<T> srcFieldValue, Class<T> destFieldType) {
        String name = srcFieldValue.name();
        return Enum.valueOf(destFieldType, name);
    }

    private Object mapCustomObject(FieldMap fieldMap, Object destObj, Class<?> destFieldType, Class<?> srcFieldType, Object srcFieldValue, MappingContext context) {
        srcFieldValue = MappingUtils.deProxy(srcFieldValue);
        Object result = this.getExistingValue(fieldMap, srcFieldType, srcFieldValue, destObj, destFieldType, context);
        ClassMap classMap = null;
        if (result == null) {
            Class<?> destHintType;
            if (fieldMap.getDestHintContainer() != null && (destHintType = fieldMap.getDestHintType(srcFieldValue.getClass())) != null) {
                destFieldType = destHintType;
            }
            String mapId = fieldMap.getMapId();
            Class<?> targetClass = fieldMap.getDestHintContainer() != null && fieldMap.getDestHintContainer().getHint() != null ? fieldMap.getDestHintContainer().getHint() : destFieldType;
            classMap = this.getClassMap(srcFieldValue.getClass(), targetClass, mapId);
            result = DestBeanCreator.create(context.getParams(), new BeanCreationDirective(srcFieldValue, classMap.getSrcClassToMap(), classMap.getDestClassToMap(), destFieldType, classMap.getDestClassBeanFactory(), classMap.getDestClassBeanFactoryId(), fieldMap.getDestFieldCreateMethod() != null ? fieldMap.getDestFieldCreateMethod() : classMap.getDestClassCreateMethod()));
        }
        String oldMapId = context.getMapId();
        if (this.canGetNewMapId(srcFieldValue, destObj, context, fieldMap)) {
            String newMapId = this.getMapId(srcFieldValue, destObj, context, fieldMap);
            context.setMapId(newMapId);
        }
        this.map(classMap, srcFieldValue, result, false, this.getMapId(context), context);
        context.setMapId(oldMapId);
        return result;
    }

    private Object mapCollection(Object srcObj, Object srcCollectionValue, FieldMap fieldMap, Object destObj, MappingContext context) {
        Class<?> genericType;
        if (fieldMap.getDestHintContainer() == null && (genericType = fieldMap.getGenericType(destObj.getClass())) != null) {
            HintContainer destHintContainer = new HintContainer();
            destHintContainer.setHintName(genericType.getName());
            FieldMap cloneFieldMap = (FieldMap)fieldMap.clone();
            cloneFieldMap.setDestHintContainer(destHintContainer);
            fieldMap = cloneFieldMap;
        }
        if (srcCollectionValue instanceof Iterator) {
            srcCollectionValue = IteratorUtils.toList((Iterator)((Object)srcCollectionValue));
        }
        Class<Object> destCollectionType = fieldMap.getDestFieldType(destObj.getClass());
        Class<?> srcFieldType = srcCollectionValue.getClass();
        if (fieldMap instanceof MapFieldMap && (MappingUtils.isSupportedMap(fieldMap.getDestFieldType(destObj.getClass())) || "this".equals(fieldMap.getDestFieldName()) && MappingUtils.isSupportedMap(fieldMap.getClassMap().getDestClassToMap()))) {
            destCollectionType = srcFieldType;
        }
        Collection<?> result = null;
        if (Collection.class.getName().equals(destCollectionType.getName())) {
            destCollectionType = List.class;
        }
        if (CollectionUtils.isArray(srcFieldType) && CollectionUtils.isArray(destCollectionType)) {
            result = this.mapArrayToArray(srcObj, srcCollectionValue, fieldMap, destObj, destCollectionType.getComponentType(), context);
        } else if (CollectionUtils.isArray(srcFieldType) && CollectionUtils.isList(destCollectionType)) {
            result = this.mapArrayToList(srcObj, srcCollectionValue, fieldMap, destObj, context);
        } else if (CollectionUtils.isList(srcFieldType) && CollectionUtils.isArray(destCollectionType)) {
            result = this.mapListToArray(srcObj, srcCollectionValue, fieldMap, destObj, context);
        } else if (CollectionUtils.isList(srcFieldType) && CollectionUtils.isList(destCollectionType)) {
            result = this.mapListToList(srcObj, srcCollectionValue, fieldMap, destObj, context);
        } else if (CollectionUtils.isSet(srcFieldType) && CollectionUtils.isArray(destCollectionType)) {
            result = this.mapSetToArray(srcObj, (Set)((Object)srcCollectionValue), fieldMap, destObj, context);
        } else if (CollectionUtils.isArray(srcFieldType) && CollectionUtils.isSet(destCollectionType)) {
            result = this.addToSet(srcObj, fieldMap, Arrays.asList((Object[])srcCollectionValue), destObj, context);
        } else if (CollectionUtils.isSet(srcFieldType) && CollectionUtils.isList(destCollectionType)) {
            result = this.mapListToList(srcObj, (Set)((Object)srcCollectionValue), fieldMap, destObj, context);
        } else if (CollectionUtils.isCollection(srcFieldType) && CollectionUtils.isSet(destCollectionType)) {
            result = this.addToSet(srcObj, fieldMap, srcCollectionValue, destObj, context);
        } else if (CollectionUtils.isCollection(srcFieldType) && MappingUtils.isSupportedMap(destCollectionType)) {
            result = this.mapListToList(srcObj, srcCollectionValue, fieldMap, destObj, context);
        }
        return result;
    }

    private Object mapMap(Object srcObj, Map srcMapValue, FieldMap fieldMap, Object destObj, MappingContext context) {
        Map result;
        Map destinationMap = (Map)fieldMap.getDestValue(destObj);
        if (destinationMap == null) {
            result = (Map)DestBeanCreator.create(context.getParams(), srcMapValue.getClass());
        } else {
            result = destinationMap;
            if (fieldMap.isRemoveOrphans()) {
                result.clear();
            }
        }
        for (Map.Entry srcEntry : srcMapValue.entrySet()) {
            Object srcEntryValue = srcEntry.getValue();
            if (srcEntryValue == null) {
                result.put(srcEntry.getKey(), null);
                continue;
            }
            Object destEntryValue = this.mapOrRecurseObject(srcObj, srcEntryValue, srcEntryValue.getClass(), destObj, fieldMap, context);
            Object obj = result.get(srcEntry.getKey());
            if (obj != null && obj.equals(destEntryValue) && fieldMap.isNonCumulativeRelationship()) {
                this.map(null, srcEntryValue, obj, false, null, context);
                continue;
            }
            result.put(srcEntry.getKey(), destEntryValue);
        }
        return result;
    }

    private Object mapArrayToArray(Object srcObj, Object srcCollectionValue, FieldMap fieldMap, Object destObj, Class<?> destEntryType, MappingContext context) {
        int size = Array.getLength(srcCollectionValue);
        if (CollectionUtils.isPrimitiveArray(srcCollectionValue.getClass())) {
            return this.addToPrimitiveArray(srcObj, fieldMap, size, srcCollectionValue, destObj, destEntryType, context);
        }
        List<Object> list = Arrays.asList((Object[])srcCollectionValue);
        List<?> returnList = !DozerConstants.BASE_CLASS.equals(destEntryType.getName()) ? this.addOrUpdateToList(srcObj, fieldMap, list, destObj, destEntryType, context) : this.addOrUpdateToList(srcObj, fieldMap, list, destObj, null, context);
        return CollectionUtils.convertListToArray(returnList, destEntryType);
    }

    private void mapFromIterateMethodFieldMap(Object srcObj, Object destObj, Object srcFieldValue, FieldMap fieldMapping, MappingContext context) {
        if (srcFieldValue instanceof Iterator) {
            srcFieldValue = IteratorUtils.toList((Iterator)((Object)srcFieldValue));
        }
        if (srcFieldValue != null) {
            for (int i = 0; i < CollectionUtils.getLengthOfCollection(srcFieldValue); ++i) {
                CustomConverter converter;
                Object value = CollectionUtils.getValueFromCollection(srcFieldValue, i);
                if (fieldMapping.getDestHintContainer() == null) {
                    MappingUtils.throwMappingException("<field type=\"iterate\"> must have a source or destination type hint");
                }
                if ((converter = MappingUtils.findCustomConverter(this.converterByDestTypeCache, this.customConverterObjects, fieldMapping.getClassMap().getCustomConverters(), value.getClass(), fieldMapping.getDestHintContainer().getHint())) != null) {
                    Class<?> srcFieldClass = srcFieldValue.getClass();
                    value = this.mapUsingCustomConverterInstance(converter, srcFieldClass, value, fieldMapping.getDestHintContainer().getHint(), null, fieldMapping, context, false);
                } else {
                    Object alreadyMappedValue = this.mappedFields.getMappedValue(value, fieldMapping.getDestHintContainer().getHint());
                    value = alreadyMappedValue != null ? alreadyMappedValue : this.map(value, fieldMapping.getDestHintContainer().getHint());
                }
                if (value == null) continue;
                this.writeDestinationValue(destObj, value, fieldMapping, srcObj, null);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(LogMsgFactory.createFieldMappingSuccessMsg(srcObj.getClass(), destObj.getClass(), fieldMapping.getSrcFieldName(), fieldMapping.getDestFieldName(), srcFieldValue, null, fieldMapping.getClassMap().getMapId()));
        }
    }

    private Object addToPrimitiveArray(Object srcObj, FieldMap fieldMap, int size, Object srcCollectionValue, Object destObj, Class<?> destEntryType, MappingContext context) {
        Object result;
        Object field = fieldMap.getDestValue(destObj);
        int arraySize = 0;
        if (field == null) {
            result = Array.newInstance(destEntryType, size);
        } else {
            result = Array.newInstance(destEntryType, size + Array.getLength(field));
            arraySize = Array.getLength(field);
            System.arraycopy(field, 0, result, 0, arraySize);
        }
        for (int i = 0; i < size; ++i) {
            CopyByReferenceContainer copyByReferences = this.globalConfiguration.getCopyByReferences();
            Object toValue = srcCollectionValue != null && copyByReferences.contains(srcCollectionValue.getClass()) ? srcCollectionValue : this.mapOrRecurseObject(srcObj, Array.get(srcCollectionValue, i), destEntryType, destObj, fieldMap, context);
            Array.set(result, arraySize, toValue);
            ++arraySize;
        }
        return result;
    }

    private Object mapListToArray(Object srcObj, Collection<?> srcCollectionValue, FieldMap fieldMap, Object destObj, MappingContext context) {
        Class<?> destEntryType = fieldMap.getDestFieldType(destObj.getClass()).getComponentType();
        List<?> list = !destEntryType.getName().equals(DozerConstants.BASE_CLASS) ? this.addOrUpdateToList(srcObj, fieldMap, srcCollectionValue, destObj, destEntryType, context) : this.addOrUpdateToList(srcObj, fieldMap, srcCollectionValue, destObj, context);
        return CollectionUtils.convertListToArray(list, destEntryType);
    }

    private List<?> mapListToList(Object srcObj, Collection<?> srcCollectionValue, FieldMap fieldMap, Object destObj, MappingContext context) {
        return this.addOrUpdateToList(srcObj, fieldMap, srcCollectionValue, destObj, context);
    }

    private Set<?> addToSet(Object srcObj, FieldMap fieldMap, Collection<?> srcCollectionValue, Object destObj, MappingContext context) {
        HashSet<Object> mappedElements = new HashSet<Object>();
        Class<?> destEntryType = null;
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        Object field = fieldMap.getDestValue(destObj);
        if (field != null) {
            result.addAll((Collection)field);
        }
        Class<?> prevDestEntryType = null;
        for (Object srcValue : srcCollectionValue) {
            if (destEntryType == null || fieldMap.getDestHintContainer() != null && fieldMap.getDestHintContainer().hasMoreThanOneHint()) {
                destEntryType = srcValue == null ? prevDestEntryType : fieldMap.getDestHintType(srcValue.getClass());
            }
            CopyByReferenceContainer copyByReferences = this.globalConfiguration.getCopyByReferences();
            Object destValue = srcValue != null && copyByReferences.contains(srcValue.getClass()) ? srcValue : this.mapOrRecurseObject(srcObj, srcValue, destEntryType, destObj, fieldMap, context);
            prevDestEntryType = destEntryType;
            if ((this.usesCollectionItemDiscriminator(fieldMap) || RelationshipType.NON_CUMULATIVE.equals(fieldMap.getRelationshipType())) && result.contains(destValue)) {
                ArrayList resultAsList = new ArrayList(result);
                int index = resultAsList.indexOf(destValue);
                Object obj = resultAsList.get(index);
                if (obj.getClass().isAssignableFrom(String.class)) continue;
                this.map(null, srcValue, obj, false, null, context);
                mappedElements.add(obj);
                continue;
            }
            result.add(destValue);
            mappedElements.add(destValue);
        }
        if (fieldMap.isRemoveOrphans()) {
            result.clear();
            result.addAll(mappedElements);
        }
        if (field == null) {
            Class<?> destSetType = fieldMap.getDestFieldType(destObj.getClass());
            return CollectionUtils.createNewSet(destSetType, result);
        }
        ((Set)field).clear();
        ((Set)field).addAll(result);
        return (Set)field;
    }

    private List<?> addOrUpdateToList(Object srcObj, FieldMap fieldMap, Collection<?> srcCollectionValue, Object destObj, Class<?> destEntryType, MappingContext context) {
        ArrayList<Object> mappedElements = new ArrayList<Object>();
        Object field = fieldMap.getDestValue(destObj);
        List<Object> result = MappingProcessor.prepareDestinationList(srcCollectionValue, field);
        Class<?> prevDestEntryType = null;
        for (Object srcValue : srcCollectionValue) {
            if (destEntryType == null || fieldMap.getDestHintContainer() != null && fieldMap.getDestHintContainer().hasMoreThanOneHint()) {
                destEntryType = srcValue == null ? prevDestEntryType : fieldMap.getDestHintType(srcValue.getClass());
            }
            CopyByReferenceContainer copyByReferences = this.globalConfiguration.getCopyByReferences();
            Object destValue = srcValue != null && copyByReferences.contains(srcValue.getClass()) ? srcValue : this.mapOrRecurseObject(srcObj, srcValue, destEntryType, destObj, fieldMap, context);
            prevDestEntryType = destEntryType;
            if ((this.usesCollectionItemDiscriminator(fieldMap) || RelationshipType.NON_CUMULATIVE.equals(fieldMap.getRelationshipType())) && result.contains(destValue)) {
                int index = result.indexOf(destValue);
                Object obj = result.get(index);
                if (obj == null || obj.getClass().isAssignableFrom(String.class)) continue;
                this.map(null, srcValue, obj, false, null, context);
                mappedElements.add(obj);
                continue;
            }
            result.add(destValue);
            mappedElements.add(destValue);
        }
        if (fieldMap.isRemoveOrphans()) {
            MappingProcessor.removeOrphans(mappedElements, result);
        }
        return result;
    }

    private boolean usesCollectionItemDiscriminator(FieldMap fieldMap) {
        return !MappingUtils.isBlankOrNull(fieldMap.getCollectionItemDiscriminatorId()) || !MappingUtils.isBlankOrNull(fieldMap.getCollectionItemDiscriminator());
    }

    private List<?> addOrUpdateToList(Object srcObj, FieldMap fieldMap, Collection<?> srcCollectionValue, Object destObj, MappingContext context) {
        return this.addOrUpdateToList(srcObj, fieldMap, srcCollectionValue, destObj, null, context);
    }

    private Object mapSetToArray(Object srcObj, Collection<?> srcCollectionValue, FieldMap fieldMap, Object destObj, MappingContext context) {
        return this.mapListToArray(srcObj, srcCollectionValue, fieldMap, destObj, context);
    }

    private List<?> mapArrayToList(Object srcObj, Object srcCollectionValue, FieldMap fieldMap, Object destObj, MappingContext context) {
        Class<?> destEntryType = fieldMap.getDestHintContainer() != null ? fieldMap.getDestHintContainer().getHint() : srcCollectionValue.getClass().getComponentType();
        List<Object> srcValueList = CollectionUtils.isPrimitiveArray(srcCollectionValue.getClass()) ? CollectionUtils.convertPrimitiveArrayToList(srcCollectionValue) : Arrays.asList((Object[])srcCollectionValue);
        return this.addOrUpdateToList(srcObj, fieldMap, srcValueList, destObj, destEntryType, context);
    }

    private void writeDestinationValue(Object destObj, Object destFieldValue, FieldMap fieldMap, Object srcObj, Object defaultDestValue) {
        boolean bypass = false;
        if (destFieldValue == null && defaultDestValue != null) {
            destFieldValue = defaultDestValue;
        }
        if (destFieldValue == null && !fieldMap.isDestMapNull()) {
            bypass = true;
        }
        if (destFieldValue == null && fieldMap.isDestFieldRequired()) {
            throw new MappingException(String.format("Destination field '%s' cannot be null", fieldMap.getDestFieldCopy().getName()));
        }
        if (destFieldValue != null && !fieldMap.isDestMapEmptyString() && destFieldValue.getClass().equals(String.class) && StringUtils.isEmpty((String)((String)destFieldValue))) {
            bypass = true;
        }
        if (destFieldValue != null && fieldMap.isTrimStrings() && destFieldValue.getClass().equals(String.class)) {
            destFieldValue = ((String)destFieldValue).trim();
        }
        if (!bypass) {
            this.eventMgr.fireEvent(new DozerEvent(DozerEventType.MAPPING_PRE_WRITING_DEST_VALUE, fieldMap.getClassMap(), fieldMap, srcObj, destObj, destFieldValue));
            fieldMap.writeDestValue(destObj, destFieldValue);
            this.eventMgr.fireEvent(new DozerEvent(DozerEventType.MAPPING_POST_WRITING_DEST_VALUE, fieldMap.getClassMap(), fieldMap, srcObj, destObj, destFieldValue));
        }
    }

    private Object mapUsingCustomConverterInstance(CustomConverter converterInstance, Class<?> srcFieldClass, Object srcFieldValue, Class<?> destFieldClass, Object existingDestFieldValue, FieldMap fieldMap, MappingContext context, boolean topLevel) {
        Object result;
        Object theConverter;
        long start = System.currentTimeMillis();
        if (converterInstance instanceof MapperAware) {
            ((MapperAware)((Object)converterInstance)).setMapper(this);
        }
        if (converterInstance instanceof ConfigurableCustomConverter) {
            theConverter = (ConfigurableCustomConverter)converterInstance;
            if (fieldMap != null) {
                String param = fieldMap.getCustomConverterParam();
                theConverter.setParameter(param);
            }
        }
        if (converterInstance instanceof MappingParamsAware) {
            theConverter = (MappingParamsAware)((Object)converterInstance);
            theConverter.setMappingParams(context.getParams());
        }
        if (topLevel) {
            result = converterInstance.convert(existingDestFieldValue, srcFieldValue, destFieldClass, srcFieldClass);
        } else {
            Object existingValue = this.getExistingValue(fieldMap, srcFieldClass, srcFieldValue, existingDestFieldValue, destFieldClass, context);
            result = converterInstance.convert(existingValue, srcFieldValue, destFieldClass, srcFieldClass);
        }
        long stop = System.currentTimeMillis();
        this.statsMgr.increment(StatisticType.CUSTOM_CONVERTER_SUCCESS_COUNT);
        this.statsMgr.increment(StatisticType.CUSTOM_CONVERTER_TIME, stop - start);
        return result;
    }

    private Object mapUsingCustomConverter(Class<?> customConverterClass, Class<?> srcFieldClass, Object srcFieldValue, Class<?> destFieldClass, Object existingDestFieldValue, FieldMap fieldMap, MappingContext context, boolean topLevel) {
        CustomConverter converterInstance = MappingUtils.findCustomConverterByClass(customConverterClass, this.customConverterObjects);
        return this.mapUsingCustomConverterInstance(converterInstance, srcFieldClass, srcFieldValue, destFieldClass, existingDestFieldValue, fieldMap, context, topLevel);
    }

    private Collection<ClassMap> checkForSuperTypeMapping(Class<?> srcClass, Class<?> destClass) {
        Object cacheKey = CacheKeyFactory.createKey(destClass, srcClass);
        Collection cachedResult = (Collection)this.superTypeCache.get(cacheKey);
        if (cachedResult != null) {
            return cachedResult;
        }
        ArrayList<ClassMap> superClasses = new ArrayList<ClassMap>();
        List<Class<?>> superSrcClasses = MappingUtils.getSuperClassesAndInterfaces(srcClass);
        List<Class<?>> superDestClasses = MappingUtils.getSuperClassesAndInterfaces(destClass);
        superSrcClasses.add(0, srcClass);
        superDestClasses.add(0, destClass);
        for (Class<?> superSrcClass : superSrcClasses) {
            for (Class<?> superDestClass : superDestClasses) {
                if (superSrcClass.equals(srcClass) && superDestClass.equals(destClass)) continue;
                this.checkForClassMapping(superSrcClass, superClasses, superDestClass);
            }
        }
        Collections.reverse(superClasses);
        this.superTypeCache.put(cacheKey, superClasses);
        return superClasses;
    }

    private void checkForClassMapping(Class<?> srcClass, List<ClassMap> superClasses, Class<?> superDestClass) {
        ClassMap srcClassMap = this.classMappings.find(srcClass, superDestClass);
        if (srcClassMap != null) {
            superClasses.add(srcClassMap);
        }
    }

    private List<String> processSuperTypeMapping(Collection<ClassMap> superClasses, Object srcObj, Object destObj, String mapId, MappingContext context, List<String> overriddenFieldMappings) {
        ArrayList<String> mappedFieldKeys = new ArrayList<String>();
        for (ClassMap map : superClasses) {
            ClassMap copy = map.copyOf();
            this.removeOverriddenFieldMappings(copy, overriddenFieldMappings, destObj);
            this.map(copy, srcObj, destObj, true, mapId, context);
            for (FieldMap fieldMapping : copy.getFieldMaps()) {
                String key = MappingUtils.getMappedParentFieldKey(destObj, fieldMapping);
                mappedFieldKeys.add(key);
            }
        }
        return mappedFieldKeys;
    }

    private void removeOverriddenFieldMappings(ClassMap copy, List<String> overriddenFieldMappings, Object destObj) {
        ArrayList<FieldMap> result = new ArrayList<FieldMap>();
        for (FieldMap fieldMap : copy.getFieldMaps()) {
            String key = MappingUtils.getMappedParentFieldKey(destObj, fieldMap);
            if (overriddenFieldMappings.contains(key)) continue;
            result.add(fieldMap);
        }
        copy.setFieldMaps(result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getExistingValue(FieldMap fieldMap, Class<?> srcFieldType, Object srcFieldValue, Object destObj, Class<?> destFieldType, MappingContext context) {
        if (destObj == null) {
            return null;
        }
        Object result = fieldMap.getDestValue(destObj);
        if (result == null) return result;
        if (!(CollectionUtils.isList(result.getClass()) || CollectionUtils.isArray(result.getClass()) || CollectionUtils.isSet(result.getClass()))) {
            if (!MappingUtils.isSupportedMap(result.getClass())) return result;
        }
        if (CollectionUtils.isList(destFieldType)) return result;
        if (CollectionUtils.isArray(destFieldType)) return result;
        if (CollectionUtils.isSet(destFieldType)) return result;
        if (MappingUtils.isSupportedMap(destFieldType)) return result;
        if (!MappingUtils.isBlankOrNull(fieldMap.getCollectionItemDiscriminatorId())) {
            if (this.collectionItemDiscriminatorObjectsWithId == null) throw new MappingException("Cannot find collection item discriminator instance with id:" + fieldMap.getCollectionItemDiscriminatorId());
            if (!this.collectionItemDiscriminatorObjectsWithId.containsKey(fieldMap.getCollectionItemDiscriminatorId())) throw new MappingException("Cannot find collection item discriminator instance with id:" + fieldMap.getCollectionItemDiscriminatorId());
            if (this.collectionItemDiscriminatorObjectsWithId.get(fieldMap.getCollectionItemDiscriminatorId()) == null) throw new MappingException("Cannot find collection item discriminator instance with id:" + fieldMap.getCollectionItemDiscriminatorId());
            CollectionItemDiscriminator discriminatorInstance = this.collectionItemDiscriminatorObjectsWithId.get(fieldMap.getCollectionItemDiscriminatorId());
            return this.evaluateCollectionItemDiscriminatorInstance(discriminatorInstance, srcFieldType, srcFieldValue, destFieldType, result, context);
        }
        if (MappingUtils.isBlankOrNull(fieldMap.getCollectionItemDiscriminator())) return null;
        Class<?> discriminatorClass = MappingUtils.loadClass(fieldMap.getCollectionItemDiscriminator());
        return this.evaluateCollectionItemDiscriminator(discriminatorClass, srcFieldType, srcFieldValue, destFieldType, result, fieldMap, context);
    }

    private ClassMap getClassMap(Class<?> srcClass, Class<?> destClass, String mapId) {
        ClassMap mapping;
        block5: {
            mapping = null;
            try {
                mapping = this.classMappings.find(srcClass, destClass, mapId);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug(String.format("Class map is not found: SRC_CLASS=%s -> DEST_CLASS=%s MapId=%s", srcClass.getName(), destClass.getName(), mapId));
            }
        }
        if (mapping == null && !MappingUtils.isBlankOrNull(mapId)) {
            mapping = this.classMappings.find(srcClass, destClass);
        }
        if (mapping == null) {
            mapping = ClassMapBuilder.createDefaultClassMap(this.globalConfiguration, srcClass, destClass);
            this.classMappings.addDefault(srcClass, destClass, mapping);
            if (log.isDebugEnabled()) {
                log.warn(String.format("Class map is not found: SRC_CLASS=%s -> DEST_CLASS=%s", srcClass.getName(), destClass.getName(), mapId));
            }
        }
        return mapping;
    }

    private String getMapId(MappingContext context) {
        if (context != null) {
            return context.getMapId();
        }
        return null;
    }

    private boolean canGetNewMapId(Object source, Object dest, MappingContext context, FieldMap fieldMap) {
        Class<?> srcClass = source != null ? source.getClass() : null;
        Class<?> destClass = dest != null ? dest.getClass() : null;
        return this.mapIdConverterAggregator != null && this.mapIdConverterAggregator.canConvert(context.getParams(), dest, source, destClass, srcClass);
    }

    private String getMapId(Object source, Object dest, MappingContext context, FieldMap fieldMap) {
        Class<?> srcClass = source != null ? source.getClass() : null;
        Class<?> destClass = dest != null ? dest.getClass() : null;
        return this.mapIdConverterAggregator.convert(context.getParams(), dest, source, (Class)destClass, (Class)srcClass);
    }
}

