/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.fieldmap;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dozer.MappingException;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.DozerClass;
import org.dozer.classmap.MappingDirection;
import org.dozer.classmap.RelationshipType;
import org.dozer.fieldmap.DozerField;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.DozerPropertyDescriptor;
import org.dozer.propertydescriptor.GetterSetterPropertyDescriptor;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.dozer.util.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldMap
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(FieldMap.class);
    private final ConcurrentMap<Class<?>, DozerPropertyDescriptor> srcPropertyDescriptorMap = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, DozerPropertyDescriptor> destPropertyDescriptorMap = new ConcurrentHashMap();
    private ClassMap classMap;
    private DozerField srcField;
    private DozerField destField;
    private MappingDirection type;
    private boolean copyByReference;
    private boolean copyByReferenceOveridden;
    private String mapId;
    private String customConverter;
    private String customConverterId;
    private String customConverterParam;
    private RelationshipType relationshipType;
    private boolean removeOrphans;
    private String mappingCondition;
    private String mappingConditionId;
    private String collectionItemDiscriminator;
    private String collectionItemDiscriminatorId;
    private Boolean mapNull;
    private Boolean mapEmptyString;
    private Boolean trimString;

    public FieldMap(ClassMap classMap) {
        this.classMap = classMap;
    }

    public ClassMap getClassMap() {
        return this.classMap;
    }

    public void setClassMap(ClassMap classMap) {
        this.classMap = classMap;
    }

    public Object getSrcFieldValue(Object runtimeSrcObj) {
        return this.getSrcPropertyDescriptor(runtimeSrcObj.getClass()).getPropertyValue(runtimeSrcObj);
    }

    public void writeDestValue(Object runtimeDestObj, Object destFieldValue) {
        if (log.isDebugEnabled()) {
            String className = MappingUtils.getClassNameWithoutPackage(runtimeDestObj.getClass());
            log.debug("Getting ready to invoke write method on the destination object. Dest Obj: {}, Dest value: {}", (Object)className, destFieldValue);
        }
        DozerPropertyDescriptor propDescriptor = this.getDestPropertyDescriptor(runtimeDestObj.getClass());
        propDescriptor.setPropertyValue(runtimeDestObj, destFieldValue, this);
    }

    public Class<?> getDestHintType(Class<?> runtimeSrcClass) {
        if (this.getDestHintContainer() != null) {
            if (this.getSrcHintContainer() != null) {
                return this.getDestHintContainer().getHint(runtimeSrcClass, this.getSrcHintContainer().getHints());
            }
            return this.getDestHintContainer().getHint();
        }
        return runtimeSrcClass;
    }

    public Class<?> getDestFieldType(Class<?> runtimeDestClass) {
        Class<Object> result = this.getDestPropertyDescriptor(runtimeDestClass).getPropertyType();
        if (this.isDestFieldIndexed()) {
            HintContainer hintContainer = this.destField.getHintContainer();
            result = hintContainer != null ? hintContainer.getHint() : (result.isArray() || Collection.class.isAssignableFrom(result) && MappingUtils.getSupportedCollectionEntryType(this.getDestPropertyDescriptor(runtimeDestClass)) != null ? MappingUtils.getSupportedCollectionEntryType(this.getDestPropertyDescriptor(runtimeDestClass)) : Object.class);
        }
        return result;
    }

    public Class<?> getSrcFieldType(Class<?> runtimeSrcClass) {
        return this.getSrcPropertyDescriptor(runtimeSrcClass).getPropertyType();
    }

    @Deprecated
    public Method getDestFieldWriteMethod(Class<?> runtimeDestClass) {
        DozerPropertyDescriptor dpd = this.getDestPropertyDescriptor(runtimeDestClass);
        Method result = null;
        try {
            result = ((GetterSetterPropertyDescriptor)dpd).getWriteMethod();
        }
        catch (Exception e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    public Class<?> getGenericType(Class<?> runtimeDestClass) {
        DozerPropertyDescriptor propertyDescriptor = this.getDestPropertyDescriptor(runtimeDestClass);
        return propertyDescriptor.genericType();
    }

    public Object getDestValue(Object runtimeDestObj) {
        return this.getDestPropertyDescriptor(runtimeDestObj.getClass()).getPropertyValue(runtimeDestObj);
    }

    public HintContainer getDestHintContainer() {
        return this.destField.getHintContainer();
    }

    public void setDestHintContainer(HintContainer destHint) {
        this.destField.setHintContainer(destHint);
    }

    public HintContainer getSrcHintContainer() {
        return this.srcField.getHintContainer();
    }

    public void setSrcHintContainer(HintContainer sourceHint) {
        this.srcField.setHintContainer(sourceHint);
    }

    public String getSrcFieldMapGetMethod() {
        return !MappingUtils.isBlankOrNull(this.srcField.getMapGetMethod()) ? this.srcField.getMapGetMethod() : this.classMap.getSrcClassMapGetMethod();
    }

    public String getSrcFieldMapSetMethod() {
        return !MappingUtils.isBlankOrNull(this.srcField.getMapSetMethod()) ? this.srcField.getMapSetMethod() : this.classMap.getSrcClassMapSetMethod();
    }

    public String getDestFieldMapGetMethod() {
        return !MappingUtils.isBlankOrNull(this.destField.getMapGetMethod()) ? this.destField.getMapGetMethod() : this.classMap.getDestClassMapGetMethod();
    }

    public String getDestFieldMapSetMethod() {
        return !MappingUtils.isBlankOrNull(this.destField.getMapSetMethod()) ? this.destField.getMapSetMethod() : this.classMap.getDestClassMapSetMethod();
    }

    public String getSrcFieldName() {
        return this.srcField.getName();
    }

    public String getDestFieldName() {
        return this.destField.getName();
    }

    public String getDestFieldType() {
        return this.destField.getType();
    }

    public String getSrcFieldType() {
        return this.srcField.getType();
    }

    public String getDateFormat() {
        if (!MappingUtils.isBlankOrNull(this.destField.getDateFormat())) {
            return this.destField.getDateFormat();
        }
        if (!MappingUtils.isBlankOrNull(this.srcField.getDateFormat())) {
            return this.srcField.getDateFormat();
        }
        return this.classMap.getDateFormat();
    }

    public String getDestFieldCreateMethod() {
        return this.destField.getCreateMethod();
    }

    public String getSrcFieldCreateMethod() {
        return this.srcField.getCreateMethod();
    }

    public boolean isDestFieldIndexed() {
        return this.destField.isIndexed();
    }

    public boolean isSrcFieldIndexed() {
        return this.srcField.isIndexed();
    }

    public String getSrcFieldIndex() {
        return this.srcField.getIndex();
    }

    public String getDestFieldIndex() {
        return this.destField.getIndex();
    }

    public String getSrcFieldTheGetMethod() {
        return this.srcField.getTheGetMethod();
    }

    public String getDestFieldTheGetMethod() {
        return this.destField.getTheGetMethod();
    }

    public String getSrcFieldTheSetMethod() {
        return this.srcField.getTheSetMethod();
    }

    public String getDestFieldTheSetMethod() {
        return this.destField.getTheSetMethod();
    }

    public String getSrcFieldKey() {
        return this.srcField.getKey();
    }

    public String getDestFieldKey() {
        return this.destField.getKey();
    }

    public boolean isDestFieldAccessible() {
        return this.determineAccess(this.destField, this.classMap.getDestClass());
    }

    public boolean isSrcFieldAccessible() {
        return this.determineAccess(this.srcField, this.classMap.getSrcClass());
    }

    private boolean determineAccess(DozerField field, DozerClass clazz) {
        Boolean fieldLevel = field.isAccessible();
        if (fieldLevel != null) {
            return fieldLevel;
        }
        Boolean classLevel = clazz.isAccesible();
        if (classLevel == null) {
            return false;
        }
        return classLevel;
    }

    public boolean isDestFieldRequired() {
        return this.destField.isRequired();
    }

    public String getDestFieldDefaultValue() {
        return this.destField.getDefaultValue();
    }

    public HintContainer getDestDeepIndexHintContainer() {
        return this.destField.getDeepIndexHintContainer();
    }

    public void setDestDeepIndexHintContainer(HintContainer destDeepIndexHintHint) {
        this.destField.setDeepIndexHintContainer(destDeepIndexHintHint);
    }

    public HintContainer getSrcDeepIndexHintContainer() {
        return this.srcField.getDeepIndexHintContainer();
    }

    public void setSrcDeepIndexHintContainer(HintContainer srcDeepIndexHint) {
        this.srcField.setDeepIndexHintContainer(srcDeepIndexHint);
    }

    public Object clone() {
        Object result = null;
        try {
            result = super.clone();
        }
        catch (CloneNotSupportedException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    public MappingDirection getType() {
        return this.type;
    }

    public void setType(MappingDirection type) {
        this.type = type;
    }

    public boolean isCopyByReference() {
        return this.copyByReference;
    }

    public void setCopyByReference(boolean copyByReference) {
        this.copyByReference = copyByReference;
        this.copyByReferenceOveridden = true;
    }

    protected boolean isSrcSelfReferencing() {
        return this.getSrcFieldName().equals("this");
    }

    protected boolean isDestSelfReferencing() {
        return this.getDestFieldName().equals("this");
    }

    public boolean isCopyByReferenceOveridden() {
        return this.copyByReferenceOveridden;
    }

    public String getMapId() {
        return this.mapId;
    }

    public void setMapId(String mapId) {
        this.mapId = mapId;
    }

    public String getCustomConverter() {
        return this.customConverter;
    }

    public void setCustomConverter(String customConverter) {
        this.customConverter = customConverter;
    }

    public RelationshipType getRelationshipType() {
        return this.relationshipType != null ? this.relationshipType : this.classMap.getRelationshipType();
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        this.relationshipType = relationshipType;
    }

    public void validate() {
        if (this.srcField == null || MappingUtils.isBlankOrNull(this.srcField.getName())) {
            MappingUtils.throwMappingException("src field must be specified");
        }
        if (this.destField == null || MappingUtils.isBlankOrNull(this.destField.getName())) {
            MappingUtils.throwMappingException("dest field must be specified");
        }
    }

    public DozerPropertyDescriptor getSrcPropertyDescriptor(Class<?> runtimeSrcClass) {
        DozerPropertyDescriptor result = (DozerPropertyDescriptor)this.srcPropertyDescriptorMap.get(runtimeSrcClass);
        if (result == null) {
            String srcFieldMapGetMethod = this.getSrcFieldMapGetMethod();
            String srcFieldMapSetMethod = this.getSrcFieldMapSetMethod();
            DozerPropertyDescriptor descriptor = PropertyDescriptorFactory.getPropertyDescriptor(runtimeSrcClass, this.getSrcFieldTheGetMethod(), this.getSrcFieldTheSetMethod(), srcFieldMapGetMethod, srcFieldMapSetMethod, this.isSrcFieldAccessible(), this.isSrcFieldIndexed(), this.getSrcFieldIndex(), this.getSrcFieldName(), this.getSrcFieldKey(), this.isSrcSelfReferencing(), this.getDestFieldName(), this.getSrcDeepIndexHintContainer(), this.classMap.getSrcClassBeanFactory());
            this.srcPropertyDescriptorMap.putIfAbsent(runtimeSrcClass, descriptor);
            result = descriptor;
        }
        return result;
    }

    public DozerPropertyDescriptor getDestPropertyDescriptor(Class<?> runtimeDestClass) {
        DozerPropertyDescriptor result = (DozerPropertyDescriptor)this.destPropertyDescriptorMap.get(runtimeDestClass);
        if (result == null) {
            DozerPropertyDescriptor descriptor = PropertyDescriptorFactory.getPropertyDescriptor(runtimeDestClass, this.getDestFieldTheGetMethod(), this.getDestFieldTheSetMethod(), this.getDestFieldMapGetMethod(), this.getDestFieldMapSetMethod(), this.isDestFieldAccessible(), this.isDestFieldIndexed(), this.getDestFieldIndex(), this.getDestFieldName(), this.getDestFieldKey(), this.isDestSelfReferencing(), this.getSrcFieldName(), this.getDestDeepIndexHintContainer(), this.classMap.getDestClassBeanFactory());
            this.destPropertyDescriptorMap.putIfAbsent(runtimeDestClass, descriptor);
            result = descriptor;
        }
        return result;
    }

    public DozerField getSrcFieldCopy() {
        try {
            return (DozerField)this.srcField.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new MappingException(e);
        }
    }

    public DozerField getDestFieldCopy() {
        try {
            return (DozerField)this.destField.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new MappingException(e);
        }
    }

    protected DozerField getSrcField() {
        return this.srcField;
    }

    public void setSrcField(DozerField sourceField) {
        this.srcField = sourceField;
    }

    protected DozerField getDestField() {
        return this.destField;
    }

    public void setDestField(DozerField destField) {
        this.destField = destField;
    }

    public String getCustomConverterId() {
        return this.customConverterId;
    }

    public void setCustomConverterId(String customConverterId) {
        this.customConverterId = customConverterId;
    }

    public boolean isRemoveOrphans() {
        return this.removeOrphans;
    }

    public void setRemoveOrphans(boolean removeOrphans) {
        this.removeOrphans = removeOrphans;
    }

    public boolean isDestMapNull() {
        return this.mapNull != null ? this.mapNull.booleanValue() : this.classMap.isDestMapNull();
    }

    public boolean isDestMapEmptyString() {
        return this.mapEmptyString != null ? this.mapEmptyString.booleanValue() : this.classMap.isDestMapEmptyString();
    }

    public boolean isTrimStrings() {
        return this.trimString != null ? this.trimString.booleanValue() : this.classMap.isTrimStrings();
    }

    public boolean isStopOnErrors() {
        return this.classMap.isStopOnErrors();
    }

    public boolean isNonCumulativeRelationship() {
        return RelationshipType.NON_CUMULATIVE.equals(this.relationshipType);
    }

    public void setMapNull(boolean mapNull) {
        this.mapNull = mapNull;
    }

    public void setMapEmptyString(boolean mapEmptyString) {
        this.mapEmptyString = mapEmptyString;
    }

    public void setTrimString(boolean trimString) {
        this.trimString = trimString;
    }

    public String getCustomConverterParam() {
        return this.customConverterParam;
    }

    public void setCustomConverterParam(String customConverterParam) {
        this.customConverterParam = customConverterParam;
    }

    public String getMappingCondition() {
        return this.mappingCondition;
    }

    public void setMappingCondition(String mapCondition) {
        this.mappingCondition = mapCondition;
    }

    public String getMappingConditionId() {
        return this.mappingConditionId;
    }

    public void setMappingConditionId(String mapConditionId) {
        this.mappingConditionId = mapConditionId;
    }

    public String getCollectionItemDiscriminator() {
        return this.collectionItemDiscriminator;
    }

    public void setCollectionItemDiscriminator(String collectionItemDiscriminator) {
        this.collectionItemDiscriminator = collectionItemDiscriminator;
    }

    public String getCollectionItemDiscriminatorId() {
        return this.collectionItemDiscriminatorId;
    }

    public void setCollectionItemDiscriminatorId(String collectionItemDiscriminatorId) {
        this.collectionItemDiscriminatorId = collectionItemDiscriminatorId;
    }

    protected ConcurrentMap<Class<?>, DozerPropertyDescriptor> getSrcPropertyDescriptorMap() {
        return this.srcPropertyDescriptorMap;
    }

    protected ConcurrentMap<Class<?>, DozerPropertyDescriptor> getDestPropertyDescriptorMap() {
        return this.destPropertyDescriptorMap;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("source field", (Object)this.srcField).append("destination field", (Object)this.destField).append("type", (Object)this.type).append("customConverter", (Object)this.customConverter).append("relationshipType", (Object)this.relationshipType).append("removeOrphans", this.removeOrphans).append("mapId", (Object)this.mapId).append("copyByReference", this.copyByReference).append("mapNull", (Object)this.mapNull).append("mapEmptyString", (Object)this.mapEmptyString).append("trimString", (Object)this.trimString).append("copyByReferenceOveridden", this.copyByReferenceOveridden).append("srcTypeHint", (Object)this.getSrcHintContainer()).append("destTypeHint", (Object)this.getDestHintContainer()).append("mapCondition", (Object)this.mappingCondition).append("mapConditionId", (Object)this.mappingConditionId).append("collectionItemDiscriminator", (Object)this.collectionItemDiscriminator).append("collectionItemDiscriminatorId", (Object)this.collectionItemDiscriminatorId).toString();
    }
}

