/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.propertydescriptor;

import org.apache.commons.lang.ArrayUtils;
import org.dozer.fieldmap.FieldMap;
import org.dozer.propertydescriptor.DozerPropertyDescriptor;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFieldsPropertyDescriptor
implements DozerPropertyDescriptor {
    private DozerPropertyDescriptor[] propertyDescriptors;

    public MultiFieldsPropertyDescriptor(DozerPropertyDescriptor[] propertyDescriptors) {
        this.propertyDescriptors = propertyDescriptors;
    }

    @Override
    public Class<?> genericType() {
        return Object.class;
    }

    @Override
    public Class<?> getPropertyType() {
        return Object[].class;
    }

    @Override
    public Object getPropertyValue(Object bean) {
        Object[] values = new Object[this.propertyDescriptors.length];
        for (int i = 0; i < this.propertyDescriptors.length; ++i) {
            values[i] = this.propertyDescriptors[i].getPropertyValue(bean);
        }
        return values;
    }

    @Override
    public void setPropertyValue(Object bean, Object value, FieldMap fieldMap) {
        if (!ReflectionUtils.isArray(value) || ArrayUtils.getLength((Object)value) != this.propertyDescriptors.length) {
            MappingUtils.throwMappingException(String.format("Cannot set value to property '%s'", fieldMap));
        }
        Object[] values = (Object[])value;
        for (int i = 0; i < this.propertyDescriptors.length; ++i) {
            DozerPropertyDescriptor propertyDescriptor = this.propertyDescriptors[i];
            propertyDescriptor.setPropertyValue(bean, values[i], fieldMap);
        }
    }
}

