/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.propertydescriptor;

import java.util.List;
import org.dozer.classmap.ClassMap;
import org.dozer.fieldmap.DozerField;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.CustomGetSetPropertyDescriptor;
import org.dozer.propertydescriptor.DozerPropertyDescriptor;
import org.dozer.propertydescriptor.EmptyFieldPropertyDescriptor;
import org.dozer.propertydescriptor.FieldPropertyDescriptor;
import org.dozer.propertydescriptor.JavaBeanPropertyDescriptor;
import org.dozer.propertydescriptor.MapPropertyDescriptor;
import org.dozer.propertydescriptor.MultiFieldsPropertyDescriptor;
import org.dozer.propertydescriptor.SelfPropertyDescriptor;
import org.dozer.propertydescriptor.XmlBeanPropertyDescriptor;
import org.dozer.util.DozerConstants;
import org.dozer.util.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyDescriptorFactory {
    private static Logger LOG = LoggerFactory.getLogger(PropertyDescriptorFactory.class);

    private PropertyDescriptorFactory() {
    }

    public static DozerPropertyDescriptor getPropertyDescriptor(Class<?> clazz, ClassMap classMap, List<DozerField> srcFields, DozerField dest) {
        DozerPropertyDescriptor[] propertyDescriptors = new DozerPropertyDescriptor[srcFields.size()];
        for (int i = 0; i < srcFields.size(); ++i) {
            propertyDescriptors[i] = PropertyDescriptorFactory.getPropertyDescriptor(clazz, classMap, srcFields.get(i), dest);
        }
        return new MultiFieldsPropertyDescriptor(propertyDescriptors);
    }

    public static DozerPropertyDescriptor getPropertyDescriptor(Class<?> clazz, ClassMap classMap, DozerField src, DozerField dest) {
        if (MappingUtils.isBlankOrNull(src.getName())) {
            return new EmptyFieldPropertyDescriptor();
        }
        LOG.info("clazz = " + clazz.getName());
        LOG.info("src.getTheGetMethod() = " + src.getTheGetMethod());
        LOG.info("src.getTheSetMethod() = " + src.getTheSetMethod());
        LOG.info("src.getMapGetMethod() = " + src.getMapGetMethod());
        LOG.info("src.getMapSetMethod() = " + src.getMapSetMethod());
        LOG.info("src.isAccessible() = " + src.isAccessible());
        LOG.info("src.isIndexed() = " + src.isIndexed());
        LOG.info("src.getIndex() = " + src.getIndex());
        LOG.info("src.getName() = " + src.getName());
        LOG.info("src.getKey() = " + src.getKey());
        LOG.info("src.isSelfReferenced() = " + src.isSelfReferenced());
        LOG.info("src.getName() = " + src.getName());
        LOG.info("src.getDeepIndexHintContainer() = " + src.getDeepIndexHintContainer());
        LOG.info("classMap.getDestClassBeanFactory() = " + classMap.getDestClassBeanFactory());
        return PropertyDescriptorFactory.getPropertyDescriptor(clazz, src.getTheGetMethod(), src.getTheSetMethod(), src.getMapGetMethod(), src.getMapSetMethod(), src.isAccessible(), src.isIndexed(), src.getIndex(), src.getName(), src.getKey(), src.isSelfReferenced(), src.getName(), src.getDeepIndexHintContainer(), classMap.getDestClassBeanFactory());
    }

    public static DozerPropertyDescriptor getPropertyDescriptor(Class<?> clazz, String theGetMethod, String theSetMethod, String mapGetMethod, String mapSetMethod, boolean isAccessible, boolean isIndexed, String index, String name, String key, boolean isSelfReferencing, String oppositeFieldName, HintContainer deepIndexHintContainer, String beanFactory) {
        DozerPropertyDescriptor desc;
        boolean isMapProperty = MappingUtils.isSupportedMap(clazz);
        if (name.equals("this") && (mapSetMethod != null || mapGetMethod != null || isMapProperty)) {
            String setMethod = isMapProperty ? "put" : mapSetMethod;
            String getMethod = isMapProperty ? "get" : mapGetMethod;
            desc = new MapPropertyDescriptor(clazz, name, isIndexed, index, setMethod, getMethod, key != null ? key : oppositeFieldName, deepIndexHintContainer);
        } else {
            desc = isSelfReferencing ? new SelfPropertyDescriptor(clazz) : (isAccessible ? new FieldPropertyDescriptor(clazz, name, isIndexed, index, deepIndexHintContainer) : (theSetMethod != null || theGetMethod != null ? new CustomGetSetPropertyDescriptor(clazz, name, isIndexed, index, theSetMethod, theGetMethod, deepIndexHintContainer) : (beanFactory != null && beanFactory.equals(DozerConstants.XML_BEAN_FACTORY) ? new XmlBeanPropertyDescriptor(clazz, name, isIndexed, index, deepIndexHintContainer) : new JavaBeanPropertyDescriptor(clazz, name, isIndexed, index, deepIndexHintContainer))));
        }
        return desc;
    }
}

