/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.util;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.StringUtils;
import org.dozer.CustomConverter;
import org.dozer.MappingException;
import org.dozer.cache.Cache;
import org.dozer.cache.CacheKeyFactory;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.CopyByReferenceContainer;
import org.dozer.classmap.DozerClass;
import org.dozer.config.BeanContainer;
import org.dozer.converters.CustomConverterContainer;
import org.dozer.converters.CustomConverterDescription;
import org.dozer.converters.InstanceCustomConverterDescription;
import org.dozer.converters.JavaClassCustomConverterDescription;
import org.dozer.fieldmap.DozerField;
import org.dozer.fieldmap.FieldMap;
import org.dozer.fieldmap.FieldMapUtils;
import org.dozer.fieldmap.MultiFieldsExcludeFieldMap;
import org.dozer.fieldmap.MultiSourceFieldMap;
import org.dozer.propertydescriptor.DozerPropertyDescriptor;
import org.dozer.util.CollectionUtils;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.DozerConstants;
import org.dozer.util.DozerProxyResolver;
import org.dozer.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MappingUtils {
    private MappingUtils() {
    }

    public static String getClassNameWithoutPackage(Class<?> clazz) {
        Package pckage = clazz.getPackage();
        int pckageIndex = 0;
        if (pckage != null) {
            pckageIndex = pckage.getName().length() + 1;
        }
        return clazz.getName().substring(pckageIndex);
    }

    public static boolean isSupportedCollection(Class<?> aClass) {
        return CollectionUtils.isCollection(aClass) || CollectionUtils.isArray(aClass);
    }

    public static Class<?> getSupportedCollectionEntryType(Class<?> collectionClass) {
        Class<?> genericType;
        Class<?> entryType = null;
        if (collectionClass.isArray()) {
            entryType = collectionClass.getComponentType();
        } else if (Collection.class.isAssignableFrom(collectionClass) && (genericType = ReflectionUtils.determineGenericsType(collectionClass)) != null) {
            entryType = genericType;
        }
        return entryType;
    }

    public static Class<?> getSupportedCollectionEntryType(DozerPropertyDescriptor pd) {
        Class<?> entryType = pd.genericType();
        if (entryType == null) {
            entryType = MappingUtils.getSupportedCollectionEntryType(pd.getPropertyType());
        }
        return entryType;
    }

    public static boolean isSupportedMap(Class<?> aClass) {
        return Map.class.isAssignableFrom(aClass);
    }

    public static void throwMappingException(Throwable e) throws MappingException {
        if (e instanceof MappingException) {
            throw (MappingException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new MappingException(e);
    }

    public static void throwMappingException(String msg) throws MappingException {
        throw new MappingException(msg);
    }

    public static void throwMappingException(String msg, Throwable cause) throws MappingException {
        throw new MappingException(msg, cause);
    }

    public static boolean isBlankOrNull(String value) {
        return value == null || value.trim().length() < 1;
    }

    public static Throwable getRootCause(Throwable ex) {
        Throwable rootCause = ex;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        return rootCause;
    }

    public static String getMappedParentFieldKey(Object destObj, FieldMap destFieldMap) {
        StringBuilder buf = new StringBuilder(100);
        buf.append(System.identityHashCode(destObj));
        buf.append(destFieldMap.getDestFieldName());
        if (destFieldMap.getDestFieldKey() != null) {
            buf.append("[").append(destFieldMap.getDestFieldKey()).append("]");
        }
        return buf.toString();
    }

    public static CustomConverter findCustomConverterByClass(Class<?> customConverterClass, List<CustomConverter> externalConverters) {
        CustomConverter converterInstance = null;
        if (externalConverters != null) {
            for (CustomConverter customConverterObject : externalConverters) {
                if (!customConverterObject.getClass().isAssignableFrom(customConverterClass)) continue;
                converterInstance = customConverterObject;
            }
        }
        if (converterInstance == null) {
            converterInstance = (CustomConverter)ReflectionUtils.newInstance(customConverterClass);
        }
        return converterInstance;
    }

    public static CustomConverter findCustomConverter(Cache cache, List<CustomConverter> externalConverters, CustomConverterContainer customConverterContainer, Class<?> srcClass, Class<?> destClass) {
        if (customConverterContainer == null) {
            return null;
        }
        Object cacheKey = CacheKeyFactory.createKey(destClass, srcClass);
        if (cache.containsKey(cacheKey)) {
            return (CustomConverter)cache.get(cacheKey);
        }
        CustomConverter converterInstance = null;
        CustomConverterDescription description = customConverterContainer.getCustomConverter(srcClass, destClass);
        if (description != null) {
            if (description instanceof InstanceCustomConverterDescription) {
                converterInstance = ((InstanceCustomConverterDescription)description).getInstance();
            } else {
                Class<?> customConverterClass = ((JavaClassCustomConverterDescription)description).getType();
                converterInstance = MappingUtils.findCustomConverterByClass(customConverterClass, externalConverters);
            }
        }
        cache.put(cacheKey, converterInstance);
        return converterInstance;
    }

    public static CustomConverter determineCustomConverter(FieldMap fieldMap, Cache converterByDestTypeCache, List<CustomConverter> customConverterObjects, CustomConverterContainer customConverterContainer, Class<?> srcClass, Class<?> destClass) {
        if (customConverterContainer == null) {
            return null;
        }
        Class<Collection> destType = destClass;
        if (fieldMap != null && fieldMap.isDestFieldIndexed()) {
            if (destClass.isArray()) {
                destType = destClass.getComponentType();
            } else if (destClass.isAssignableFrom(Collection.class) && fieldMap.getDestHintContainer() != null && !fieldMap.getDestHintContainer().hasMoreThanOneHint()) {
                destType = fieldMap.getDestHintContainer().getHint();
            }
        }
        return MappingUtils.findCustomConverter(converterByDestTypeCache, customConverterObjects, customConverterContainer, srcClass, destType);
    }

    public static void reverseFields(FieldMap source, FieldMap reversed) {
        if (source instanceof MultiSourceFieldMap) {
            ((MultiFieldsExcludeFieldMap)reversed).setDest(FieldMapUtils.getCopy(((MultiSourceFieldMap)source).getSrc()));
            ((MultiFieldsExcludeFieldMap)reversed).setSrc(Arrays.asList(source.getDestFieldCopy()));
        } else {
            DozerField destField = source.getSrcFieldCopy();
            DozerField sourceField = source.getDestFieldCopy();
            reversed.setDestField(destField);
            reversed.setSrcField(sourceField);
            reversed.setSrcHintContainer(source.getDestHintContainer());
            reversed.setDestHintContainer(source.getSrcHintContainer());
            reversed.setSrcDeepIndexHintContainer(source.getDestDeepIndexHintContainer());
            reversed.setDestDeepIndexHintContainer(source.getSrcDeepIndexHintContainer());
        }
        reversed.setCustomConverter(source.getCustomConverter());
        reversed.setCustomConverterId(source.getCustomConverterId());
        reversed.setMapId(source.getMapId());
        reversed.setRelationshipType(source.getRelationshipType());
        reversed.setRemoveOrphans(source.isRemoveOrphans());
    }

    public static void reverseFields(ClassMap source, ClassMap destination) {
        destination.setSrcClass(new DozerClass(source.getDestClassName(), source.getDestClassToMap(), source.getDestClassBeanFactory(), source.getDestClassBeanFactoryId(), source.getDestClassMapGetMethod(), source.getDestClassMapSetMethod(), source.getDestClass().getCreateMethod(), source.isDestMapNull(), source.isDestMapEmptyString(), source.getDestClass().isAccesible()));
        destination.setDestClass(new DozerClass(source.getSrcClassName(), source.getSrcClassToMap(), source.getSrcClassBeanFactory(), source.getSrcClassBeanFactoryId(), source.getSrcClassMapGetMethod(), source.getSrcClassMapSetMethod(), source.getSrcClass().getCreateMethod(), source.isSrcMapNull(), source.isSrcMapEmptyString(), source.getSrcClass().isAccesible()));
        destination.setType(source.getType());
        destination.setWildcard(source.isWildcard());
        destination.setTrimStrings(source.isTrimStrings());
        destination.setDateFormat(source.getDateFormat());
        destination.setRelationshipType(source.getRelationshipType());
        destination.setStopOnErrors(source.isStopOnErrors());
        destination.setAllowedExceptions(source.getAllowedExceptions());
        destination.setSrcClassCreateMethod(source.getDestClassCreateMethod());
        destination.setDestClassCreateMethod(source.getSrcClassCreateMethod());
        if (StringUtils.isNotEmpty((String)source.getMapId())) {
            destination.setMapId(source.getMapId());
        }
    }

    public static void applyGlobalCopyByReference(Configuration globalConfig, FieldMap fieldMap, ClassMap classMap) {
        CopyByReferenceContainer copyByReferenceContainer = globalConfig.getCopyByReferences();
        String destFieldTypeName = null;
        Class<?> clazz = fieldMap.getDestFieldType(classMap.getDestClassToMap());
        if (clazz != null) {
            destFieldTypeName = clazz.getName();
        }
        if (copyByReferenceContainer.contains(destFieldTypeName) && !fieldMap.isCopyByReferenceOveridden()) {
            fieldMap.setCopyByReference(true);
        }
    }

    public static Class<?> loadClass(String name) {
        BeanContainer container = BeanContainer.getInstance();
        DozerClassLoader loader = container.getClassLoader();
        return loader.loadClass(name);
    }

    public static Class<?> getRealClass(Class<?> clazz) {
        BeanContainer container = BeanContainer.getInstance();
        DozerProxyResolver proxyResolver = container.getProxyResolver();
        return proxyResolver.getRealClass(clazz);
    }

    public static <T> T deProxy(T object) {
        BeanContainer container = BeanContainer.getInstance();
        DozerProxyResolver proxyResolver = container.getProxyResolver();
        return proxyResolver.unenhanceObject(object);
    }

    public static boolean isProxy(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        String className = clazz.getName();
        return className.contains("$$EnhancerByCGLIB$$") || className.startsWith("org.javassist.tmp.") || className.contains("_$$_javassist_");
    }

    public static Object getXPathIndexedValue(Object object, String index) {
        JXPathContext context = JXPathContext.newContext((Object)object);
        context.setLenient(true);
        return context.getValue(index);
    }

    public static Object getCollectionIndexedValue(Object collection, int index) {
        Collection x;
        if (collection == null) {
            return null;
        }
        Object result = null;
        int collectionIndex = index;
        if (collectionIndex == -1) {
            collectionIndex = CollectionUtils.getLengthOfCollection(collection);
        }
        if (collection instanceof Object[]) {
            Object[] x2 = (Object[])collection;
            if (collectionIndex < x2.length) {
                return x2[collectionIndex];
            }
        } else if (collection instanceof Collection && collectionIndex < (x = (Collection)collection).size()) {
            Iterator iter = x.iterator();
            for (int i = 0; i < collectionIndex; ++i) {
                iter.next();
            }
            result = iter.next();
        }
        return result;
    }

    public static boolean isSimpleCollectionIndex(String index) {
        try {
            Integer.parseInt(index);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static int getCollectionIndex(String index) {
        int intValue = Integer.parseInt(index);
        if (intValue < 1) {
            return -1;
        }
        return intValue - 1;
    }

    public static Object prepareIndexedCollection(Class<?> collectionType, Object existingCollection, Object collectionEntry, int index) {
        Object result = null;
        if (collectionType.isArray()) {
            result = MappingUtils.prepareIndexedArray(collectionType, existingCollection, collectionEntry, index);
        } else if (Collection.class.isAssignableFrom(collectionType)) {
            result = MappingUtils.prepareIndexedCollectionType(collectionType, existingCollection, collectionEntry, index);
        } else {
            MappingUtils.throwMappingException("Only types java.lang.Object[] and java.util.Collection are supported for indexed properties.");
        }
        return result;
    }

    public static boolean isDeepMapping(String mapping) {
        return mapping != null && mapping.contains(".");
    }

    private static <T> T[] prepareIndexedArray(Class<T> collectionType, Object existingCollection, Object collectionEntry, int index) {
        Object[] result;
        if (existingCollection == null) {
            result = (Object[])Array.newInstance(collectionType.getComponentType(), index + 1);
        } else {
            int originalLenth = ((Object[])existingCollection).length;
            result = (Object[])Array.newInstance(collectionType.getComponentType(), Math.max(index + 1, originalLenth));
            System.arraycopy(existingCollection, 0, result, 0, originalLenth);
        }
        result[index] = collectionEntry;
        return result;
    }

    private static Collection<?> prepareIndexedCollectionType(Class<?> collectionType, Object existingCollection, Object collectionEntry, int index) {
        AbstractCollection result = null;
        if (collectionType.isInterface()) {
            if (collectionType.equals(Set.class)) {
                result = new HashSet();
            } else if (collectionType.equals(List.class)) {
                result = new ArrayList();
            } else {
                MappingUtils.throwMappingException("Only interface types java.util.Set and java.util.List are supported for java.util.Collection type indexed properties.");
            }
        } else {
            try {
                result = (HashSet)collectionType.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (existingCollection != null) {
            result.addAll((Collection)existingCollection);
        }
        if (result instanceof List) {
            while (result.size() < index + 1) {
                result.add(null);
            }
            ((List)((Object)result)).set(index, collectionEntry);
        } else {
            result.add(collectionEntry);
        }
        return result;
    }

    public static boolean isEnumType(Class<?> srcFieldClass, Class<?> destFieldType) {
        if (srcFieldClass.isAnonymousClass()) {
            srcFieldClass = srcFieldClass.getEnclosingClass();
        }
        if (destFieldType.isAnonymousClass()) {
            destFieldType = destFieldType.getEnclosingClass();
        }
        return srcFieldClass.isEnum() && destFieldType.isEnum();
    }

    public static List<Class<?>> getSuperClassesAndInterfaces(Class<?> srcClass) {
        ArrayList superClasses = new ArrayList();
        Class<?> realClass = MappingUtils.getRealClass(srcClass);
        Class<?> superClass = MappingUtils.getRealClass(realClass).getSuperclass();
        while (!MappingUtils.isBaseClass(superClass)) {
            superClasses.add(superClass);
            superClass = superClass.getSuperclass();
        }
        LinkedHashSet interfaces = new LinkedHashSet();
        interfaces.addAll(MappingUtils.getInterfaceHierarchy(realClass));
        for (Class clazz : superClasses) {
            interfaces.addAll(MappingUtils.getInterfaceHierarchy(clazz));
        }
        superClasses.addAll(interfaces);
        return superClasses;
    }

    public static List<Class<?>> getInterfaceHierarchy(Class<?> srcClass) {
        LinkedList result = new LinkedList();
        Class<?> realClass = MappingUtils.getRealClass(srcClass);
        LinkedList interfacesToProcess = new LinkedList();
        Class<?>[] interfaces = realClass.getInterfaces();
        interfacesToProcess.addAll(Arrays.asList(interfaces));
        while (!interfacesToProcess.isEmpty()) {
            Class iface = (Class)interfacesToProcess.remove();
            if (result.contains(iface)) continue;
            result.add(iface);
            for (Class<?> subiface : iface.getInterfaces()) {
                if (result.contains(subiface)) continue;
                interfacesToProcess.add(subiface);
            }
        }
        return result;
    }

    public static String fieldMapKey(FieldMap fieldMap) {
        String mappingCondition;
        String mappingConditionId;
        StringBuilder builder = new StringBuilder();
        if (MappingUtils.isBlankOrNull(fieldMap.getSrcFieldName())) {
            builder.append("<noname>");
        } else {
            builder.append(fieldMap.getSrcFieldName());
        }
        if (!(fieldMap instanceof MultiSourceFieldMap || fieldMap instanceof MultiFieldsExcludeFieldMap || MappingUtils.isBlankOrNull(fieldMap.getSrcFieldIndex()))) {
            builder.append("[" + fieldMap.getSrcFieldIndex() + "]");
        }
        if (!(fieldMap instanceof MultiSourceFieldMap || fieldMap instanceof MultiFieldsExcludeFieldMap || MappingUtils.isBlankOrNull(fieldMap.getSrcFieldKey()))) {
            builder.append("{" + fieldMap.getSrcFieldKey() + "}");
        }
        builder.append("-->");
        builder.append(fieldMap.getDestFieldName());
        if (!(fieldMap instanceof MultiFieldsExcludeFieldMap) && !MappingUtils.isBlankOrNull(fieldMap.getDestFieldIndex())) {
            builder.append("[" + fieldMap.getDestFieldIndex() + "]");
        }
        if (!(fieldMap instanceof MultiFieldsExcludeFieldMap) && !MappingUtils.isBlankOrNull(fieldMap.getDestFieldKey())) {
            builder.append("{" + fieldMap.getDestFieldKey() + "}");
        }
        if (!MappingUtils.isBlankOrNull(mappingConditionId = fieldMap.getMappingConditionId())) {
            builder.append(" (conditionId: " + mappingConditionId + ")");
        }
        if (!MappingUtils.isBlankOrNull(mappingCondition = fieldMap.getMappingCondition())) {
            builder.append(" (condition: " + mappingCondition + ")");
        }
        return builder.toString();
    }

    private static boolean isBaseClass(Class<?> clazz) {
        return clazz == null || DozerConstants.BASE_CLASS.equals(clazz.getName());
    }
}

