/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openl.binding.IBoundNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.ExecutableMethod;

public class BindingDependencies {
    private HashMap<IOpenClass, IBoundNode> types = new HashMap();
    private HashMap<IOpenMethod, IBoundNode> methods = new HashMap();
    private HashMap<ExecutableMethod, IBoundNode> rulesMethods = new HashMap();
    private HashMap<IBoundNode, IOpenField> fields = new HashMap();
    private HashMap<IOpenField, IBoundNode> assigned = new HashMap();

    public void addAssign(IBoundNode target, IBoundNode node) {
        target.updateAssignFieldDependency(this);
    }

    public void addAssignField(IOpenField field, IBoundNode node) {
        this.assigned.put(field, node);
    }

    public void addFieldDependency(IOpenField field, IBoundNode node) {
        this.fields.put(node, field);
    }

    public void addMethodDependency(IOpenMethod method, IBoundNode node) {
        this.methods.put(method, node);
        if (method instanceof ExecutableMethod) {
            this.rulesMethods.put((ExecutableMethod)method, node);
        }
    }

    public synchronized void addTypeDependency(IOpenClass type, IBoundNode node) {
        this.types.put(type, node);
    }

    public Set<IOpenField> getAssigned() {
        return this.assigned.keySet();
    }

    public Map<IOpenField, IBoundNode> getAssignedMap() {
        return this.assigned;
    }

    public Set<IBoundNode> getFieldNodes() {
        return this.fields.keySet();
    }

    public Map<IBoundNode, IOpenField> getFieldsMap() {
        return this.fields;
    }

    public Set<IOpenMethod> getMethods() {
        return this.methods.keySet();
    }

    public Set<ExecutableMethod> getRulesMethods() {
        return this.rulesMethods.keySet();
    }

    protected Map<ExecutableMethod, IBoundNode> getRulesMethodsMap() {
        return this.rulesMethods;
    }

    protected Map<IOpenMethod, IBoundNode> getMethodsMap() {
        return this.methods;
    }

    public Set<IOpenClass> getTypes() {
        return this.types.keySet();
    }

    public Map<IOpenClass, IBoundNode> getTypesMap() {
        return this.types;
    }

    String setToString(Set<?> set) {
        return set.toString();
    }

    public String toString() {
        return "Fields:\n" + this.setToString(this.fields.keySet()) + "\nMethods:\n" + this.setToString(this.methods.keySet()) + "\nTypes:\n" + this.setToString(this.types.keySet()) + "\nAssignes:\n" + this.setToString(this.assigned.keySet());
    }

    public void visit(IBoundNode node) {
        if (node == null) {
            return;
        }
        node.updateDependency(this);
        this.visit(node.getTargetNode());
        IBoundNode[] ch = node.getChildren();
        if (ch != null) {
            for (IBoundNode child : ch) {
                this.visit(child);
            }
        }
    }
}

