/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding;

import java.lang.reflect.Method;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.OpenClassDelegator;
import org.openl.util.IConvertor;
import org.openl.util.print.Formatter;

public class MethodUtil {
    private static final IConvertor<IOpenClass, String> DEFAULT_TYPE_CONVERTER = new IConvertor<IOpenClass, String>(){

        public String convert(IOpenClass type) {
            return MethodUtil.printType(type);
        }
    };

    public static String printType(IOpenClass type) {
        return type instanceof OpenClassDelegator ? type.getName() : type.getDisplayName(0);
    }

    public static StringBuilder printMethod(IOpenMethodHeader method, StringBuilder buf) {
        buf.append((String)DEFAULT_TYPE_CONVERTER.convert((Object)method.getType())).append(' ');
        MethodUtil.printMethod(method, buf, DEFAULT_TYPE_CONVERTER);
        return buf;
    }

    public static String printSignature(IOpenMethodHeader methodHeader, final int mode) {
        StringBuilder buf = new StringBuilder(100);
        IConvertor<IOpenClass, String> typeConverter = new IConvertor<IOpenClass, String>(){

            public String convert(IOpenClass type) {
                return type.getDisplayName(mode);
            }
        };
        MethodUtil.printMethod(methodHeader, buf, typeConverter);
        return buf.toString();
    }

    private static void printMethod(IOpenMethodHeader methodHeader, StringBuilder buf, IConvertor<IOpenClass, String> typeConverter) {
        MethodUtil.startPrintingMethodName(methodHeader.getName(), buf);
        IMethodSignature signature = methodHeader.getSignature();
        for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
            MethodUtil.printParameterInfo((String)typeConverter.convert((Object)signature.getParameterType(i)), signature.getParameterName(i), i == 0, buf);
        }
        MethodUtil.endPrintingMethodName(buf);
    }

    public static String printMethod(String name, Class<?>[] params) {
        return MethodUtil.printMethod(name, params, new StringBuilder()).toString();
    }

    public static StringBuilder printMethod(String name, Class<?>[] params, StringBuilder buf) {
        MethodUtil.startPrintingMethodName(name, buf);
        for (int i = 0; i < params.length; ++i) {
            MethodUtil.printParameterInfo(params[i].getName(), null, i == 0, buf);
        }
        MethodUtil.endPrintingMethodName(buf);
        return buf;
    }

    public static String printMethod(String name, IOpenClass[] params) {
        return MethodUtil.printMethod(name, params, new StringBuilder()).toString();
    }

    public static StringBuilder printMethod(String name, IOpenClass[] params, StringBuilder buf) {
        MethodUtil.startPrintingMethodName(name, buf);
        for (int i = 0; i < params.length; ++i) {
            MethodUtil.printParameterInfo(params[i].getName(), null, i == 0, buf);
        }
        MethodUtil.endPrintingMethodName(buf);
        return buf;
    }

    public static StringBuilder printMethodWithParameterValues(IOpenMethodHeader method, Object[] params, int mode, StringBuilder buf) {
        MethodUtil.startPrintingMethodName(method.getName(), buf);
        IMethodSignature signature = method.getSignature();
        for (int i = 0; i < params.length; ++i) {
            MethodUtil.printParameterInfo(null, signature.getParameterName(i), params[i], i == 0, mode, buf);
        }
        MethodUtil.endPrintingMethodName(buf);
        return buf;
    }

    public static String printMethodWithParameterValues(IOpenMethodHeader method, Object[] params, int mode) {
        return MethodUtil.printMethodWithParameterValues(method, params, mode, new StringBuilder()).toString();
    }

    private static void startPrintingMethodName(String name, StringBuilder buf) {
        buf.append(name).append('(');
    }

    private static void endPrintingMethodName(StringBuilder buf) {
        buf.append(')');
    }

    private static void printParameterInfo(String type, String name, boolean isFirst, StringBuilder buf) {
        MethodUtil.printParameterInfo(type, name, null, isFirst, 0, buf);
    }

    private static void printParameterInfo(String type, String name, Object value, boolean isFirst, int displayMode, StringBuilder buf) {
        if (!isFirst) {
            buf.append(", ");
        }
        if (type != null) {
            buf.append(type);
        }
        if (type != null && name != null) {
            buf.append(' ');
        }
        if (name != null) {
            buf.append(name);
        }
        if (value != null) {
            buf.append(" = ");
            Formatter.format((Object)value, (int)displayMode, (StringBuilder)buf);
        }
    }

    public static Method getMatchingAccessibleMethod(Class<?> methodOwner, String methodName, Class<?>[] argTypes, boolean autoboxing) {
        Method[] methods;
        Method resultMethod = null;
        for (Method method : methods = methodOwner.getMethods()) {
            Class[] signatureParams = method.getParameterTypes();
            if (!methodName.equals(method.getName()) || signatureParams.length != argTypes.length || !ClassUtils.isAssignable((Class[])argTypes, (Class[])signatureParams, (boolean)autoboxing) || (method = MethodUtils.getAccessibleMethod((Method)method)) == null) continue;
            resultMethod = resultMethod != null ? MethodUtil.getCloserMethod(resultMethod, method, argTypes, autoboxing) : method;
        }
        return resultMethod;
    }

    private static Method getCloserMethod(Method firstMethod, Method secondMethod, Class<?>[] argTypes, boolean autoboxing) {
        int firstTransfCount = MethodUtil.getTransformationsCount(firstMethod.getParameterTypes(), argTypes, autoboxing);
        if (firstTransfCount < 0) {
            return secondMethod;
        }
        int secondTransfCount = MethodUtil.getTransformationsCount(secondMethod.getParameterTypes(), argTypes, autoboxing);
        if (secondTransfCount < 0 || secondTransfCount >= firstTransfCount) {
            return firstMethod;
        }
        return secondMethod;
    }

    private static int getTransformationsCount(Class<?>[] signatureToCheck, Class<?>[] argTypes, boolean autoboxing) {
        int transformationsCount = 0;
        for (int i = 0; i < argTypes.length; ++i) {
            if (signatureToCheck[i].equals(argTypes[i])) continue;
            if (!ClassUtils.isAssignable(argTypes[i], signatureToCheck[i], (boolean)autoboxing)) {
                return -1;
            }
            ++transformationsCount;
        }
        return transformationsCount;
    }
}

