/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.BindingDependencies;
import org.openl.binding.IBoundNode;
import org.openl.binding.IBoundNodeVisitor;
import org.openl.binding.impl.ControlSignal;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.vm.IRuntimeEnv;

public abstract class ABoundNode
implements IBoundNode {
    private static final IBoundNode[] EMPTY = new IBoundNode[0];
    protected ISyntaxNode syntaxNode;
    protected IBoundNode[] children;

    protected ABoundNode(ISyntaxNode syntaxNode, IBoundNode[] children) {
        this.syntaxNode = syntaxNode;
        this.children = children != null && children.length == 0 ? EMPTY : children;
    }

    @Override
    public void assign(Object value, IRuntimeEnv env) throws OpenLRuntimeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object evaluate(IRuntimeEnv env) throws OpenLRuntimeException {
        try {
            return this.evaluateRuntime(env);
        }
        catch (OpenLRuntimeException ore) {
            throw ore;
        }
        catch (ControlSignal controlSignal) {
            throw controlSignal;
        }
        catch (Throwable t) {
            throw new OpenLRuntimeException(t, (IBoundNode)this);
        }
    }

    public Object[] evaluateChildren(IRuntimeEnv env) throws OpenLRuntimeException {
        if (this.children == null) {
            return null;
        }
        Object[] ch = new Object[this.children.length];
        for (int i = 0; i < ch.length; ++i) {
            ch[i] = this.children[i].evaluate(env);
        }
        return ch;
    }

    @Override
    public IBoundNode[] getChildren() {
        return this.children;
    }

    @Override
    public ISyntaxNode getSyntaxNode() {
        return this.syntaxNode;
    }

    public void setSyntaxNode(ISyntaxNode syntaxNode) {
        this.syntaxNode = syntaxNode;
    }

    @Override
    public IBoundNode getTargetNode() {
        return null;
    }

    @Override
    public boolean isLvalue() {
        return false;
    }

    @Override
    public void updateAssignFieldDependency(BindingDependencies dependencies) {
    }

    @Override
    public boolean isLiteralExpression() {
        return this.isLiteralExpressionParent() && this.hasAllLiteralExpressionChildren(this);
    }

    private boolean hasAllLiteralExpressionChildren(IBoundNode boundNode) {
        IBoundNodeVisitor checkLiteral = new IBoundNodeVisitor(){

            @Override
            public boolean visit(IBoundNode node) {
                return node == ABoundNode.this || node.isLiteralExpression();
            }
        };
        return boundNode.visit(checkLiteral);
    }

    public boolean isLiteralExpressionParent() {
        return false;
    }

    @Override
    public void updateDependency(BindingDependencies dependencies) {
    }

    @Override
    public boolean visit(IBoundNodeVisitor visitor) {
        if (!visitor.visit(this)) {
            return false;
        }
        if (this.children == null) {
            return true;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].visit(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStaticTarget() {
        return false;
    }
}

