/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.HashMap;
import java.util.Map;
import org.openl.IOpenBinder;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IBoundCode;
import org.openl.binding.IBoundNode;
import org.openl.binding.ICastFactory;
import org.openl.binding.INameSpacedMethodFactory;
import org.openl.binding.INameSpacedTypeFactory;
import org.openl.binding.INameSpacedVarFactory;
import org.openl.binding.INodeBinder;
import org.openl.binding.INodeBinderFactory;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.BindingContext;
import org.openl.binding.impl.BoundCode;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.code.IParsedCode;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaOpenClass;

public class Binder
implements IOpenBinder {
    private OpenL openl;
    private INodeBinderFactory nodeBinderFactory;
    private ICastFactory castFactory;
    private INameSpacedVarFactory varFactory;
    private INameSpacedTypeFactory typeFactory;
    private INameSpacedMethodFactory methodFactory;
    Map<MethodKey, Object> methodCache = new HashMap<MethodKey, Object>();

    public Binder(INodeBinderFactory nodeBinderFactory, INameSpacedMethodFactory methodFactory, ICastFactory castFactory, INameSpacedVarFactory varFactory, INameSpacedTypeFactory typeFactory, OpenL openl) {
        this.nodeBinderFactory = nodeBinderFactory;
        this.methodFactory = methodFactory;
        this.castFactory = castFactory;
        this.varFactory = varFactory;
        this.typeFactory = typeFactory;
        this.openl = openl;
    }

    @Override
    public ICastFactory getCastFactory() {
        return this.castFactory;
    }

    @Override
    public INameSpacedMethodFactory getMethodFactory() {
        return this.methodFactory;
    }

    @Override
    public INodeBinderFactory getNodeBinderFactory() {
        return this.nodeBinderFactory;
    }

    @Override
    public INameSpacedTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public INameSpacedVarFactory getVarFactory() {
        return this.varFactory;
    }

    @Override
    public IBindingContext makeBindingContext() {
        return new BindingContext(this, JavaOpenClass.VOID, this.openl);
    }

    @Override
    public IBoundCode bind(IParsedCode parsedCode) {
        return this.bind(parsedCode, null);
    }

    @Override
    public IBoundCode bind(IParsedCode parsedCode, IBindingContextDelegator delegator) {
        IBindingContext bindingContext = this.makeBindingContext();
        bindingContext = BindHelper.delegateContext(bindingContext, delegator);
        ISyntaxNode syntaxNode = parsedCode.getTopNode();
        try {
            bindingContext.pushLocalVarContext();
            IBoundNode topNode = this.bindNode(syntaxNode, parsedCode, bindingContext);
            bindingContext.popLocalVarContext();
            return new BoundCode(parsedCode, topNode, bindingContext.getErrors(), bindingContext.getLocalVarFrameSize());
        }
        catch (Throwable cause) {
            BindHelper.processError(syntaxNode, cause, bindingContext);
            return BindHelper.makeInvalidCode(parsedCode, syntaxNode, bindingContext);
        }
    }

    private IBoundNode bindNode(ISyntaxNode syntaxNode, IParsedCode parsedCode, IBindingContext bindingContext) throws Exception {
        INodeBinder nodeBinder = bindingContext.findBinder(syntaxNode);
        if (nodeBinder == null) {
            throw new OpenlNotCheckedException(String.format("Binder not found for node '%s'", syntaxNode.getType()));
        }
        return nodeBinder.bind(syntaxNode, bindingContext);
    }
}

