/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.BindingDependencies;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ATargetBoundNode;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.vm.IRuntimeEnv;

public class FieldBoundNode
extends ATargetBoundNode {
    private IOpenField boundField;

    public FieldBoundNode(ISyntaxNode syntaxNode, IOpenField field) {
        this(syntaxNode, field, null);
    }

    public FieldBoundNode(ISyntaxNode syntaxNode, IOpenField field, IBoundNode target) {
        super(syntaxNode, new IBoundNode[0], target);
        this.boundField = field;
    }

    @Override
    public void assign(Object value, IRuntimeEnv env) throws OpenLRuntimeException {
        Object target = this.getTargetNode() == null ? env.getThis() : this.getTargetNode().evaluate(env);
        this.boundField.set(target, value, env);
    }

    public String getFieldName() {
        return this.boundField.getName();
    }

    public IOpenField getBoundField() {
        return this.boundField;
    }

    @Override
    public Object evaluateRuntime(IRuntimeEnv env) throws OpenLRuntimeException {
        Object target = this.getTargetNode() == null ? env.getThis() : this.getTargetNode().evaluate(env);
        return this.boundField.get(target, env);
    }

    @Override
    public IOpenClass getType() {
        return this.boundField.getType();
    }

    @Override
    public boolean isLvalue() {
        return this.boundField.isWritable();
    }

    @Override
    public void updateAssignFieldDependency(BindingDependencies dependencies) {
        dependencies.addAssignField(this.boundField, this);
    }

    @Override
    public void updateDependency(BindingDependencies dependencies) {
        dependencies.addFieldDependency(this.boundField, this);
    }

    @Override
    public boolean isLiteralExpressionParent() {
        return this.boundField.isConst();
    }
}

