/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.FieldBoundNode;
import org.openl.binding.impl.TypeBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;

public class IdentifierBinder
extends ANodeBinder {
    @Override
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        boolean strictMatch = this.isStrictMatch(node);
        String fieldName = ((IdentifierNode)node).getIdentifier();
        IOpenField field = bindingContext.findVar("org.openl.this", fieldName, strictMatch);
        if (field != null) {
            return new FieldBoundNode(node, field);
        }
        IOpenClass type = bindingContext.findType("org.openl.this", fieldName);
        if (type != null) {
            return new TypeBoundNode(node, type);
        }
        String message = String.format("Field not found: '%s'", fieldName);
        BindHelper.processError(message, node, bindingContext, false);
        return new ErrorBoundNode(node);
    }

    @Override
    public IBoundNode bindTarget(ISyntaxNode node, IBindingContext bindingContext, IBoundNode target) {
        try {
            String fieldName = ((IdentifierNode)node).getIdentifier();
            return BindHelper.bindAsField(fieldName, node, bindingContext, target);
        }
        catch (Throwable t) {
            BindHelper.processError(node, t, bindingContext);
            return new ErrorBoundNode(node);
        }
    }

    private boolean isStrictMatch(ISyntaxNode node) {
        return !node.getType().contains(".nostrict");
    }
}

