/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMethodFactory;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.CastingMethodCaller;
import org.openl.util.AOpenIterator;
import org.openl.util.ASelector;
import org.openl.util.ISelector;

public class MethodSearch {
    static final int NO_MATCH = Integer.MAX_VALUE;

    protected static int calcMatch(IOpenClass[] methodParam, IOpenClass[] callParam, ICastFactory casts, IOpenCast[] castHolder) {
        int maxdiff = 0;
        int ndiff = 0;
        for (int i = 0; i < callParam.length; ++i) {
            if (callParam[i] == methodParam[i]) continue;
            IOpenCast cast = casts.getCast(callParam[i], methodParam[i]);
            if (cast == null || !cast.isImplicit()) {
                return Integer.MAX_VALUE;
            }
            castHolder[i] = cast;
            maxdiff = Math.max(maxdiff, cast.getDistance(callParam[i], methodParam[i]));
            ++ndiff;
        }
        return maxdiff * 100 + ndiff;
    }

    public static IMethodCaller getCastingMethodCaller(String name, IOpenClass[] params, ICastFactory casts, Iterator<IOpenMethod> methods) throws AmbiguousMethodException {
        ArrayList<IOpenMethod> matchingMethods = new ArrayList<IOpenMethod>();
        int bestMatch = Integer.MAX_VALUE;
        IOpenCast[] bestCastHolder = null;
        Iterator<IOpenMethod> iter = MethodSearch.methods(name, params.length, methods);
        while (iter.hasNext()) {
            IOpenMethod method = iter.next();
            IOpenCast[] castHolder = new IOpenCast[params.length];
            int match = MethodSearch.calcMatch(method.getSignature().getParameterTypes(), params, casts, castHolder);
            if (match == Integer.MAX_VALUE) continue;
            if (match < bestMatch) {
                bestMatch = match;
                matchingMethods.clear();
                matchingMethods.add(method);
                bestCastHolder = castHolder;
                continue;
            }
            if (match != bestMatch) continue;
            matchingMethods.add(method);
        }
        switch (matchingMethods.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return new CastingMethodCaller((IOpenMethod)matchingMethods.get(0), bestCastHolder);
            }
        }
        IOpenMethod mostSecificMethod = MethodSearch.findMostSpecificMethod(name, params, matchingMethods, casts);
        boolean f = true;
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].equals(mostSecificMethod.getSignature().getParameterType(i))) {
                f = false;
            }
            bestCastHolder[i] = casts.getCast(params[i], mostSecificMethod.getSignature().getParameterType(i));
        }
        if (f) {
            return mostSecificMethod;
        }
        return new CastingMethodCaller(mostSecificMethod, bestCastHolder);
    }

    public static IMethodCaller getCastingMethodCaller(String name, IOpenClass[] params, ICastFactory casts, IMethodFactory factory) throws AmbiguousMethodException {
        return MethodSearch.getCastingMethodCaller(name, params, casts, factory.methods(name));
    }

    public static IOpenMethod findMostSpecificMethod(String name, IOpenClass[] params, List<IOpenMethod> matchingMethods, ICastFactory casts) throws AmbiguousMethodException {
        for (IOpenMethod res : matchingMethods) {
            Iterator<IOpenMethod> itr = matchingMethods.iterator();
            boolean f = true;
            while (itr.hasNext()) {
                IOpenMethod next = itr.next();
                if (res == next || MethodSearch.isMoreSpecificMethod(res, next, casts)) continue;
                f = false;
                break;
            }
            if (!f) continue;
            return res;
        }
        throw new AmbiguousMethodException(name, params, matchingMethods);
    }

    private static boolean isMoreSpecificMethod(IOpenMethod first, IOpenMethod second, ICastFactory casts) {
        if (first.getSignature().getNumberOfParameters() != second.getSignature().getNumberOfParameters()) {
            return false;
        }
        boolean differenceInArgTypes = false;
        for (int i = 0; i < first.getSignature().getNumberOfParameters(); ++i) {
            IOpenClass secondArgType;
            IOpenClass firstArgType = first.getSignature().getParameterType(i);
            if (firstArgType.equals(secondArgType = second.getSignature().getParameterType(i))) continue;
            differenceInArgTypes = true;
            IOpenCast cast = casts.getCast(firstArgType, secondArgType);
            if (cast != null && cast.isImplicit()) continue;
            return false;
        }
        if (!differenceInArgTypes) {
            IOpenClass secondDeclaringClass;
            IOpenClass firstDeclaringClass = first.getDeclaringClass();
            return !firstDeclaringClass.equals(secondDeclaringClass = second.getDeclaringClass()) && secondDeclaringClass.isAssignableFrom(firstDeclaringClass);
        }
        return true;
    }

    public static IMethodCaller getMethodCaller(String name, IOpenClass[] params, ICastFactory casts, IMethodFactory factory) throws AmbiguousMethodException {
        return MethodSearch.getMethodCaller(name, params, casts, factory, false);
    }

    public static IMethodCaller getMethodCaller(String name, IOpenClass[] params, ICastFactory casts, IMethodFactory factory, boolean strictMatch) throws AmbiguousMethodException {
        IOpenMethod caller = factory.getMatchingMethod(name, params);
        if (caller != null) {
            return caller;
        }
        if (params.length == 0 || casts == null) {
            return null;
        }
        if (!strictMatch) {
            return MethodSearch.getCastingMethodCaller(name, params, casts, factory);
        }
        return null;
    }

    protected static Iterator<IOpenMethod> methods(String name, int nParams, Iterator<IOpenMethod> it) {
        if (it == null) {
            return AOpenIterator.empty();
        }
        return AOpenIterator.select(it, (ISelector)new NameAndParSelector(name, nParams));
    }

    static class NameAndParSelector
    extends ASelector<IOpenMethod> {
        String name;
        int nParams;

        NameAndParSelector(String name, int nParams) {
            this.name = name;
            this.nParams = nParams;
        }

        public boolean select2(IOpenMethod method) {
            return method.getName().equals(this.name) && method.getSignature().getParameterTypes().length == this.nParams;
        }

        public boolean select(IOpenMethod method) {
            return method.getSignature().getParameterTypes().length == this.nParams;
        }
    }
}

