/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.lang.reflect.Array;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ATargetBoundNode;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.vm.IRuntimeEnv;

public class MultiCallFieldAccessMethodBoundNode
extends ATargetBoundNode {
    private IOpenField singleField;
    private IOpenClass returnType;

    public MultiCallFieldAccessMethodBoundNode(ISyntaxNode syntaxNode, IBoundNode containerField, IOpenField boundField) {
        super(syntaxNode, new IBoundNode[0], containerField);
        this.singleField = boundField;
    }

    @Override
    public Object evaluateRuntime(IRuntimeEnv env) throws OpenLRuntimeException {
        Object target = this.getTargetNode() == null ? env.getThis() : this.getTargetNode().evaluate(env);
        int paramsLenght = Array.getLength(target);
        Object results = Array.newInstance(this.singleField.getType().getInstanceClass(), paramsLenght);
        for (int i = 0; i < paramsLenght; ++i) {
            Array.set(results, i, this.singleField.get(Array.get(target, i), env));
        }
        return results;
    }

    @Override
    public IOpenClass getType() {
        if (this.returnType == null) {
            this.returnType = this.singleField.getType().getAggregateInfo().getIndexedAggregateType(this.singleField.getType(), 1);
        }
        return this.returnType;
    }

    @Override
    public void updateDependency(BindingDependencies dependencies) {
        dependencies.addFieldDependency(this.singleField, this);
    }

    public IOpenField getBoundField() {
        return this.singleField;
    }
}

