/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.lang.reflect.Array;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.MethodBoundNode;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

public class MultiCallMethodBoundNode
extends MethodBoundNode {
    private IOpenClass returnType;
    private int arrayArgumentIndex;

    public MultiCallMethodBoundNode(ISyntaxNode syntaxNode, IBoundNode[] children, IMethodCaller singleParameterMethod, int arrayArgumentIndex) {
        super(syntaxNode, children, singleParameterMethod);
        this.arrayArgumentIndex = arrayArgumentIndex;
    }

    @Override
    public Object evaluateRuntime(IRuntimeEnv env) throws OpenLRuntimeException {
        Object target = this.getTargetNode() == null ? env.getThis() : this.getTargetNode().evaluate(env);
        Object[] methodParameters = this.evaluateChildren(env);
        Object arrayParameters = methodParameters[this.arrayArgumentIndex];
        int paramsLenght = 0;
        if (arrayParameters != null) {
            paramsLenght = Array.getLength(arrayParameters);
        }
        Object results = null;
        if (JavaOpenClass.VOID.equals(super.getType())) {
            for (int callIndex = 0; callIndex < paramsLenght; ++callIndex) {
                results = this.getMethodCaller().invoke(target, this.initParametersForSingleCall(methodParameters, arrayParameters, callIndex), env);
            }
        } else {
            results = Array.newInstance(super.getType().getInstanceClass(), paramsLenght);
            for (int callIndex = 0; callIndex < paramsLenght; ++callIndex) {
                Array.set(results, callIndex, this.getMethodCaller().invoke(target, this.initParametersForSingleCall(methodParameters, arrayParameters, callIndex), env));
            }
        }
        return results;
    }

    private Object[] initParametersForSingleCall(Object[] allParameters, Object arrayParameters, int callIndex) {
        Object[] callParameters = (Object[])Array.newInstance(Object.class, allParameters.length);
        for (int i = 0; i < allParameters.length; ++i) {
            if (i == this.arrayArgumentIndex) {
                Array.set(callParameters, i, Array.get(arrayParameters, callIndex));
                continue;
            }
            Array.set(callParameters, i, allParameters[i]);
        }
        return callParameters;
    }

    @Override
    public IOpenClass getType() {
        if (this.returnType == null) {
            this.returnType = this.getReturnType();
        }
        return this.returnType;
    }

    private IOpenClass getReturnType() {
        IOpenClass result = null;
        if (JavaOpenClass.VOID.equals(super.getType())) {
            result = JavaOpenClass.VOID;
        } else {
            IOpenClass singleReturnType = super.getType();
            result = singleReturnType.getAggregateInfo().getIndexedAggregateType(singleReturnType, 1);
        }
        return result;
    }
}

