/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openl.binding.IOpenLibrary;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.AOpenClass;
import org.openl.util.AOpenIterator;
import org.openl.util.ASelector;
import org.openl.util.IOpenIterator;
import org.openl.util.ISelector;
import org.openl.util.OpenIterator;

public class StaticClassLibrary
implements IOpenLibrary {
    private IOpenClass openClass;
    IOpenMethod[] methods;
    Map<String, List<IOpenMethod>> methodNameMap = null;

    public StaticClassLibrary() {
    }

    public StaticClassLibrary(IOpenClass openClass) {
        this.openClass = openClass;
    }

    @Override
    public IOpenMethod getMatchingMethod(String name, IOpenClass[] params) {
        return this.openClass.getMethod(name, params);
    }

    @Override
    public IOpenField getVar(String name, boolean strictMatch) {
        return this.openClass.getField(name, strictMatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<IOpenMethod> methods() {
        if (this.methods == null) {
            StaticClassLibrary staticClassLibrary = this;
            synchronized (staticClassLibrary) {
                this.methods = this.selectMethods().asList().toArray(new IOpenMethod[0]);
            }
        }
        return OpenIterator.fromArray((Object[])this.methods);
    }

    protected IOpenIterator<IOpenMethod> selectMethods() {
        ASelector<IOpenMethod> sel = new ASelector<IOpenMethod>(){

            public int redefinedHashCode() {
                return "static".hashCode();
            }

            public boolean select(IOpenMethod m) {
                return m.isStatic();
            }
        };
        return AOpenIterator.select(this.openClass.getMethods().iterator(), (ISelector)sel);
    }

    public void setOpenClass(IOpenClass c) {
        this.openClass = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<IOpenMethod> methods(String name) {
        List<IOpenMethod> found;
        if (this.methodNameMap == null) {
            StaticClassLibrary staticClassLibrary = this;
            synchronized (staticClassLibrary) {
                this.methodNameMap = AOpenClass.buildMethodNameMap(this.methods());
            }
        }
        return (found = this.methodNameMap.get(name)) == null ? OpenIterator.EMPTY : found.iterator();
    }
}

