/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.MethodBoundNode;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.vm.IRuntimeEnv;

public class VariableArgumentsMethodBoundNode
extends MethodBoundNode {
    private int indexOfFirstVarArg;
    private Class<?> componentVarArgClass;

    public VariableArgumentsMethodBoundNode(ISyntaxNode syntaxNode, IBoundNode[] children, IMethodCaller methodWithLastArrayArgument, int indexOfLastEqualArgumentType, Class<?> componentVarArgClass) {
        super(syntaxNode, children, methodWithLastArrayArgument);
        this.indexOfFirstVarArg = indexOfLastEqualArgumentType;
        this.componentVarArgClass = componentVarArgClass;
    }

    @Override
    public Object evaluateRuntime(IRuntimeEnv env) throws OpenLRuntimeException {
        Object target = this.getTargetNode() == null ? env.getThis() : this.getTargetNode().evaluate(env);
        Object[] methodParameters = this.evaluateChildren(env);
        return this.getMethodCaller().invoke(target, this.modifyParameters(methodParameters), env);
    }

    private Object[] modifyParameters(Object[] methodParameters) {
        ArrayList<Object> parametersList = new ArrayList<Object>();
        if (this.indexOfFirstVarArg > 0) {
            for (int i = 0; i < this.indexOfFirstVarArg; ++i) {
                parametersList.add(methodParameters[i]);
            }
        }
        Object sameTypeParameters = this.getAllParametersOfTheSameType(methodParameters);
        parametersList.add(sameTypeParameters);
        return parametersList.toArray(new Object[parametersList.size()]);
    }

    private Object getAllParametersOfTheSameType(Object[] methodParameters) {
        int parametersOfTheSameType = methodParameters.length - this.indexOfFirstVarArg;
        Object sameTypeParameters = Array.newInstance(this.componentVarArgClass, parametersOfTheSameType);
        for (int i = 0; i < parametersOfTheSameType; ++i) {
            Array.set(sameTypeParameters, i, methodParameters[i + this.indexOfFirstVarArg]);
        }
        return sameTypeParameters;
    }
}

