/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.cast;

import java.util.HashMap;
import org.apache.commons.lang3.ClassUtils;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMethodFactory;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.impl.cast.AliasToTypeCast;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.cast.JavaBoxingCast;
import org.openl.binding.impl.cast.JavaDownCast;
import org.openl.binding.impl.cast.JavaNoCast;
import org.openl.binding.impl.cast.JavaUnboxingCast;
import org.openl.binding.impl.cast.JavaUpCast;
import org.openl.binding.impl.cast.MethodBasedCast;
import org.openl.binding.impl.cast.TypeToAliasCast;
import org.openl.cache.GenericKey;
import org.openl.ie.constrainer.ConstrainerObject;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;

public class CastFactory
implements ICastFactory {
    private static final String AUTO_CAST_METHOD_NAME = "autocast";
    private static final String CAST_METHOD_NAME = "cast";
    private static final String DISTANCE_METHOD_NAME = "distance";
    private static final JavaNoCast JAVA_NO_CAST = new JavaNoCast();
    private static final JavaUpCast JAVA_UP_CAST = new JavaUpCast();
    private static final JavaBoxingCast JAVA_BOXING_CAST = new JavaBoxingCast();
    private static final JavaUnboxingCast JAVA_UNBOXING_CAST = new JavaUnboxingCast();
    private static final JavaBoxingCast JAVA_BOXING_UP_CAST = new JavaBoxingCast(7);
    private IMethodFactory methodFactory;
    private HashMap<Object, IOpenCast> castCache = new HashMap();

    public IMethodFactory getMethodFactory() {
        return this.methodFactory;
    }

    public void setMethodFactory(IMethodFactory factory) {
        this.methodFactory = factory;
    }

    @Override
    public synchronized IOpenCast getCast(IOpenClass from, IOpenClass to) {
        GenericKey key = GenericKey.getInstance(from, to);
        IOpenCast cast = this.castCache.get(key);
        if (cast == null) {
            cast = this.findCast(from, to);
            this.castCache.put(key, cast);
        }
        return cast;
    }

    public IOpenCast findCast(IOpenClass from, IOpenClass to) {
        if (from.equals(to)) {
            return JAVA_NO_CAST;
        }
        if (to == NullOpenClass.the) {
            return null;
        }
        if (from == NullOpenClass.the && this.isPrimitive(to)) {
            return null;
        }
        if (from == NullOpenClass.the && !this.isPrimitive(to)) {
            return JAVA_UP_CAST;
        }
        IOpenCast typeCast = this.findAliasCast(from, to);
        IOpenCast javaCast = this.findJavaCast(from, to);
        if (typeCast == null) {
            typeCast = javaCast;
        } else if (javaCast != null && typeCast.getDistance(from, to) > javaCast.getDistance(from, to)) {
            typeCast = javaCast;
        }
        IOpenCast methodBasedCast = this.findMethodBasedCast(from, to, this.methodFactory);
        if (typeCast == null) {
            typeCast = methodBasedCast;
        } else if (methodBasedCast != null && typeCast.getDistance(from, to) > methodBasedCast.getDistance(from, to)) {
            typeCast = methodBasedCast;
        }
        return typeCast;
    }

    private boolean isPrimitive(IOpenClass openClass) {
        return openClass != null && openClass.getInstanceClass() != null && openClass.getInstanceClass().isPrimitive();
    }

    private IOpenCast findJavaCast(IOpenClass from, IOpenClass to) {
        IOpenCast typeCast = this.findBoxingCast(from, to);
        if (typeCast != null) {
            return typeCast;
        }
        typeCast = this.findUnBoxingCast(from, to);
        if (typeCast != null) {
            return typeCast;
        }
        Class<?> fromClass = from.getInstanceClass();
        Class<?> toClass = to.getInstanceClass();
        if (ConstrainerObject.class.isAssignableFrom(fromClass)) {
            return null;
        }
        if (toClass.isAssignableFrom(fromClass)) {
            return JAVA_UP_CAST;
        }
        if (this.isAllowJavaDowncast(fromClass, toClass)) {
            return new JavaDownCast(to, this);
        }
        return null;
    }

    private IOpenCast findBoxingCast(IOpenClass from, IOpenClass to) {
        Class<?> toClass;
        if (from == null || to == null || !this.isPrimitive(from) || this.isPrimitive(to)) {
            return null;
        }
        Class<?> fromClass = from.getInstanceClass();
        if (fromClass == ClassUtils.wrapperToPrimitive(toClass = to.getInstanceClass())) {
            return JAVA_BOXING_CAST;
        }
        if (toClass.isAssignableFrom(ClassUtils.primitiveToWrapper(fromClass))) {
            return JAVA_BOXING_UP_CAST;
        }
        if (fromClass == Void.TYPE && toClass == Void.class) {
            return JAVA_BOXING_CAST;
        }
        return null;
    }

    private IOpenCast findUnBoxingCast(IOpenClass from, IOpenClass to) {
        if (from == null || to == null || this.isPrimitive(from) || !this.isPrimitive(to)) {
            return null;
        }
        Class<?> fromClass = from.getInstanceClass();
        Class<?> toClass = to.getInstanceClass();
        if (toClass == ClassUtils.wrapperToPrimitive(fromClass)) {
            return JAVA_UNBOXING_CAST;
        }
        if (fromClass == Void.class && toClass == Void.TYPE) {
            return JAVA_UNBOXING_CAST;
        }
        return null;
    }

    private IOpenCast findAliasCast(IOpenClass from, IOpenClass to) {
        if (from instanceof DomainOpenClass || to instanceof DomainOpenClass) {
            if (from instanceof DomainOpenClass && !(to instanceof DomainOpenClass) && to.getInstanceClass().isAssignableFrom(from.getInstanceClass())) {
                return new AliasToTypeCast(from, to);
            }
            if (to instanceof DomainOpenClass && !(from instanceof DomainOpenClass) && from.getInstanceClass().isAssignableFrom(to.getInstanceClass())) {
                return new TypeToAliasCast(from, to);
            }
            if (from instanceof DomainOpenClass && to.getInstanceClass().isAssignableFrom(from.getClass())) {
                return JAVA_UP_CAST;
            }
        }
        return null;
    }

    private IOpenCast findMethodBasedCast(IOpenClass from, IOpenClass to, IMethodFactory methodFactory) {
        IOpenCast typeCast = this.findMethodCast(from, to, methodFactory);
        if (typeCast != null) {
            return typeCast;
        }
        typeCast = this.findMethodCast(from, to, from);
        if (typeCast != null) {
            return typeCast;
        }
        typeCast = this.findMethodCast(from, to, to);
        if (typeCast != null) {
            return typeCast;
        }
        return null;
    }

    private IOpenCast findMethodCast(IOpenClass from, IOpenClass to, IMethodFactory methodFactory) {
        JavaOpenClass wrapperOpenClassTo;
        JavaOpenClass wrapperOpenClassTo2;
        JavaOpenClass wrapperOpenClassFrom;
        if (methodFactory == null) {
            return null;
        }
        boolean auto = true;
        int distance = 5;
        IOpenMethod castCaller = null;
        Object toNullObject = to.nullObject();
        IOpenClass fromOpenClass = from;
        IOpenClass toOpenClass = to;
        Class primitiveClassFrom = ClassUtils.wrapperToPrimitive(from.getInstanceClass());
        Class primitiveClassTo = ClassUtils.wrapperToPrimitive(to.getInstanceClass());
        try {
            castCaller = methodFactory.getMatchingMethod(AUTO_CAST_METHOD_NAME, new IOpenClass[]{from, to});
            if (castCaller == null && primitiveClassFrom != null) {
                wrapperOpenClassFrom = JavaOpenClass.getOpenClass(primitiveClassFrom);
                fromOpenClass = wrapperOpenClassFrom;
                toOpenClass = to;
                castCaller = methodFactory.getMatchingMethod(AUTO_CAST_METHOD_NAME, new IOpenClass[]{wrapperOpenClassFrom, to});
            }
            if (castCaller == null && primitiveClassTo != null) {
                wrapperOpenClassTo2 = JavaOpenClass.getOpenClass(primitiveClassTo);
                castCaller = methodFactory.getMatchingMethod(AUTO_CAST_METHOD_NAME, new IOpenClass[]{from, wrapperOpenClassTo2});
                fromOpenClass = from;
                toOpenClass = wrapperOpenClassTo2;
                toNullObject = wrapperOpenClassTo2.nullObject();
            }
            if (castCaller == null && primitiveClassFrom != null && primitiveClassTo != null) {
                wrapperOpenClassFrom = JavaOpenClass.getOpenClass(primitiveClassFrom);
                wrapperOpenClassTo = JavaOpenClass.getOpenClass(primitiveClassTo);
                fromOpenClass = wrapperOpenClassFrom;
                toOpenClass = wrapperOpenClassTo;
                castCaller = methodFactory.getMatchingMethod(AUTO_CAST_METHOD_NAME, new IOpenClass[]{wrapperOpenClassFrom, wrapperOpenClassTo});
            }
        }
        catch (AmbiguousMethodException wrapperOpenClassFrom2) {
            // empty catch block
        }
        if (castCaller == null) {
            auto = false;
            try {
                castCaller = methodFactory.getMatchingMethod(CAST_METHOD_NAME, new IOpenClass[]{from, to});
                distance = 9;
                if (castCaller == null && primitiveClassFrom != null) {
                    distance = 9;
                    wrapperOpenClassFrom = JavaOpenClass.getOpenClass(primitiveClassFrom);
                    fromOpenClass = wrapperOpenClassFrom;
                    toOpenClass = to;
                    castCaller = methodFactory.getMatchingMethod(CAST_METHOD_NAME, new IOpenClass[]{wrapperOpenClassFrom, to});
                }
                if (castCaller == null && primitiveClassTo != null) {
                    distance = 9;
                    wrapperOpenClassTo2 = JavaOpenClass.getOpenClass(primitiveClassTo);
                    castCaller = methodFactory.getMatchingMethod(CAST_METHOD_NAME, new IOpenClass[]{from, wrapperOpenClassTo2});
                    fromOpenClass = from;
                    toOpenClass = wrapperOpenClassTo2;
                    toNullObject = wrapperOpenClassTo2.nullObject();
                }
                if (castCaller == null && primitiveClassFrom != null && primitiveClassTo != null) {
                    distance = 9;
                    wrapperOpenClassFrom = JavaOpenClass.getOpenClass(primitiveClassFrom);
                    wrapperOpenClassTo = JavaOpenClass.getOpenClass(primitiveClassTo);
                    fromOpenClass = wrapperOpenClassFrom;
                    toOpenClass = wrapperOpenClassTo;
                    castCaller = methodFactory.getMatchingMethod(CAST_METHOD_NAME, new IOpenClass[]{wrapperOpenClassFrom, wrapperOpenClassTo});
                }
            }
            catch (AmbiguousMethodException wrapperOpenClassFrom3) {
                // empty catch block
            }
        }
        if (castCaller == null) {
            return null;
        }
        IOpenMethod distanceCaller = null;
        try {
            distanceCaller = methodFactory.getMatchingMethod(DISTANCE_METHOD_NAME, new IOpenClass[]{fromOpenClass, toOpenClass});
        }
        catch (AmbiguousMethodException ambiguousMethodException) {
            // empty catch block
        }
        if (distanceCaller != null) {
            distance = (Integer)distanceCaller.invoke(null, new Object[]{fromOpenClass.nullObject(), toOpenClass.nullObject()}, null);
        }
        return new MethodBasedCast(castCaller, auto, distance, toNullObject);
    }

    private boolean isAllowJavaDowncast(Class<?> from, Class<?> to) {
        if (from.isAssignableFrom(to)) {
            return true;
        }
        if (!from.isPrimitive() && to.isInterface()) {
            return true;
        }
        return !to.isPrimitive() && from.isInterface();
    }
}

