/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.component;

import java.util.HashMap;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.binding.ILocalVar;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.exception.AmbiguousVarException;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.binding.impl.BindingContextDelegator;
import org.openl.binding.impl.MethodSearch;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.exception.OpenLCompilationException;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.util.StringTool;

public class ComponentBindingContext
extends BindingContextDelegator {
    private ComponentOpenClass componentOpenClass;
    private Map<String, IOpenClass> internalTypes = null;

    public ComponentBindingContext(IBindingContext delegate, ComponentOpenClass componentOpenClass) {
        super(delegate);
        this.componentOpenClass = componentOpenClass;
    }

    public ComponentOpenClass getComponentOpenClass() {
        return this.componentOpenClass;
    }

    @Override
    public synchronized void addType(String namespace, IOpenClass type) throws OpenLCompilationException {
        String nameWithNamespace = StringTool.buildTypeName((String)namespace, (String)type.getName());
        this.add(nameWithNamespace, type);
    }

    private synchronized void add(String nameWithNamespace, IOpenClass type) throws OpenLCompilationException {
        Map<String, IOpenClass> map = this.initInternalTypes();
        if (map.containsKey(nameWithNamespace)) {
            IOpenClass openClass = map.get(nameWithNamespace);
            if (openClass == type) {
                return;
            }
            throw new OpenLCompilationException("Type " + nameWithNamespace + " has been defined already");
        }
        map.put(nameWithNamespace, type);
    }

    public synchronized Map<String, IOpenClass> getInternalTypes() {
        return new HashMap<String, IOpenClass>(this.initInternalTypes());
    }

    @Override
    public synchronized void addTypes(Map<String, IOpenClass> types) throws OpenLCompilationException {
        for (String nameWithNamespace : types.keySet()) {
            this.add(nameWithNamespace, types.get(nameWithNamespace));
        }
    }

    @Override
    public synchronized void removeType(String namespace, IOpenClass type) throws Exception {
        String key = StringTool.buildTypeName((String)namespace, (String)type.getName());
        Map<String, IOpenClass> map = this.initInternalTypes();
        map.remove(key);
    }

    @Override
    public ILocalVar addVar(String namespace, String name, IOpenClass type) throws DuplicatedVarException {
        return null;
    }

    private synchronized Map<String, IOpenClass> initInternalTypes() {
        if (this.internalTypes == null) {
            this.internalTypes = new HashMap<String, IOpenClass>();
        }
        return this.internalTypes;
    }

    @Override
    public IMethodCaller findMethodCaller(String namespace, String methodName, IOpenClass[] parTypes) throws AmbiguousMethodException {
        IMethodCaller imc = null;
        if ("org.openl.this".equals(namespace)) {
            imc = MethodSearch.getMethodCaller(methodName, parTypes, this, this.componentOpenClass);
        }
        return imc != null ? imc : super.findMethodCaller(namespace, methodName, parTypes);
    }

    @Override
    public IOpenClass findType(String namespace, String typeName) {
        String key;
        IOpenClass ioc;
        if (this.internalTypes != null && (ioc = this.internalTypes.get(key = StringTool.buildTypeName((String)namespace, (String)typeName))) != null) {
            return ioc;
        }
        return super.findType(namespace, typeName);
    }

    @Override
    public IOpenField findVar(String namespace, String name, boolean strictMatch) throws AmbiguousVarException {
        IOpenField res = null;
        if (namespace.equals("org.openl.this")) {
            res = this.componentOpenClass.getField(name, strictMatch);
        }
        return res != null ? res : super.findVar(namespace, name, strictMatch);
    }
}

