/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.module;

import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundMethodNode;
import org.openl.binding.IBoundNode;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.ABoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.ControlSignalReturn;
import org.openl.binding.impl.module.DeferredMethod;
import org.openl.binding.impl.module.MethodBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;

public class MethodNode
extends ABoundNode
implements IBoundMethodNode,
IMemberBoundNode {
    int localFrameSize;
    int parametersSize;
    DeferredMethod deferredMethod;

    public MethodNode(ISyntaxNode syntaxNode, DeferredMethod deferredMethod) {
        super(syntaxNode, new IBoundNode[0]);
        this.deferredMethod = deferredMethod;
    }

    @Override
    public void addTo(ModuleOpenClass openClass) {
        openClass.addMethod(this.deferredMethod);
    }

    @Override
    public Object evaluateRuntime(IRuntimeEnv env) throws OpenLRuntimeException {
        try {
            return this.children[0].evaluate(env);
        }
        catch (ControlSignalReturn signal) {
            return signal.getReturnValue();
        }
        catch (OpenLRuntimeException opex) {
            opex.pushMethodNode(this);
            throw opex;
        }
    }

    @Override
    public void finalizeBind(IBindingContext cxt) throws Exception {
        MethodBindingContext mbc = new MethodBindingContext(this.deferredMethod, cxt);
        ISyntaxNode bodyNode = this.deferredMethod.getMethodBodyNode();
        IBoundNode boundBodyNode = ANodeBinder.bindChildNode(bodyNode, mbc);
        this.deferredMethod.setMethodBodyBoundNode((IBoundMethodNode)boundBodyNode);
    }

    @Override
    public int getLocalFrameSize() {
        return this.localFrameSize;
    }

    public String getName() {
        return this.deferredMethod.getName();
    }

    @Override
    public int getParametersSize() {
        return this.parametersSize;
    }

    @Override
    public IOpenClass getType() {
        return this.deferredMethod.getType();
    }

    @Override
    public void updateDependency(BindingDependencies dependencies) {
    }

    @Override
    public boolean isLiteralExpressionParent() {
        return false;
    }

    @Override
    public void removeDebugInformation(IBindingContext cxt) throws Exception {
    }
}

