/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openl.CompiledOpenClass;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.binding.impl.module.ModuleBindingContext;
import org.openl.dependency.CompiledDependency;
import org.openl.exception.OpenLCompilationException;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.impl.AMethod;
import org.openl.util.Log;
import org.openl.util.StringTool;

public class ModuleOpenClass
extends ComponentOpenClass {
    private Map<String, IOpenClass> internalTypes = new HashMap<String, IOpenClass>();
    private Set<CompiledDependency> usingModules = new HashSet<CompiledDependency>();
    private List<Throwable> errors = new ArrayList<Throwable>();

    public ModuleOpenClass(String name, OpenL openl) {
        super(name, openl);
    }

    protected void initDependencies() {
        for (CompiledDependency dependency : this.usingModules) {
            this.addMethods(dependency);
        }
    }

    private void addMethods(CompiledDependency dependency) {
        CompiledOpenClass compiledOpenClass = dependency.getCompiledOpenClass();
        for (IOpenMethod depMethod : compiledOpenClass.getOpenClassWithErrors().getMethods()) {
            if (depMethod instanceof ADynamicClass.OpenConstructor || depMethod instanceof ComponentOpenClass.GetOpenClass) continue;
            try {
                AMethod methodDependencyInfo;
                if (depMethod instanceof AMethod && (methodDependencyInfo = (AMethod)depMethod).getModuleName() == null) {
                    methodDependencyInfo.setModuleName(dependency.getDependencyName());
                }
                this.addMethod(depMethod);
            }
            catch (OpenlNotCheckedException e) {
                if (Log.isDebugEnabled()) {
                    Log.debug((Object)e.getMessage(), (Throwable)e);
                }
                this.addError(e);
            }
        }
    }

    @Override
    public IOpenField getField(String fname, boolean strictMatch) {
        IOpenField field = super.getField(fname, strictMatch);
        if (field != null) {
            return field;
        }
        for (CompiledDependency dependency : this.usingModules) {
            CompiledOpenClass compiledOpenClass = dependency.getCompiledOpenClass();
            if (compiledOpenClass.hasErrors() || (field = compiledOpenClass.getOpenClass().getField(fname, strictMatch)) == null) continue;
            return field;
        }
        return null;
    }

    @Override
    public Map<String, IOpenField> getFields() {
        HashMap<String, IOpenField> fields = new HashMap<String, IOpenField>();
        for (CompiledDependency dependency : this.usingModules) {
            CompiledOpenClass compiledOpenClass = dependency.getCompiledOpenClass();
            if (compiledOpenClass.hasErrors()) continue;
            fields.putAll(compiledOpenClass.getOpenClass().getFields());
        }
        fields.putAll(super.getFields());
        return fields;
    }

    public void setDependencies(Set<CompiledDependency> moduleDependencies) {
        if (moduleDependencies != null) {
            this.usingModules = new HashSet<CompiledDependency>(moduleDependencies);
        }
    }

    public Set<CompiledDependency> getDependencies() {
        if (this.usingModules == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.usingModules);
    }

    @Override
    public Map<String, IOpenClass> getTypes() {
        HashMap<String, IOpenClass> currentModuleDatatypes = new HashMap<String, IOpenClass>(this.internalTypes);
        for (CompiledDependency dependency : this.usingModules) {
            CompiledOpenClass compiledOpenClass = dependency.getCompiledOpenClass();
            currentModuleDatatypes.putAll(compiledOpenClass.getTypes());
        }
        return currentModuleDatatypes;
    }

    @Override
    public void addType(String namespace, IOpenClass type) throws OpenLCompilationException {
        String typeNameWithNamespace = StringTool.buildTypeName((String)namespace, (String)type.getName());
        this.add(typeNameWithNamespace, type);
    }

    private void add(String typeNameWithNamespace, IOpenClass type) throws OpenLCompilationException {
        if (this.internalTypes.containsKey(typeNameWithNamespace)) {
            throw new OpenLCompilationException("The type " + typeNameWithNamespace + " has been already defined.");
        }
        this.internalTypes.put(typeNameWithNamespace, type);
    }

    public IBindingContext makeBindingContext(IBindingContext topLevelContext) {
        return new ModuleBindingContext(topLevelContext, this);
    }

    public void addError(Throwable error) {
        this.errors.add(error);
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }
}

