/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openl.binding.exception.AmbiguousVarException;
import org.openl.binding.impl.module.VariableInContextFinder;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.OpenFieldDelegator;
import org.openl.vm.IRuntimeEnv;

public class RootDictionaryContext
implements VariableInContextFinder {
    protected IOpenField[] roots;
    protected int maxDepthLevel;
    protected HashMap<String, List<IOpenField>> fields = new HashMap();

    public RootDictionaryContext(IOpenField[] roots, int maxDepthLevel) {
        this.roots = roots;
        this.maxDepthLevel = maxDepthLevel;
        this.initializeRoots();
    }

    private synchronized void add(ContextField contextField) {
        String name = contextField.getName().toLowerCase();
        List<IOpenField> ff = this.fields.get(name);
        if (ff == null) {
            ff = new ArrayList<IOpenField>();
            ff.add(contextField);
            this.fields.put(name, ff);
            return;
        }
        if (ff.contains(contextField)) {
            return;
        }
        ff.add(contextField);
    }

    @Override
    public IOpenField findVariable(String name) {
        return this.findField(name);
    }

    public IOpenField findField(String name) {
        List<IOpenField> ff = this.fields.get(name = name.toLowerCase());
        if (ff == null) {
            return null;
        }
        if (ff.size() > 1) {
            throw new AmbiguousVarException(name, ff);
        }
        return ff.get(0);
    }

    protected final void initializeField(IOpenField parent, IOpenField field, int level) {
        if (level > this.maxDepthLevel) {
            return;
        }
        IOpenClass fieldType = field.getType();
        this.add(new ContextField(parent, field));
        if (fieldType.isSimple()) {
            return;
        }
        for (IOpenField openField : fieldType.getFields().values()) {
            this.initializeField(field, openField, level + 1);
        }
    }

    private void initializeRoots() {
        for (IOpenField root : this.roots) {
            this.initializeField(null, root, 0);
        }
    }

    static class ContextField
    extends OpenFieldDelegator {
        IOpenField parent;

        protected ContextField(IOpenField parent, IOpenField delegate) {
            super(delegate);
            this.parent = parent;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            if (obj instanceof ContextField) {
                ContextField cf = (ContextField)obj;
                if (this.parent == null) {
                    return null == cf.parent;
                }
                return this.parent.equals(cf.parent);
            }
            return false;
        }

        @Override
        public Object get(Object target, IRuntimeEnv env) {
            if (this.parent != null) {
                target = this.parent.get(target, env);
            }
            return super.get(target, env);
        }

        @Override
        public String getDisplayName(int mode) {
            if (mode == 2) {
                if (this.parent != null) {
                    return this.parent.getDisplayName(mode) + "." + this.field.getDisplayName(mode);
                }
                return this.field.getDisplayName(mode);
            }
            return super.getDisplayName(mode);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + (this.parent == null ? 0 : this.parent.hashCode());
        }

        @Override
        public void set(Object target, Object value, IRuntimeEnv env) {
            if (this.parent != null) {
                target = this.parent.get(target, env);
            }
            super.set(target, value, env);
        }
    }
}

