/*
 * Decompiled with CFR 0.152.
 */
package org.openl.cache;

import java.util.Arrays;
import org.apache.commons.lang3.builder.EqualsBuilder;

public final class GenericKey {
    private static final GenericKey EMPTY_GENERIC_KEY = new GenericKey(new Object[0]);
    private Object[] objects;

    private GenericKey(Object ... objects) {
        if (objects == null) {
            throw new IllegalArgumentException("objects arg can't be null");
        }
        this.objects = Arrays.copyOf(objects, objects.length);
    }

    public static GenericKey getInstance(Object ... objects) {
        if (objects == null || objects.length == 0) {
            return EMPTY_GENERIC_KEY;
        }
        return new GenericKey(objects);
    }

    public boolean equals(Object x) {
        if (!(x instanceof GenericKey)) {
            return false;
        }
        GenericKey anotherKey = (GenericKey)x;
        if (this.objects.length != anotherKey.objects.length) {
            return false;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        for (int i = 0; i < this.objects.length; ++i) {
            equalsBuilder.append(this.objects[i], anotherKey.objects[i]);
        }
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return this.objects != null ? Arrays.hashCode(this.objects) : 0;
    }
}

