/*
 * Decompiled with CFR 0.152.
 */
package org.openl.classloader;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.jar.JarFile;
import org.openl.classloader.ClassLoaderCloser;
import org.openl.classloader.OpenLBundleClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderCloserFactory {
    public static ClassLoaderCloser getClassLoaderCloser() {
        return ClassLoaderCloserHolder.instance;
    }

    private ClassLoaderCloserFactory() {
    }

    private static class DummyClassLoaderCloser
    extends BaseClassLoaderCloser {
        private DummyClassLoaderCloser() {
        }

        @Override
        protected void closeClassLoader(URLClassLoader classLoader) {
        }
    }

    private static class SunJava6ClassLoaderCloser
    extends BaseClassLoaderCloser {
        private final Logger log = LoggerFactory.getLogger(SunJava6ClassLoaderCloser.class);

        private SunJava6ClassLoaderCloser() {
        }

        @Override
        protected void closeClassLoader(URLClassLoader classLoader) {
            try {
                Class<URLClassLoader> clazz = URLClassLoader.class;
                Field ucp = clazz.getDeclaredField("ucp");
                ucp.setAccessible(true);
                Object sunMiscURLClassPath = ucp.get(classLoader);
                Field loaders = sunMiscURLClassPath.getClass().getDeclaredField("loaders");
                loaders.setAccessible(true);
                Object collection = loaders.get(sunMiscURLClassPath);
                for (Object sunMiscURLClassPathJarLoader : ((Collection)collection).toArray()) {
                    try {
                        Field loader = sunMiscURLClassPathJarLoader.getClass().getDeclaredField("jar");
                        loader.setAccessible(true);
                        Object jarFile = loader.get(sunMiscURLClassPathJarLoader);
                        ((JarFile)jarFile).close();
                    }
                    catch (NoSuchFieldException loader) {
                    }
                    catch (Throwable t) {
                        this.log.error(t.getMessage(), t);
                    }
                }
            }
            catch (Throwable t) {
                this.log.error(t.getMessage(), t);
            }
        }
    }

    private static class Java7ClassLoaderCloser
    extends BaseClassLoaderCloser {
        private final Logger log = LoggerFactory.getLogger(Java7ClassLoaderCloser.class);
        private final Method close;

        private Java7ClassLoaderCloser(Method close) {
            this.close = close;
        }

        @Override
        protected void closeClassLoader(URLClassLoader classLoader) {
            try {
                this.close.invoke((Object)classLoader, new Object[0]);
            }
            catch (Exception e) {
                this.log.error("Can't close ClassLoader '{}': {}", new Object[]{classLoader, e.getMessage(), e});
            }
        }
    }

    private static abstract class BaseClassLoaderCloser
    implements ClassLoaderCloser {
        private BaseClassLoaderCloser() {
        }

        @Override
        public final void close(ClassLoader classLoader) {
            if (classLoader instanceof URLClassLoader) {
                this.closeClassLoader((URLClassLoader)classLoader);
                if (classLoader instanceof OpenLBundleClassLoader) {
                    ((OpenLBundleClassLoader)classLoader).closeBundleClassLoaders();
                }
            }
        }

        protected abstract void closeClassLoader(URLClassLoader var1);
    }

    private static class ClassLoaderCloserHolder {
        private static final ClassLoaderCloser instance;

        private ClassLoaderCloserHolder() {
        }

        private static ClassLoaderCloser getOlderClassLoaderCloser(Logger log) {
            BaseClassLoaderCloser closer;
            boolean isSun;
            String vendor = ClassLoaderCloserHolder.getVendor(log);
            log.info("Your java vendor: {}", (Object)vendor);
            boolean bl = isSun = vendor != null && (vendor.startsWith("Sun") || vendor.startsWith("Oracle"));
            if (isSun) {
                closer = new SunJava6ClassLoaderCloser();
            } else {
                log.warn("Your java vendor '{}' isn't supported. Some jars can be locked.", (Object)vendor);
                closer = new DummyClassLoaderCloser();
            }
            return closer;
        }

        private static String getVendor(Logger log) {
            String vendor = null;
            try {
                vendor = System.getProperty("java.vendor");
            }
            catch (SecurityException se) {
                log.error(se.getMessage(), (Throwable)se);
            }
            return vendor;
        }

        static {
            ClassLoaderCloser closer;
            Logger log = LoggerFactory.getLogger(ClassLoaderCloserHolder.class);
            try {
                Method method = URLClassLoader.class.getMethod("close", new Class[0]);
                closer = Modifier.isPublic(method.getModifiers()) ? new Java7ClassLoaderCloser(method) : ClassLoaderCloserHolder.getOlderClassLoaderCloser(log);
            }
            catch (NoSuchMethodException e) {
                closer = ClassLoaderCloserHolder.getOlderClassLoaderCloser(log);
            }
            catch (SecurityException t) {
                log.error(t.getMessage(), (Throwable)t);
                closer = new DummyClassLoaderCloser();
            }
            log.info("ClassLoaderCloser implementation: {}", (Object)closer.getClass().getSimpleName());
            instance = closer;
        }
    }
}

