/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openl.conf.AConfigurationElement;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.ITypeFactoryConfigurationElement;
import org.openl.conf.OpenConfigurationException;
import org.openl.types.ITypeLibrary;
import org.openl.types.java.JavaImportTypeLibrary;

public class JavaImportTypeConfiguration
extends AConfigurationElement
implements ITypeFactoryConfigurationElement {
    private List<String> classes = new ArrayList<String>();
    private List<String> imports = new ArrayList<String>();
    private ITypeLibrary library = null;

    public void addConfiguredClassName(String className) {
        if (StringUtils.isNotEmpty((CharSequence)className)) {
            this.classes.add(className);
        }
    }

    public void addConfiguredImport(String anImport) {
        if (StringUtils.isNotEmpty((CharSequence)anImport)) {
            this.imports.add(anImport);
        }
    }

    @Override
    public synchronized ITypeLibrary getLibrary(IConfigurableResourceContext cxt) {
        if (this.library == null) {
            this.library = new JavaImportTypeLibrary(this.classes, this.imports, cxt.getClassLoader());
        }
        return this.library;
    }

    public void setAllImports(Collection<String> allImports) {
        if (allImports != null && !allImports.isEmpty()) {
            this.imports = new ArrayList<String>(allImports);
        }
    }

    public void setImport(String singleImport) {
        if (StringUtils.isNotEmpty((CharSequence)singleImport)) {
            this.imports.add(singleImport);
        }
    }

    @Override
    public void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
    }
}

