/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.util.Collection;
import java.util.HashSet;
import org.openl.OpenL;
import org.openl.conf.AOpenLBuilder;
import org.openl.conf.JavaImportTypeConfiguration;
import org.openl.conf.JavaLibraryConfiguration;
import org.openl.conf.LibraryFactoryConfiguration;
import org.openl.conf.NameSpacedLibraryConfiguration;
import org.openl.conf.NameSpacedTypeConfiguration;
import org.openl.conf.NoAntOpenLTask;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.TypeFactoryConfiguration;

public class OpenLBuilderImpl
extends AOpenLBuilder {
    private String extendsCategory = "org.openl.j";
    private String category;
    private Collection<String> imports = new HashSet<String>();
    private String libName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenL build(String category) throws OpenConfigurationException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader userEnvitonmentContextClassLoader = this.getUserEnvironmentContext().getUserClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(userEnvitonmentContextClassLoader);
            OpenL.getInstance(this.extendsCategory, this.getUserEnvironmentContext());
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return super.build(category);
    }

    public String getCategory() {
        return this.category;
    }

    public String getExtendsCategory() {
        return this.extendsCategory;
    }

    public Collection<String> getImports() {
        return this.imports;
    }

    public String getLibName() {
        return this.libName;
    }

    @Override
    public NoAntOpenLTask getNoAntOpenLTask() {
        NoAntOpenLTask op = new NoAntOpenLTask();
        op.setExtendsCategory(this.extendsCategory);
        op.setCategory(this.category);
        if (this.libName != null) {
            LibraryFactoryConfiguration libraries = op.createLibraries();
            NameSpacedLibraryConfiguration library = new NameSpacedLibraryConfiguration();
            library.setNamespace("org.openl.this");
            JavaLibraryConfiguration javalib = new JavaLibraryConfiguration();
            javalib.setClassName(this.libName);
            library.addJavalib(javalib);
            libraries.addConfiguredLibrary(library);
        }
        if (!this.getImports().isEmpty()) {
            TypeFactoryConfiguration types = op.createTypes();
            NameSpacedTypeConfiguration typelibrary = new NameSpacedTypeConfiguration();
            typelibrary.setNamespace("org.openl.this");
            JavaImportTypeConfiguration javaimport = new JavaImportTypeConfiguration();
            javaimport = new JavaImportTypeConfiguration();
            javaimport.setAllImports(this.getImports());
            typelibrary.addConfiguration(javaimport);
            types.addConfiguredTypeLibrary(typelibrary);
        }
        return op;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setExtendsCategory(String extendsCategory) {
        this.extendsCategory = extendsCategory;
    }

    public void setImports(Collection<String> imports) {
        this.imports = imports;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }
}

