/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.util.HashMap;
import java.util.Map;
import org.openl.binding.ICastFactory;
import org.openl.binding.INodeBinder;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.cache.GenericKey;
import org.openl.conf.ClassFactory;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IOpenFactoryConfiguration;
import org.openl.conf.IOpenLConfiguration;
import org.openl.conf.IUserContext;
import org.openl.conf.LibraryFactoryConfiguration;
import org.openl.conf.NodeBinderFactoryConfiguration;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.OpenFactoryConfiguration;
import org.openl.conf.TypeCastFactory;
import org.openl.conf.TypeFactoryConfiguration;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.grammar.IGrammar;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenFactory;
import org.openl.types.IOpenField;

public class OpenLConfiguration
implements IOpenLConfiguration {
    private static HashMap<Object, IOpenLConfiguration> configurations = new HashMap();
    private String uri;
    private IOpenLConfiguration parent;
    private IConfigurableResourceContext configurationContext;
    private ClassFactory grammarFactory;
    private NodeBinderFactoryConfiguration binderFactory;
    private LibraryFactoryConfiguration methodFactory;
    private TypeCastFactory typeCastFactory;
    private TypeFactoryConfiguration typeFactory;
    private Map<String, IOpenFactoryConfiguration> openFactories = null;

    public static IOpenLConfiguration getInstance(String name, IUserContext ucxt) throws OpenConfigurationException {
        IOpenLConfiguration opc = configurations.get(name);
        if (opc != null) {
            return opc;
        }
        GenericKey key = GenericKey.getInstance(name, ucxt);
        return configurations.get(key);
    }

    public static synchronized void register(String name, IUserContext ucxt, IOpenLConfiguration oplc, boolean shared) throws OpenConfigurationException {
        Object key = null;
        key = shared ? name : GenericKey.getInstance(name, ucxt);
        IOpenLConfiguration old = configurations.get(key);
        if (old != null) {
            throw new OpenConfigurationException("The configuration " + name + " already exists", null, null);
        }
        configurations.put(key, oplc);
    }

    public static void reset() {
        configurations = new HashMap();
    }

    public static synchronized void unregister(String name, IUserContext ucxt) throws OpenConfigurationException {
        GenericKey key = GenericKey.getInstance(name);
        configurations.remove(key);
        configurations.remove(name);
    }

    @Override
    public synchronized void addOpenFactory(IOpenFactoryConfiguration opfc) throws OpenConfigurationException {
        if (this.openFactories == null) {
            this.openFactories = new HashMap<String, IOpenFactoryConfiguration>();
        }
        if (opfc.getName() == null) {
            throw new OpenConfigurationException("The factory must have a name", opfc.getUri(), null);
        }
        if (this.openFactories.containsKey(opfc.getName())) {
            throw new OpenConfigurationException("Duplicated name: " + opfc.getName(), opfc.getUri(), null);
        }
        this.openFactories.put(opfc.getName(), opfc);
    }

    public NodeBinderFactoryConfiguration getBinderFactory() {
        return this.binderFactory;
    }

    @Override
    public IOpenCast getCast(IOpenClass from, IOpenClass to) {
        IOpenCast cast;
        IOpenCast iOpenCast = cast = this.typeCastFactory == null ? null : this.typeCastFactory.getCast(from, to, this.configurationContext);
        if (cast != null) {
            return cast;
        }
        return this.parent == null ? null : this.parent.getCast(from, to);
    }

    @Override
    public IConfigurableResourceContext getConfigurationContext() {
        return this.configurationContext;
    }

    @Override
    public synchronized IGrammar getGrammar() throws OpenConfigurationException {
        return this.grammarFactory == null ? this.parent.getGrammar() : (IGrammar)this.grammarFactory.getResource(this.configurationContext);
    }

    public ClassFactory getGrammarFactory() {
        return this.grammarFactory;
    }

    @Override
    public IMethodCaller getMethodCaller(String namespace, String name, IOpenClass[] params, ICastFactory casts) throws AmbiguousMethodException {
        IMethodCaller mc;
        IMethodCaller iMethodCaller = mc = this.methodFactory == null ? null : this.methodFactory.getMethodCaller(namespace, name, params, casts, this.configurationContext);
        if (mc != null) {
            return mc;
        }
        return this.parent == null ? null : this.parent.getMethodCaller(namespace, name, params, casts);
    }

    public LibraryFactoryConfiguration getMethodFactory() {
        return this.methodFactory;
    }

    @Override
    public INodeBinder getNodeBinder(ISyntaxNode node) {
        INodeBinder binder;
        INodeBinder iNodeBinder = binder = this.binderFactory == null ? null : this.binderFactory.getNodeBinder(node, this.configurationContext);
        if (binder != null) {
            return binder;
        }
        return this.parent == null ? null : this.parent.getNodeBinder(node);
    }

    @Override
    public IOpenFactory getOpenFactory(String name) {
        OpenFactoryConfiguration conf;
        OpenFactoryConfiguration openFactoryConfiguration = conf = this.openFactories == null ? null : (OpenFactoryConfiguration)this.openFactories.get(name);
        if (conf != null) {
            return conf.getOpenFactory(this.configurationContext);
        }
        if (this.parent != null) {
            return this.parent.getOpenFactory(name);
        }
        return null;
    }

    @Override
    public IOpenClass getType(String namespace, String name) {
        IOpenClass type;
        IOpenClass iOpenClass = type = this.typeFactory == null ? null : this.typeFactory.getType(namespace, name, this.configurationContext);
        if (type != null) {
            return type;
        }
        return this.parent == null ? null : this.parent.getType(namespace, name);
    }

    public TypeCastFactory getTypeCastFactory() {
        return this.typeCastFactory;
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    public IOpenField getVar(String namespace, String name, boolean strictMatch) {
        IOpenField field;
        IOpenField iOpenField = field = this.methodFactory == null ? null : this.methodFactory.getVar(namespace, name, this.configurationContext, strictMatch);
        if (field != null) {
            return field;
        }
        return this.parent == null ? null : this.parent.getVar(namespace, name, strictMatch);
    }

    public void setBinderFactory(NodeBinderFactoryConfiguration factory) {
        this.binderFactory = factory;
    }

    public void setConfigurationContext(IConfigurableResourceContext context) {
        this.configurationContext = context;
    }

    public void setGrammarFactory(ClassFactory factory) {
        this.grammarFactory = factory;
    }

    public void setMethodFactory(LibraryFactoryConfiguration factory) {
        this.methodFactory = factory;
    }

    public void setParent(IOpenLConfiguration configuration) {
        this.parent = configuration;
    }

    public void setTypeCastFactory(TypeCastFactory factory) {
        this.typeCastFactory = factory;
    }

    public void setTypeFactory(TypeFactoryConfiguration configuration) {
        this.typeFactory = configuration;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public synchronized void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
        if (this.grammarFactory != null) {
            this.grammarFactory.validate(cxt);
        } else if (this.parent == null) {
            throw new OpenConfigurationException("Grammar class is not set", this.getUri(), null);
        }
        if (this.binderFactory != null) {
            this.binderFactory.validate(cxt);
        } else if (this.parent == null) {
            throw new OpenConfigurationException("Bindings are not set", this.getUri(), null);
        }
        if (this.methodFactory != null) {
            this.methodFactory.validate(cxt);
        }
        if (this.typeCastFactory != null) {
            this.typeCastFactory.validate(cxt);
        }
        if (this.typeFactory != null) {
            this.typeFactory.validate(cxt);
        }
        if (this.openFactories != null) {
            for (IOpenFactoryConfiguration factory : this.openFactories.values()) {
                factory.validate(cxt);
            }
        }
    }
}

