/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.Stack;
import org.openl.conf.AUserContext;
import org.openl.conf.IExecutable;
import org.openl.conf.IUserContext;

public final class UserContext
extends AUserContext {
    static ThreadLocal<Stack<IUserContext>> contextStack = new ThreadLocal();
    private ClassLoader userClassLoader;
    private String userHome;
    private Properties userProperties;

    public static IUserContext currentContext() {
        Stack<IUserContext> stack = contextStack.get();
        if (stack == null || stack.size() == 0) {
            return null;
        }
        return stack.peek();
    }

    @Deprecated
    public static IUserContext makeOrLoadContext(ClassLoader cl, String home) {
        return UserContext.getCurrentContextOrCreateNew(cl, home);
    }

    public static IUserContext getCurrentContextOrCreateNew(ClassLoader cl, String home) {
        IUserContext cxt = UserContext.currentContext();
        if (cxt != null) {
            return cxt;
        }
        return new UserContext(cl, home);
    }

    public static void popCurrentContext() {
        contextStack.get().pop();
    }

    public static void pushCurrentContext(IUserContext cxt) {
        Stack<IUserContext> stack = contextStack.get();
        if (stack == null) {
            stack = new Stack();
            contextStack.set(stack);
        }
        stack.push(cxt);
    }

    public UserContext(ClassLoader userClassLoader, String userHome) {
        this(userClassLoader, userHome, null);
    }

    public UserContext(ClassLoader userClassLoader, String userHome, Properties userProperties) {
        this.userClassLoader = userClassLoader;
        this.userHome = UserContext.normalizeUserHome(userHome);
        this.userProperties = userProperties;
    }

    public static String normalizeUserHome(String userHome) {
        String currentWorkDirectory = new File(userHome).getAbsolutePath();
        return currentWorkDirectory;
    }

    @Override
    public Object execute(IExecutable exe) {
        try {
            UserContext.pushCurrentContext(this);
            Object object = exe.execute();
            return object;
        }
        finally {
            UserContext.popCurrentContext();
        }
    }

    @Override
    public ClassLoader getUserClassLoader() {
        return this.userClassLoader;
    }

    @Override
    public String getUserHome() {
        return this.userHome;
    }

    @Override
    public Properties getUserProperties() {
        return new Properties(this.userProperties);
    }

    private String printClassloader(ClassLoader ucl) {
        if (ucl == null) {
            return "null";
        }
        if (ucl instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)ucl).getURLs();
            StringBuilder sb = new StringBuilder();
            sb.append("ClassLoader URLs: ");
            for (URL url : urls) {
                sb.append(url.toExternalForm());
                sb.append(',');
            }
            return sb.toString();
        }
        return ucl.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("home=").append(this.userHome).append("cl=").append(this.printClassloader(this.userClassLoader));
        return sb.toString();
    }
}

