/*
 * Decompiled with CFR 0.152.
 */
package org.openl.dependency;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.dependency.CompiledDependency;
import org.openl.dependency.IDependencyManager;
import org.openl.dependency.loader.IDependencyLoader;
import org.openl.exception.OpenLCompilationException;
import org.openl.syntax.code.IDependency;

public abstract class DependencyManager
implements IDependencyManager {
    private boolean executionMode;
    private Map<String, Object> externalParameters;
    private Map<String, CompiledDependency> compiledDependencies = new HashMap<String, CompiledDependency>();

    @Override
    public CompiledDependency loadDependency(IDependency dependency) throws OpenLCompilationException {
        String dependencyName = dependency.getNode().getIdentifier();
        if (this.compiledDependencies.containsKey(dependencyName)) {
            return this.compiledDependencies.get(dependencyName);
        }
        CompiledDependency compiledDependency = this.handleLoadDependency(dependency);
        if (compiledDependency == null) {
            throw new OpenLCompilationException(String.format("Dependency with name '%s' wasn't found", dependencyName), null, dependency.getNode().getSourceLocation());
        }
        this.compiledDependencies.put(dependencyName, compiledDependency);
        return compiledDependency;
    }

    @Override
    public void reset(IDependency dependency) {
        String dependencyName = dependency.getNode().getIdentifier();
        if (this.compiledDependencies.containsKey(dependencyName)) {
            this.compiledDependencies.remove(dependencyName);
        }
    }

    @Override
    public void resetAll() {
        this.compiledDependencies.clear();
    }

    public void setExecutionMode(boolean executionMode) {
        this.executionMode = executionMode;
    }

    @Override
    public boolean isExecutionMode() {
        return this.executionMode;
    }

    public abstract List<IDependencyLoader> getDependencyLoaders();

    protected CompiledDependency handleLoadDependency(IDependency dependency) throws OpenLCompilationException {
        List<IDependencyLoader> dependencyLoaders = this.getDependencyLoaders();
        return this.loadDependency(dependency.getNode().getIdentifier(), dependencyLoaders);
    }

    private CompiledDependency loadDependency(String dependencyName, List<IDependencyLoader> loaders) throws OpenLCompilationException {
        CompiledDependency result = null;
        for (IDependencyLoader loader : loaders) {
            CompiledDependency dependency = loader.load(dependencyName, this);
            if (dependency == null) continue;
            if (result != null) {
                throw new OpenLCompilationException(String.format("There are several modules with the same name '%s'", dependencyName));
            }
            result = dependency;
        }
        return result;
    }

    @Override
    public Map<String, Object> getExternalParameters() {
        return this.externalParameters;
    }

    public void setExternalParameters(Map<String, Object> parameters) {
        this.externalParameters = parameters;
    }
}

