/*
 * Decompiled with CFR 0.152.
 */
package org.openl.dependency.loader;

import java.net.MalformedURLException;
import java.net.URL;
import org.openl.CompiledOpenClass;
import org.openl.OpenL;
import org.openl.dependency.CompiledDependency;
import org.openl.dependency.IDependencyManager;
import org.openl.dependency.loader.IDependencyLoader;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.ASourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.util.PropertiesLocator;
import org.openl.util.RuntimeExceptionWrapper;

public abstract class FileDependencyLoader
implements IDependencyLoader {
    private String openlName;

    public FileDependencyLoader(String openlName) {
        this.openlName = openlName;
    }

    @Override
    public CompiledDependency load(String dependencyName, IDependencyManager dependencyManager) throws OpenLCompilationException {
        IOpenSourceCodeModule sourceCode = this.getSourceCodeModule(dependencyName);
        if (sourceCode != null) {
            sourceCode.setParams(dependencyManager.getExternalParameters());
            OpenL openl = OpenL.getInstance(this.openlName);
            CompiledOpenClass compiledOpenClass = OpenLManager.compileModuleWithErrors(openl, sourceCode, dependencyManager.isExecutionMode(), dependencyManager);
            return new CompiledDependency(dependencyName, compiledOpenClass);
        }
        return null;
    }

    protected IOpenSourceCodeModule getSourceCodeModule(String filename) {
        String fileOrURL = PropertiesLocator.locateFileOrURL(filename);
        ASourceCodeModule source = null;
        if (fileOrURL != null) {
            try {
                source = fileOrURL.indexOf(58) < 2 ? new FileSourceCodeModule(fileOrURL, null) : new URLSourceCodeModule(new URL(fileOrURL));
            }
            catch (MalformedURLException e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }
        return source;
    }
}

