/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import org.openl.IOpenBinder;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IBoundCode;
import org.openl.binding.IBoundMethodNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.MethodCastNode;
import org.openl.binding.impl.TypeCastException;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.engine.OpenLHolder;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.NullOpenClass;
import org.openl.types.java.JavaOpenClass;

public class OpenLBindManager
extends OpenLHolder {
    public OpenLBindManager(OpenL openl) {
        super(openl);
    }

    public IBoundCode bindCode(IBindingContextDelegator bindingContextDelegator, IParsedCode parsedCode) {
        IOpenBinder binder = this.getOpenL().getBinder();
        if (bindingContextDelegator == null) {
            return binder.bind(parsedCode);
        }
        return binder.bind(parsedCode, bindingContextDelegator);
    }

    public IBoundMethodNode bindMethod(IBoundCode boundCode, IOpenMethodHeader header, IBindingContext bindingContext) {
        IBoundMethodNode boundMethodNode = null;
        try {
            boundMethodNode = this.bindMethodType((IBoundMethodNode)boundCode.getTopNode(), bindingContext, header.getType());
        }
        catch (TypeCastException ex) {
            throw new CompositeSyntaxNodeException("", new SyntaxNodeException[]{ex});
        }
        return boundMethodNode;
    }

    private IBoundMethodNode bindMethodType(IBoundMethodNode boundMethodNode, IBindingContext bindingContext, IOpenClass type) throws TypeCastException {
        if (type == JavaOpenClass.VOID || type == NullOpenClass.the) {
            return boundMethodNode;
        }
        IOpenCast cast = ANodeBinder.getCast(boundMethodNode, type, bindingContext);
        if (cast == null) {
            return boundMethodNode;
        }
        return new MethodCastNode(boundMethodNode, cast, type);
    }
}

