/*
 * Decompiled with CFR 0.152.
 */
package org.openl.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Stack;
import org.openl.binding.IBoundNode;
import org.openl.exception.OpenLException;
import org.openl.exception.OpenLExceptionUtils;
import org.openl.main.SourceCodeURLTool;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.util.text.ILocation;

public class OpenLRuntimeException
extends RuntimeException
implements OpenLException {
    private static final long serialVersionUID = -8422089115244904493L;
    private IBoundNode node;
    private Stack<IBoundNode> openlCallStack = new Stack();

    public OpenLRuntimeException() {
    }

    public OpenLRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public OpenLRuntimeException(String message) {
        super(message);
    }

    public OpenLRuntimeException(Throwable cause) {
        super(cause);
    }

    public OpenLRuntimeException(Throwable cause, IBoundNode node) {
        super(cause);
        this.node = node;
    }

    public OpenLRuntimeException(String message, IBoundNode node) {
        super(message);
        this.node = node;
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        StringWriter messageWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(messageWriter);
        pw.println(super.getMessage());
        if (this.node != null) {
            SourceCodeURLTool.printCodeAndError(this.getLocation(), this.getSourceModule(), pw);
            SourceCodeURLTool.printSourceLocation(this, pw);
        }
        return messageWriter.toString();
    }

    @Override
    public ILocation getLocation() {
        ISyntaxNode syntaxNode;
        if (this.node != null && (syntaxNode = this.node.getSyntaxNode()) != null) {
            return syntaxNode.getSourceLocation();
        }
        return null;
    }

    @Override
    public IOpenSourceCodeModule getSourceModule() {
        ISyntaxNode syntaxNode;
        if (this.node != null && (syntaxNode = this.node.getSyntaxNode()) != null) {
            return syntaxNode.getModule();
        }
        return null;
    }

    public IBoundNode getNode() {
        return this.node;
    }

    public Stack<IBoundNode> getOpenlCallStack() {
        return this.openlCallStack;
    }

    public void pushMethodNode(IBoundNode node) {
        this.openlCallStack.push(node);
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            this.printStackTrace(new PrintWriter(printStream, true));
        }
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        OpenLExceptionUtils.printRuntimeError(this, writer);
    }
}

