/*
 * Decompiled with CFR 0.152.
 */
package org.openl.main;

import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.openl.OpenL;
import org.openl.binding.exception.MethodNotFoundException;
import org.openl.conf.IUserContext;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.UserContext;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLRuntimeException;
import org.openl.main.OpenLVersion;
import org.openl.main.SourceCodeURLConstants;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.impl.SourceLocator;
import org.openl.util.text.TextInfo;

public class OpenLMain
implements SourceCodeURLConstants {
    public static final String ORG_OPENL = "org.openl";
    public static final String ARG_SOURCE_FILE_NAME = "-file";
    public static final String ARG_OPENL_NAME = "-openl";
    public String openlName;
    public String sourceFileName;
    public String methodName;
    public String[] methodArgs = new String[0];
    public PrintStream err = System.err;
    public PrintStream out = System.out;
    IOpenSourceCodeModule openlSource;
    static Map<String, String> extensionsMap = new HashMap<String, String>();

    public static String getOpenlName(String filename) {
        String shortExt;
        int idx = (filename = filename.replace('\\', '/')).lastIndexOf(47);
        if (idx < 0) {
            idx = 0;
        }
        if ((idx = filename.indexOf(46, idx)) < 0) {
            throw new RuntimeException("File: " + filename + " does not have an extension");
        }
        String longExt = filename.substring(idx);
        String openlSuffix = extensionsMap.get(longExt);
        if (openlSuffix == null && (openlSuffix = extensionsMap.get(shortExt = filename.substring(idx = filename.lastIndexOf(46, idx)))) == null) {
            openlSuffix = longExt;
        }
        return ORG_OPENL + openlSuffix;
    }

    public static Map<String, String> getExtensionsMap() {
        return extensionsMap;
    }

    public static synchronized void registerExtension(String ext, String mapped) {
        extensionsMap.put(ext, mapped);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("OpenL main(),  Version " + OpenLVersion.getVersion() + " " + OpenLVersion.getURL() + " (c) " + OpenLVersion.getCopyrightYear());
        new OpenLMain(null).run(args);
    }

    public OpenLMain(String openlName) {
        this.openlName = openlName;
    }

    SourceLocator getOpenlSourceLocator(IOpenSourceCodeModule src) {
        return new SourceLocator(new TextInfo(src.getCode()));
    }

    IUserContext getUserContext() throws Exception {
        String userHome = new File(".").getCanonicalPath();
        URLClassLoader cl = new URLClassLoader(new URL[0]);
        return new UserContext(cl, userHome);
    }

    boolean hasChars(String s, String chars) {
        for (int i = 0; i < chars.length(); ++i) {
            if (s.indexOf(chars.charAt(i)) <= 0) continue;
            return true;
        }
        return false;
    }

    public String makeArgs() {
        String s = "";
        s = s + " -file " + this.quote(this.sourceFileName);
        if (this.openlName != null) {
            s = s + " -openl " + this.openlName;
        }
        if (this.methodName != null) {
            s = s + " " + this.methodName + " " + this.methodArgsToString();
        }
        return s;
    }

    String methodArgsToString() {
        int size = this.methodArgs != null ? this.methodArgs.length : 0;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            result.append(this.quote(this.methodArgs[i])).append(' ');
        }
        return result.toString();
    }

    boolean parseArgs(String[] args) {
        int i;
        for (i = 0; i < args.length && args[i].startsWith("-"); i += 2) {
            if (i + 1 >= args.length) {
                System.out.println(this.usage());
                throw new IllegalArgumentException(args[i]);
            }
            if (ARG_OPENL_NAME.equals(args[i])) {
                this.openlName = args[i + 1];
                continue;
            }
            if (ARG_SOURCE_FILE_NAME.equals(args[i])) {
                this.sourceFileName = args[i + 1];
                continue;
            }
            System.out.println(this.usage());
            return false;
        }
        if (this.sourceFileName == null) {
            this.out.println(this.usage());
            return false;
        }
        if (i < args.length) {
            this.methodName = args[i++];
            if (i < args.length) {
                int argsCount = args.length - i;
                this.methodArgs = new String[argsCount];
                System.arraycopy(args, i, this.methodArgs, 0, argsCount);
            }
        }
        return true;
    }

    String quote(String s) {
        if (s.indexOf(34) >= 0) {
            StringBuilder result = new StringBuilder(s.length() * 2);
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) == '\"') {
                    result.append('\\');
                }
                result.append(s.charAt(i));
            }
            return '\"' + result.toString() + '\"';
        }
        String delimiters = " ,'\t";
        if (this.hasChars(s, delimiters)) {
            return '\"' + s + '\"';
        }
        return s;
    }

    void run(String[] args) {
        if (!this.parseArgs(args)) {
            return;
        }
        this.openlSource = new FileSourceCodeModule(new File(this.sourceFileName), null);
        this.safeRunOpenl(this.openlName != null ? this.openlName : OpenLMain.getOpenlName(this.sourceFileName), this.openlSource, this.methodName, new Object[]{this.methodArgs});
    }

    public Object safeRunOpenl(String openlName, IOpenSourceCodeModule source, String method, Object[] params) {
        try {
            this.openlSource = source;
            this.methodName = method;
            OpenL openl = OpenL.getInstance(openlName);
            if (this.methodName != null) {
                return OpenLManager.runMethod(openl, this.openlSource, this.methodName, null, params);
            }
            return OpenLManager.runScript(openl, this.openlSource);
        }
        catch (OpenConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (OpenLRuntimeException rt) {
            rt.printStackTrace(this.err);
            return null;
        }
        catch (SyntaxNodeException exception) {
            this.err.println(exception.getMessage());
            return null;
        }
        catch (MethodNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    String usage() {
        String USAGE = "usage: java {0} -file <sourcefile> -openl [<openl>]  [<method> (arg)*] ";
        return MessageFormat.format(USAGE, this.getClass().getName());
    }
}

