/*
 * Decompiled with CFR 0.152.
 */
package org.openl.main;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;
import org.openl.util.IOUtils;
import org.openl.util.Log;

public class OpenLVersion {
    public static final String PROP_FILE_NAME = "openl.version.properties";
    public static final String PROP_VERSION_NAME = "openl.version";
    public static final String PROP_URL_NAME = "openl.url";
    public static final String PROP_YEAR_NAME = "openl.copyrightyear";
    private static Properties props = null;

    public static String getCopyrightYear() {
        return OpenLVersion.getProperties().getProperty(PROP_YEAR_NAME, "??");
    }

    static synchronized Properties getProperties() {
        if (props == null) {
            props = new Properties();
            InputStream propertiesFile = null;
            try {
                propertiesFile = OpenLVersion.class.getResourceAsStream(PROP_FILE_NAME);
                props.load(propertiesFile);
            }
            catch (Throwable t) {
                Log.warn((Object)"openl.version.properties not found", (Throwable)t);
            }
            finally {
                if (propertiesFile != null) {
                    IOUtils.closeQuietly((Closeable)propertiesFile);
                }
            }
        }
        return props;
    }

    public static String getURL() {
        return OpenLVersion.getProperties().getProperty(PROP_URL_NAME, "??");
    }

    public static String getVersion() {
        return OpenLVersion.getProperties().getProperty(PROP_VERSION_NAME, "???");
    }
}

