/*
 * Decompiled with CFR 0.152.
 */
package org.openl.main;

import java.util.ArrayList;
import java.util.List;
import org.openl.CompiledOpenClass;
import org.openl.OpenL;
import org.openl.types.IOpenClass;
import org.openl.types.impl.DynamicObject;
import org.openl.vm.IRuntimeEnv;

public abstract class OpenLWrapperController {
    public static final int DEBUG_MODE = 1;
    public static final int REGULAR_MODE = 0;
    public static final String AUTORELOAD_OFF = "org.openl.wrapper.autoreload.mode.off";
    public static final String AUTORELOAD_ON = "org.openl.wrapper.autoreload.mode.on";
    protected String autoReloadMode = "org.openl.wrapper.autoreload.mode.off";
    List<CompiledOpenClass[]> versions = new ArrayList<CompiledOpenClass[]>();
    protected OpenL openl;

    public CompiledOpenClass getCompiledOpenClass() {
        return this.getCompiledOpenClass(0);
    }

    public CompiledOpenClass getCompiledOpenClass(int mode) {
        return this.getCompiledOpenClass(mode, 0);
    }

    public synchronized CompiledOpenClass getCompiledOpenClass(int mode, int version) {
        CompiledOpenClass[] ch = this.getVersion(version);
        if (version == 0 && ch[mode] == null) {
            ch[mode] = this.loadCompiledOpenClass(mode);
        }
        return ch[mode];
    }

    public IRuntimeEnv getEnv() {
        return this.getOpenL().getVm().getRuntimeEnv();
    }

    public DynamicObject getInstance() {
        return this.getInstance(0);
    }

    public DynamicObject getInstance(int mode) {
        return (DynamicObject)this.getOpenClass(mode).newInstance(this.getEnv());
    }

    public IOpenClass getOpenClass() {
        return this.getOpenClass(0);
    }

    public IOpenClass getOpenClass(int mode) {
        CompiledOpenClass co = this.getCompiledOpenClass(mode);
        return co.getOpenClass();
    }

    public synchronized OpenL getOpenL() {
        if (this.openl == null) {
            this.openl = OpenL.getInstance(this.getOpenLName());
        }
        return this.openl;
    }

    public abstract String getOpenLName();

    public abstract String getSource();

    public abstract String getUserHomeSearchPath();

    private synchronized CompiledOpenClass[] getVersion(int version) {
        if (version < 0) {
            return this.versions.get(this.versions.size() - 1 + version);
        }
        if (this.versions.size() == 0) {
            this.versions.add(new CompiledOpenClass[2]);
        }
        return this.versions.get(this.versions.size() - 1);
    }

    private CompiledOpenClass loadCompiledOpenClass(int mode) {
        return null;
    }

    public void reload() {
        this.reload(true);
    }

    public abstract void reload(boolean var1);

    public void setAutoReload(String mode) {
        this.autoReloadMode = mode;
    }
}

