/*
 * Decompiled with CFR 0.152.
 */
package org.openl.message;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.lang3.StringUtils;
import org.openl.exception.OpenLException;
import org.openl.exception.OpenLExceptionUtils;
import org.openl.main.SourceCodeURLTool;
import org.openl.message.OpenLMessage;
import org.openl.message.Severity;

public class OpenLErrorMessage
extends OpenLMessage {
    private OpenLException error;

    public OpenLErrorMessage(String summary) {
        super(summary, Severity.ERROR);
    }

    public OpenLErrorMessage(OpenLException error) {
        super(OpenLExceptionUtils.getOpenLExceptionMessage(error), Severity.ERROR);
        if (error == null) {
            throw new NullPointerException();
        }
        this.error = error;
    }

    public OpenLException getError() {
        return this.error;
    }

    @Override
    public String toString() {
        String url;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(super.toString());
        if (this.getError() != null && !StringUtils.isEmpty((CharSequence)(url = SourceCodeURLTool.makeSourceLocationURL(this.getError().getLocation(), this.getError().getSourceModule())))) {
            printWriter.print("    at " + url);
        }
        printWriter.close();
        return stringWriter.toString();
    }

    @Override
    public String getSourceLocation() {
        return SourceCodeURLTool.makeSourceLocationURL(this.error.getLocation(), this.error.getSourceModule());
    }
}

