/*
 * Decompiled with CFR 0.152.
 */
package org.openl.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openl.exception.OpenLCompilationException;
import org.openl.exception.OpenLException;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessages;
import org.openl.message.OpenLWarnMessage;
import org.openl.message.Severity;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;

public class OpenLMessagesUtils {
    public static void addError(String message) {
        OpenLMessagesUtils.addMessage(message, Severity.ERROR);
    }

    public static void addError(OpenLCompilationException error) {
        OpenLErrorMessage message = new OpenLErrorMessage(error);
        OpenLMessagesUtils.addMessage(message);
    }

    public static void addError(Throwable exception) {
        Throwable cause;
        String errorMessage = exception.getMessage();
        if (StringUtils.isBlank((CharSequence)errorMessage) && (cause = exception.getCause()) != null) {
            errorMessage = cause.getMessage();
        }
        OpenLMessagesUtils.addError(errorMessage);
    }

    public static void addErrors(OpenLCompilationException[] errors) {
        if (errors != null) {
            for (OpenLCompilationException error : errors) {
                OpenLMessagesUtils.addError(error);
            }
        }
    }

    public static void addWarn(String message) {
        OpenLMessagesUtils.addMessage(message, Severity.WARN);
    }

    public static void addWarn(String message, ISyntaxNode source) {
        OpenLWarnMessage warn = new OpenLWarnMessage(message, source);
        OpenLMessagesUtils.addMessage(warn);
    }

    public static void addMessage(String message, Severity severity) {
        OpenLMessage openlMessage = new OpenLMessage(message, severity);
        OpenLMessagesUtils.addMessage(openlMessage);
    }

    public static void addMessage(OpenLMessage message) {
        OpenLMessages.getCurrentInstance().addMessage(message);
    }

    public static List<OpenLMessage> newMessages(OpenLException[] exceptions) {
        ArrayList<OpenLMessage> messages = new ArrayList<OpenLMessage>();
        if (ArrayUtils.isNotEmpty((Object[])exceptions)) {
            for (OpenLException error : exceptions) {
                OpenLErrorMessage errorMessage = new OpenLErrorMessage(error);
                messages.add(errorMessage);
            }
        }
        return messages;
    }

    public static List<OpenLMessage> newMessages(Throwable exception) {
        ArrayList<OpenLMessage> messages = new ArrayList<OpenLMessage>();
        if (exception instanceof CompositeSyntaxNodeException) {
            SyntaxNodeException[] exceptions;
            CompositeSyntaxNodeException compositeException = (CompositeSyntaxNodeException)exception;
            for (SyntaxNodeException openLException : exceptions = compositeException.getErrors()) {
                OpenLErrorMessage errorMessage = new OpenLErrorMessage(openLException);
                messages.add(errorMessage);
            }
        } else if (exception instanceof OpenLException) {
            OpenLException openLException = (OpenLException)((Object)exception);
            OpenLErrorMessage errorMessage = new OpenLErrorMessage(openLException);
            messages.add(errorMessage);
        } else {
            OpenLMessage message = new OpenLMessage(ExceptionUtils.getRootCauseMessage((Throwable)exception), Severity.ERROR);
            messages.add(message);
        }
        return messages;
    }

    public static Map<Severity, List<OpenLMessage>> groupMessagesBySeverity(List<OpenLMessage> messages) {
        HashMap<Severity, List<OpenLMessage>> groupedMessagesMap = new HashMap<Severity, List<OpenLMessage>>();
        for (OpenLMessage message : messages) {
            Severity severity = message.getSeverity();
            ArrayList<OpenLMessage> groupedMessages = (ArrayList<OpenLMessage>)groupedMessagesMap.get((Object)severity);
            if (groupedMessages == null) {
                groupedMessages = new ArrayList<OpenLMessage>();
                groupedMessagesMap.put(severity, groupedMessages);
            }
            groupedMessages.add(message);
        }
        return groupedMessagesMap;
    }

    public static List<OpenLMessage> filterMessagesBySeverity(List<OpenLMessage> messages, Severity severity) {
        Map<Severity, List<OpenLMessage>> groupedMessagesMap = OpenLMessagesUtils.groupMessagesBySeverity(messages);
        List<OpenLMessage> groupedMessages = groupedMessagesMap.get((Object)severity);
        if (groupedMessages != null) {
            return groupedMessages;
        }
        return Collections.emptyList();
    }
}

