/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.math.BigInteger;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.impl.Operators;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.explanation.ExplanationNumberValue;
import org.openl.meta.number.CastOperand;
import org.openl.meta.number.Formulas;
import org.openl.meta.number.LogicalExpressions;
import org.openl.meta.number.NumberOperations;
import org.openl.util.ArrayTool;
import org.openl.util.math.MathUtils;

@XmlRootElement
@XmlJavaTypeAdapter(value=BigIntegerValueAdapter.class)
public class BigIntegerValue
extends ExplanationNumberValue<BigIntegerValue> {
    private static final long serialVersionUID = -3936317402079096501L;
    private static final BigIntegerValue ZERO = new BigIntegerValue("0");
    private static final BigIntegerValue ONE = new BigIntegerValue("1");
    private static final BigIntegerValue MINUS_ONE = new BigIntegerValue("-1");
    private final BigInteger value;

    public static boolean eq(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null || value2 == null) {
            return value1 == value2;
        }
        return Operators.eq(value1.getValue(), value2.getValue());
    }

    public static boolean ge(BigIntegerValue value1, BigIntegerValue value2) {
        BigIntegerValue.validate(value1, value2, LogicalExpressions.GE.toString());
        return Operators.ge(value1.getValue(), value2.getValue());
    }

    public static boolean gt(BigIntegerValue value1, BigIntegerValue value2) {
        BigIntegerValue.validate(value1, value2, LogicalExpressions.GT.toString());
        return Operators.gt(value1.getValue(), value2.getValue());
    }

    public static boolean le(BigIntegerValue value1, BigIntegerValue value2) {
        BigIntegerValue.validate(value1, value2, LogicalExpressions.LE.toString());
        return Operators.le(value1.getValue(), value2.getValue());
    }

    public static boolean lt(BigIntegerValue value1, BigIntegerValue value2) {
        BigIntegerValue.validate(value1, value2, LogicalExpressions.LT.toString());
        return Operators.lt(value1.getValue(), value2.getValue());
    }

    public static boolean ne(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null || value2 == null) {
            return value1 != value2;
        }
        return Operators.ne(value1.getValue(), value2.getValue());
    }

    public static BigIntegerValue avg(BigIntegerValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigInteger[] primitiveArray = BigIntegerValue.unwrap(values);
        BigInteger avg = MathUtils.avg((BigInteger[])primitiveArray);
        return new BigIntegerValue(new BigIntegerValue(avg), NumberOperations.AVG, values);
    }

    public static BigIntegerValue sum(BigIntegerValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigInteger[] primitiveArray = BigIntegerValue.unwrap(values);
        BigInteger sum = MathUtils.sum((BigInteger[])primitiveArray);
        return new BigIntegerValue(new BigIntegerValue(sum), NumberOperations.SUM, values);
    }

    public static BigIntegerValue median(BigIntegerValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigInteger[] primitiveArray = BigIntegerValue.unwrap(values);
        BigInteger median = MathUtils.median((BigInteger[])primitiveArray);
        return new BigIntegerValue(new BigIntegerValue(median), NumberOperations.MEDIAN, values);
    }

    public static BigIntegerValue max(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new BigIntegerValue(MathUtils.max((BigInteger)value1.getValue(), (BigInteger)value2.getValue()) ? value1 : value2, NumberOperations.MAX, new BigIntegerValue[]{value1, value2});
    }

    public static BigIntegerValue min(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new BigIntegerValue(MathUtils.min((BigInteger)value1.getValue(), (BigInteger)value2.getValue()) ? value1 : value2, NumberOperations.MIN, new BigIntegerValue[]{value1, value2});
    }

    public static BigIntegerValue max(BigIntegerValue[] values) {
        BigIntegerValue result = (BigIntegerValue)MathUtils.max((Object[])values);
        return new BigIntegerValue((BigIntegerValue)BigIntegerValue.getAppropriateValue(values, result), NumberOperations.MAX_IN_ARRAY, values);
    }

    public static BigIntegerValue min(BigIntegerValue[] values) {
        BigIntegerValue result = (BigIntegerValue)MathUtils.min((Object[])values);
        return new BigIntegerValue((BigIntegerValue)BigIntegerValue.getAppropriateValue(values, result), NumberOperations.MIN_IN_ARRAY, values);
    }

    public static BigIntegerValue copy(BigIntegerValue value, String name) {
        if (value.getName() == null) {
            value.setName(name);
            return value;
        }
        if (!value.getName().equals(name)) {
            BigIntegerValue result = new BigIntegerValue(value, NumberOperations.COPY, new BigIntegerValue[]{value});
            result.setName(name);
            return result;
        }
        return value;
    }

    public static BigIntegerValue rem(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null || value2 == null) {
            return ZERO;
        }
        return new BigIntegerValue(value1, value2, Operators.rem(value1.getValue(), value2.getValue()), Formulas.REM);
    }

    public static BigIntegerValue add(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new BigIntegerValue(value1, value2, Operators.add(value1.getValue(), value2.getValue()), Formulas.ADD);
    }

    public static BigIntegerValue multiply(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new BigIntegerValue(value1, value2, Operators.multiply(value1.getValue(), value2.getValue()), Formulas.MULTIPLY);
    }

    public static BigIntegerValue subtract(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null) {
            return BigIntegerValue.negative(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return new BigIntegerValue(value1, value2, Operators.subtract(value1.getValue(), value2.getValue()), Formulas.SUBTRACT);
    }

    public static BigIntegerValue divide(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null && value2 != null && value2.doubleValue() != 0.0) {
            return new BigIntegerValue(value1, value2, BigIntegerValue.divide(ONE, value2).getValue(), Formulas.DIVIDE);
        }
        if (value2 == null) {
            return new BigIntegerValue(value1, value2, value1.getValue(), Formulas.DIVIDE);
        }
        if (value2.doubleValue() == 0.0) {
            throw new OpenlNotCheckedException("Division by zero");
        }
        return new BigIntegerValue(value1, value2, Operators.divide(value1.getValue(), value2.getValue()), Formulas.DIVIDE);
    }

    public static LongValue quotient(BigIntegerValue number, BigIntegerValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.quotient((BigInteger)number.getValue(), (BigInteger)divisor.getValue()));
            return new LongValue(result, NumberOperations.QUOTIENT, null);
        }
        return null;
    }

    public static BigIntegerValue product(BigIntegerValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigInteger[] primitiveArray = BigIntegerValue.unwrap(values);
        BigInteger product = MathUtils.product((BigInteger[])primitiveArray);
        return new BigIntegerValue(new BigIntegerValue(product), NumberOperations.PRODUCT, null);
    }

    public static BigIntegerValue mod(BigIntegerValue number, BigIntegerValue divisor) {
        if (number != null && divisor != null) {
            BigIntegerValue result = new BigIntegerValue(MathUtils.mod((BigInteger)number.getValue(), (BigInteger)divisor.getValue()));
            return new BigIntegerValue(result, NumberOperations.MOD, new BigIntegerValue[]{number, divisor});
        }
        return null;
    }

    public static BigIntegerValue small(BigIntegerValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigInteger[] primitiveArray = BigIntegerValue.unwrap(values);
        BigInteger small = MathUtils.small((BigInteger[])primitiveArray, (int)position);
        return new BigIntegerValue((BigIntegerValue)BigIntegerValue.getAppropriateValue(values, new BigIntegerValue(small)), NumberOperations.SMALL, values);
    }

    public static BigIntegerValue big(BigIntegerValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        BigInteger[] primitiveArray = BigIntegerValue.unwrap(values);
        BigInteger big = MathUtils.big((BigInteger[])primitiveArray, (int)position);
        return new BigIntegerValue((BigIntegerValue)BigIntegerValue.getAppropriateValue(values, new BigIntegerValue(big)), NumberOperations.BIG, values);
    }

    public static BigIntegerValue pow(BigIntegerValue value1, BigIntegerValue value2) {
        if (value1 == null) {
            return value2 == null ? null : new BigIntegerValue("0");
        }
        if (value2 == null) {
            return value1;
        }
        return new BigIntegerValue(new BigIntegerValue(Operators.pow(value1.getValue(), value2.getValue())), NumberOperations.POW, new BigIntegerValue[]{value1, value2});
    }

    public static BigIntegerValue abs(BigIntegerValue value) {
        if (value == null) {
            return null;
        }
        BigIntegerValue result = new BigIntegerValue(Operators.abs(value.getValue()));
        return new BigIntegerValue(result, NumberOperations.ABS, new BigIntegerValue[]{value});
    }

    public static BigIntegerValue negative(BigIntegerValue value) {
        if (value == null) {
            return null;
        }
        return BigIntegerValue.multiply(value, MINUS_ONE);
    }

    public static BigIntegerValue inc(BigIntegerValue value) {
        return BigIntegerValue.add(value, ONE);
    }

    public static BigIntegerValue positive(BigIntegerValue value) {
        return value;
    }

    public static BigIntegerValue dec(BigIntegerValue value) {
        return BigIntegerValue.subtract(value, ONE);
    }

    public static BigIntegerValue autocast(byte x, BigIntegerValue y) {
        return new BigIntegerValue(String.valueOf(x));
    }

    public static BigIntegerValue autocast(short x, BigIntegerValue y) {
        return new BigIntegerValue(String.valueOf(x));
    }

    public static BigIntegerValue autocast(int x, BigIntegerValue y) {
        return new BigIntegerValue(String.valueOf(x));
    }

    public static BigIntegerValue autocast(long x, BigIntegerValue y) {
        return new BigIntegerValue(String.valueOf(x));
    }

    public BigIntegerValue(BigInteger value) {
        this.value = value;
    }

    public BigIntegerValue(BigIntegerValue lv1, BigIntegerValue lv2, BigInteger value, Formulas operand) {
        super(lv1, lv2, operand);
        this.value = value;
    }

    public BigIntegerValue(String valueString, ExplanationNumberValue<?> beforeCastValue, boolean autocast) {
        super(beforeCastValue, new CastOperand("BigIntegerValue", autocast));
        this.value = new BigInteger(valueString);
    }

    @Override
    public BigIntegerValue copy(String name) {
        return BigIntegerValue.copy(this, name);
    }

    @Override
    public String printValue() {
        return String.valueOf(this.value);
    }

    public BigInteger getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BigIntegerValue) {
            BigIntegerValue secondObj = (BigIntegerValue)obj;
            return Operators.eq(this.getValue(), secondObj.getValue());
        }
        return false;
    }

    public static BigIntegerValue[] sort(BigIntegerValue[] values) {
        BigIntegerValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new BigIntegerValue[values.length];
            Object[] notNullArray = (BigIntegerValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            for (int i = 0; i < notNullArray.length; ++i) {
                sortedArray[i] = notNullArray[i];
            }
        }
        return sortedArray;
    }

    public static BigIntegerValue autocast(BigInteger x, BigIntegerValue y) {
        if (x == null) {
            return null;
        }
        return new BigIntegerValue(x);
    }

    public static BigIntegerValue autocast(BigIntegerValue x, BigDecimalValue y) {
        if (x == null) {
            return null;
        }
        return new BigIntegerValue(String.valueOf(x.getValue()), x, true);
    }

    public static String autocast(BigIntegerValue x, String y) {
        if (x == null) {
            return null;
        }
        return x.toString();
    }

    public static Integer distance(BigIntegerValue x, String y) {
        return 11;
    }

    public static BigIntegerValue autocast(String x, BigIntegerValue y) {
        if (x == null) {
            return null;
        }
        return new BigIntegerValue(new BigInteger(x));
    }

    public static Integer distance(String x, BigIntegerValue y) {
        return 10;
    }

    public static byte cast(BigIntegerValue x, byte y) {
        return x.byteValue();
    }

    public static short cast(BigIntegerValue x, short y) {
        return x.shortValue();
    }

    public static char cast(BigIntegerValue x, char y) {
        return (char)x.intValue();
    }

    public static int cast(BigIntegerValue x, int y) {
        return x.intValue();
    }

    public static long cast(BigIntegerValue x, long y) {
        return x.longValue();
    }

    public static float cast(BigIntegerValue x, float y) {
        return x.floatValue();
    }

    public static double cast(BigIntegerValue x, double y) {
        return x.doubleValue();
    }

    public static BigInteger cast(BigIntegerValue x, BigInteger y) {
        if (x == null) {
            return null;
        }
        return x.getValue();
    }

    public static ByteValue cast(BigIntegerValue x, ByteValue y) {
        if (x == null) {
            return null;
        }
        return new ByteValue(x.byteValue(), x, false);
    }

    public static ShortValue cast(BigIntegerValue x, ShortValue y) {
        if (x == null) {
            return null;
        }
        return new ShortValue(x.shortValue(), x, false);
    }

    public static IntValue cast(BigIntegerValue x, IntValue y) {
        if (x == null) {
            return null;
        }
        return new IntValue(x.intValue(), x, false);
    }

    public static LongValue cast(BigIntegerValue x, LongValue y) {
        if (x == null) {
            return null;
        }
        return new LongValue(x.longValue(), x, false);
    }

    public static FloatValue cast(BigIntegerValue x, FloatValue y) {
        if (x == null) {
            return null;
        }
        return new FloatValue(x.floatValue(), x, false);
    }

    public static DoubleValue cast(BigIntegerValue x, DoubleValue y) {
        if (x == null) {
            return null;
        }
        return new DoubleValue(x.doubleValue(), x, false);
    }

    public BigIntegerValue(String valueString) {
        this.value = new BigInteger(valueString);
    }

    public BigIntegerValue(BigIntegerValue result, NumberOperations function, BigIntegerValue[] params) {
        super(function, (ExplanationNumberValue[])params);
        this.value = result.getValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public int compareTo(Number o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof BigIntegerValue) {
            return this.value.compareTo(((BigIntegerValue)o).getValue());
        }
        throw new OpenlNotCheckedException("Can`t compare BigIntegerValue with unknown type.");
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    private static BigInteger[] unwrap(BigIntegerValue[] values) {
        values = (BigIntegerValue[])ArrayTool.removeNulls((Object[])values);
        BigInteger[] unwrapArray = new BigInteger[values.length];
        for (int i = 0; i < values.length; ++i) {
            unwrapArray[i] = values[i].value;
        }
        return unwrapArray;
    }

    public static class BigIntegerValueAdapter
    extends XmlAdapter<BigInteger, BigIntegerValue> {
        public BigIntegerValue unmarshal(BigInteger val) throws Exception {
            return new BigIntegerValue(val);
        }

        public BigInteger marshal(BigIntegerValue val) throws Exception {
            return val.getValue();
        }
    }
}

