/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.impl.Operators;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.explanation.ExplanationNumberValue;
import org.openl.meta.number.CastOperand;
import org.openl.meta.number.Formulas;
import org.openl.meta.number.LogicalExpressions;
import org.openl.meta.number.NumberOperations;
import org.openl.util.ArrayTool;
import org.openl.util.math.MathUtils;

@XmlRootElement
@XmlJavaTypeAdapter(value=ByteValueAdapter.class)
public class ByteValue
extends ExplanationNumberValue<ByteValue> {
    private static final long serialVersionUID = -3137978912171407672L;
    private static final ByteValue ZERO = new ByteValue(0);
    private static final ByteValue ONE = new ByteValue(1);
    private static final ByteValue MINUS_ONE = new ByteValue(-1);
    private final byte value;

    public static boolean eq(ByteValue value1, ByteValue value2) {
        if (value1 == null || value2 == null) {
            return value1 == value2;
        }
        return Operators.eq(value1.getValue(), value2.getValue());
    }

    public static boolean ge(ByteValue value1, ByteValue value2) {
        ByteValue.validate(value1, value2, LogicalExpressions.GE.toString());
        return Operators.ge(value1.getValue(), value2.getValue());
    }

    public static boolean gt(ByteValue value1, ByteValue value2) {
        ByteValue.validate(value1, value2, LogicalExpressions.GT.toString());
        return Operators.gt(value1.getValue(), value2.getValue());
    }

    public static boolean le(ByteValue value1, ByteValue value2) {
        ByteValue.validate(value1, value2, LogicalExpressions.LE.toString());
        return Operators.le(value1.getValue(), value2.getValue());
    }

    public static boolean lt(ByteValue value1, ByteValue value2) {
        ByteValue.validate(value1, value2, LogicalExpressions.LT.toString());
        return Operators.lt(value1.getValue(), value2.getValue());
    }

    public static boolean ne(ByteValue value1, ByteValue value2) {
        if (value1 == null || value2 == null) {
            return value1 != value2;
        }
        return Operators.ne(value1.getValue(), value2.getValue());
    }

    public static ByteValue avg(ByteValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        byte[] primitiveArray = ByteValue.unwrap(values);
        byte avg = MathUtils.avg((byte[])primitiveArray);
        return new ByteValue(new ByteValue(avg), NumberOperations.AVG, values);
    }

    public static ByteValue sum(ByteValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        byte[] primitiveArray = ByteValue.unwrap(values);
        byte sum = MathUtils.sum((byte[])primitiveArray);
        return new ByteValue(new ByteValue(sum), NumberOperations.SUM, values);
    }

    public static ByteValue median(ByteValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        byte[] primitiveArray = ByteValue.unwrap(values);
        byte median = MathUtils.median((byte[])primitiveArray);
        return new ByteValue(new ByteValue(median), NumberOperations.MEDIAN, values);
    }

    public static ByteValue max(ByteValue value1, ByteValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new ByteValue(MathUtils.max((byte)value1.getValue(), (byte)value2.getValue()) ? value1 : value2, NumberOperations.MAX, new ByteValue[]{value1, value2});
    }

    public static ByteValue min(ByteValue value1, ByteValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new ByteValue(MathUtils.min((byte)value1.getValue(), (byte)value2.getValue()) ? value1 : value2, NumberOperations.MIN, new ByteValue[]{value1, value2});
    }

    public static ByteValue max(ByteValue[] values) {
        ByteValue result = (ByteValue)MathUtils.max((Object[])values);
        return new ByteValue((ByteValue)ByteValue.getAppropriateValue(values, result), NumberOperations.MAX_IN_ARRAY, values);
    }

    public static ByteValue min(ByteValue[] values) {
        ByteValue result = (ByteValue)MathUtils.min((Object[])values);
        return new ByteValue((ByteValue)ByteValue.getAppropriateValue(values, result), NumberOperations.MIN_IN_ARRAY, values);
    }

    public static ByteValue copy(ByteValue value, String name) {
        if (value.getName() == null) {
            value.setName(name);
            return value;
        }
        if (!value.getName().equals(name)) {
            ByteValue result = new ByteValue(value, NumberOperations.COPY, new ByteValue[]{value});
            result.setName(name);
            return result;
        }
        return value;
    }

    public static ByteValue rem(ByteValue value1, ByteValue value2) {
        if (value1 == null || value2 == null) {
            return ZERO;
        }
        return new ByteValue(value1, value2, Operators.rem(value1.getValue(), value2.getValue()), Formulas.REM);
    }

    public static ByteValue add(ByteValue value1, ByteValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new ByteValue(value1, value2, Operators.add(value1.getValue(), value2.getValue()), Formulas.ADD);
    }

    public static ByteValue multiply(ByteValue value1, ByteValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new ByteValue(value1, value2, Operators.multiply(value1.getValue(), value2.getValue()), Formulas.MULTIPLY);
    }

    public static ByteValue subtract(ByteValue value1, ByteValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null) {
            return ByteValue.negative(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return new ByteValue(value1, value2, Operators.subtract(value1.getValue(), value2.getValue()), Formulas.SUBTRACT);
    }

    public static ByteValue divide(ByteValue value1, ByteValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null && value2 != null && value2.doubleValue() != 0.0) {
            return new ByteValue(value1, value2, ByteValue.divide(ONE, value2).getValue(), Formulas.DIVIDE);
        }
        if (value2 == null) {
            return new ByteValue(value1, value2, value1.getValue(), Formulas.DIVIDE);
        }
        if (value2.doubleValue() == 0.0) {
            throw new OpenlNotCheckedException("Division by zero");
        }
        return new ByteValue(value1, value2, Operators.divide(value1.getValue(), value2.getValue()), Formulas.DIVIDE);
    }

    public static LongValue quotient(ByteValue number, ByteValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.quotient((byte)number.getValue(), (byte)divisor.getValue()));
            return new LongValue(result, NumberOperations.QUOTIENT, null);
        }
        return null;
    }

    public static DoubleValue product(ByteValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        byte[] primitiveArray = ByteValue.unwrap(values);
        double product = MathUtils.product((byte[])primitiveArray);
        return new DoubleValue(new DoubleValue(product), NumberOperations.PRODUCT, null);
    }

    public static ByteValue mod(ByteValue number, ByteValue divisor) {
        if (number != null && divisor != null) {
            ByteValue result = new ByteValue(MathUtils.mod((byte)number.getValue(), (byte)divisor.getValue()));
            return new ByteValue(result, NumberOperations.MOD, new ByteValue[]{number, divisor});
        }
        return null;
    }

    public static ByteValue small(ByteValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        byte[] primitiveArray = ByteValue.unwrap(values);
        byte small = MathUtils.small((byte[])primitiveArray, (int)position);
        return new ByteValue((ByteValue)ByteValue.getAppropriateValue(values, new ByteValue(small)), NumberOperations.SMALL, values);
    }

    public static ByteValue big(ByteValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        byte[] primitiveArray = ByteValue.unwrap(values);
        byte big = MathUtils.big((byte[])primitiveArray, (int)position);
        return new ByteValue((ByteValue)ByteValue.getAppropriateValue(values, new ByteValue(big)), NumberOperations.BIG, values);
    }

    public static ByteValue pow(ByteValue value1, ByteValue value2) {
        if (value1 == null) {
            return value2 == null ? null : new ByteValue(0);
        }
        if (value2 == null) {
            return value1;
        }
        return new ByteValue(new ByteValue(Operators.pow(value1.getValue(), value2.getValue())), NumberOperations.POW, new ByteValue[]{value1, value2});
    }

    public static ByteValue abs(ByteValue value) {
        if (value == null) {
            return null;
        }
        ByteValue result = new ByteValue(Operators.abs(value.getValue()));
        return new ByteValue(result, NumberOperations.ABS, new ByteValue[]{value});
    }

    public static ByteValue negative(ByteValue value) {
        if (value == null) {
            return null;
        }
        return ByteValue.multiply(value, MINUS_ONE);
    }

    public static ByteValue inc(ByteValue value) {
        return ByteValue.add(value, ONE);
    }

    public static ByteValue positive(ByteValue value) {
        return value;
    }

    public static ByteValue dec(ByteValue value) {
        return ByteValue.subtract(value, ONE);
    }

    public static ByteValue autocast(byte x, ByteValue y) {
        return new ByteValue(x);
    }

    public ByteValue(byte value) {
        this.value = value;
    }

    public ByteValue(ByteValue lv1, ByteValue lv2, byte value, Formulas operand) {
        super(lv1, lv2, operand);
        this.value = value;
    }

    public ByteValue(byte value, ExplanationNumberValue<?> beforeCastValue, boolean autocast) {
        super(beforeCastValue, new CastOperand("ByteValue", autocast));
        this.value = value;
    }

    @Override
    public ByteValue copy(String name) {
        return ByteValue.copy(this, name);
    }

    @Override
    public String printValue() {
        return String.valueOf(this.value);
    }

    public byte getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteValue) {
            ByteValue secondObj = (ByteValue)obj;
            return Operators.eq(this.getValue(), secondObj.getValue());
        }
        return false;
    }

    public static ByteValue[] sort(ByteValue[] values) {
        ByteValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new ByteValue[values.length];
            Object[] notNullArray = (ByteValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            for (int i = 0; i < notNullArray.length; ++i) {
                sortedArray[i] = notNullArray[i];
            }
        }
        return sortedArray;
    }

    public static ByteValue autocast(Byte x, ByteValue y) {
        if (x == null) {
            return null;
        }
        return new ByteValue(x);
    }

    public static ShortValue autocast(ByteValue x, ShortValue y) {
        if (x == null) {
            return null;
        }
        return new ShortValue(x.getValue(), x, true);
    }

    public static IntValue autocast(ByteValue x, IntValue y) {
        if (x == null) {
            return null;
        }
        return new IntValue(x.getValue(), x, true);
    }

    public static LongValue autocast(ByteValue x, LongValue y) {
        if (x == null) {
            return null;
        }
        return new LongValue(x.getValue(), x, true);
    }

    public static FloatValue autocast(ByteValue x, FloatValue y) {
        if (x == null) {
            return null;
        }
        return new FloatValue(x.getValue(), x, true);
    }

    public static DoubleValue autocast(ByteValue x, DoubleValue y) {
        if (x == null) {
            return null;
        }
        return new DoubleValue(x.getValue(), x, true);
    }

    public static BigIntegerValue autocast(ByteValue x, BigIntegerValue y) {
        if (x == null) {
            return null;
        }
        return new BigIntegerValue(String.valueOf(x.getValue()), x, true);
    }

    public static BigDecimalValue autocast(ByteValue x, BigDecimalValue y) {
        if (x == null) {
            return null;
        }
        return new BigDecimalValue(String.valueOf(x.getValue()), x, true);
    }

    public static String autocast(ByteValue x, String y) {
        if (x == null) {
            return null;
        }
        return x.toString();
    }

    public static Integer distance(ByteValue x, String y) {
        return 11;
    }

    public static ByteValue autocast(String x, ByteValue y) {
        if (x == null) {
            return null;
        }
        return new ByteValue(Byte.valueOf(x));
    }

    public static Integer distance(String x, ByteValue y) {
        return 10;
    }

    public static byte cast(ByteValue x, byte y) {
        return x.byteValue();
    }

    public static short cast(ByteValue x, short y) {
        return x.shortValue();
    }

    public static char cast(ByteValue x, char y) {
        return (char)x.byteValue();
    }

    public static int cast(ByteValue x, int y) {
        return x.intValue();
    }

    public static long cast(ByteValue x, long y) {
        return x.longValue();
    }

    public static float cast(ByteValue x, float y) {
        return x.floatValue();
    }

    public static double cast(ByteValue x, double y) {
        return x.doubleValue();
    }

    public static Byte cast(ByteValue x, Byte y) {
        if (x == null) {
            return null;
        }
        return x.byteValue();
    }

    public ByteValue(String valueString) {
        this.value = Byte.parseByte(valueString);
    }

    public ByteValue(ByteValue result, NumberOperations function, ByteValue[] params) {
        super(function, (ExplanationNumberValue[])params);
        this.value = result.byteValue();
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int compareTo(Number o) {
        return this.value - o.byteValue();
    }

    public int hashCode() {
        return Byte.valueOf(this.value).hashCode();
    }

    private static byte[] unwrap(ByteValue[] values) {
        values = (ByteValue[])ArrayTool.removeNulls((Object[])values);
        byte[] primitiveArray = new byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            primitiveArray[i] = values[i].getValue();
        }
        return primitiveArray;
    }

    public static class ByteValueAdapter
    extends XmlAdapter<Byte, ByteValue> {
        public ByteValue unmarshal(Byte val) throws Exception {
            return new ByteValue(val);
        }

        public Byte marshal(ByteValue val) throws Exception {
            return val.getValue();
        }
    }
}

