/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.impl.Operators;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.ByteValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.explanation.ExplanationNumberValue;
import org.openl.meta.number.CastOperand;
import org.openl.meta.number.Formulas;
import org.openl.meta.number.LogicalExpressions;
import org.openl.meta.number.NumberOperations;
import org.openl.util.ArrayTool;
import org.openl.util.math.MathUtils;

@XmlRootElement
@XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
public class DoubleValue
extends ExplanationNumberValue<DoubleValue> {
    private static final long serialVersionUID = -4594250562069599646L;
    public static final DoubleValue ZERO = new DoubleValueZero();
    public static final DoubleValue ONE = new DoubleValueOne();
    public static final DoubleValue MINUS_ONE = new DoubleValue(-1.0);
    private double value;

    public void setValue(double value) {
        this.value = value;
    }

    public static boolean eq(DoubleValue value1, DoubleValue value2) {
        if (value1 == null || value2 == null) {
            return value1 == value2;
        }
        return Operators.eq(value1.getValue(), value2.getValue());
    }

    public static boolean ge(DoubleValue value1, DoubleValue value2) {
        DoubleValue.validate(value1, value2, LogicalExpressions.GE.toString());
        return Operators.ge(value1.getValue(), value2.getValue());
    }

    public static boolean gt(DoubleValue value1, DoubleValue value2) {
        DoubleValue.validate(value1, value2, LogicalExpressions.GT.toString());
        return Operators.gt(value1.getValue(), value2.getValue());
    }

    public static boolean le(DoubleValue value1, DoubleValue value2) {
        DoubleValue.validate(value1, value2, LogicalExpressions.LE.toString());
        return Operators.le(value1.getValue(), value2.getValue());
    }

    public static boolean lt(DoubleValue value1, DoubleValue value2) {
        DoubleValue.validate(value1, value2, LogicalExpressions.LT.toString());
        return Operators.lt(value1.getValue(), value2.getValue());
    }

    public static boolean ne(DoubleValue value1, DoubleValue value2) {
        if (value1 == null || value2 == null) {
            return value1 != value2;
        }
        return Operators.ne(value1.getValue(), value2.getValue());
    }

    public static DoubleValue avg(DoubleValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        double[] primitiveArray = DoubleValue.unwrap(values);
        double avg = MathUtils.avg((double[])primitiveArray);
        return new DoubleValue(new DoubleValue(avg), NumberOperations.AVG, values);
    }

    public static DoubleValue sum(DoubleValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        double[] primitiveArray = DoubleValue.unwrap(values);
        double sum = MathUtils.sum((double[])primitiveArray);
        return new DoubleValue(new DoubleValue(sum), NumberOperations.SUM, values);
    }

    public static DoubleValue median(DoubleValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        double[] primitiveArray = DoubleValue.unwrap(values);
        double median = MathUtils.median((double[])primitiveArray);
        return new DoubleValue(new DoubleValue(median), NumberOperations.MEDIAN, values);
    }

    public static DoubleValue max(DoubleValue value1, DoubleValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new DoubleValue(MathUtils.max((double)value1.getValue(), (double)value2.getValue()) ? value1 : value2, NumberOperations.MAX, new DoubleValue[]{value1, value2});
    }

    public static DoubleValue min(DoubleValue value1, DoubleValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new DoubleValue(MathUtils.min((double)value1.getValue(), (double)value2.getValue()) ? value1 : value2, NumberOperations.MIN, new DoubleValue[]{value1, value2});
    }

    public static DoubleValue max(DoubleValue[] values) {
        DoubleValue result = (DoubleValue)MathUtils.max((Object[])values);
        return new DoubleValue((DoubleValue)DoubleValue.getAppropriateValue(values, result), NumberOperations.MAX_IN_ARRAY, values);
    }

    public static DoubleValue min(DoubleValue[] values) {
        DoubleValue result = (DoubleValue)MathUtils.min((Object[])values);
        return new DoubleValue((DoubleValue)DoubleValue.getAppropriateValue(values, result), NumberOperations.MIN_IN_ARRAY, values);
    }

    public static DoubleValue copy(DoubleValue value, String name) {
        if (value.getName() == null) {
            value.setName(name);
            return value;
        }
        if (!value.getName().equals(name)) {
            DoubleValue result = new DoubleValue(value, NumberOperations.COPY, new DoubleValue[]{value});
            result.setName(name);
            return result;
        }
        return value;
    }

    public static DoubleValue rem(DoubleValue value1, DoubleValue value2) {
        if (value1 == null || value2 == null) {
            return ZERO;
        }
        return new DoubleValue(value1, value2, Operators.rem(value1.getValue(), value2.getValue()), Formulas.REM);
    }

    public static DoubleValue add(DoubleValue value1, DoubleValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new DoubleValue(value1, value2, Operators.add(value1.getValue(), value2.getValue()), Formulas.ADD);
    }

    public static DoubleValue multiply(DoubleValue value1, DoubleValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new DoubleValue(value1, value2, Operators.multiply(value1.getValue(), value2.getValue()), Formulas.MULTIPLY);
    }

    public static DoubleValue subtract(DoubleValue value1, DoubleValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null) {
            return DoubleValue.negative(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return new DoubleValue(value1, value2, Operators.subtract(value1.getValue(), value2.getValue()), Formulas.SUBTRACT);
    }

    public static DoubleValue divide(DoubleValue value1, DoubleValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null && value2 != null && value2.doubleValue() != 0.0) {
            return new DoubleValue(value1, value2, DoubleValue.divide(ONE, value2).getValue(), Formulas.DIVIDE);
        }
        if (value2 == null) {
            return new DoubleValue(value1, value2, value1.getValue(), Formulas.DIVIDE);
        }
        if (value2.doubleValue() == 0.0) {
            return new DoubleValue(value1, value2, Double.POSITIVE_INFINITY, Formulas.DIVIDE);
        }
        return new DoubleValue(value1, value2, Operators.divide(value1.getValue(), value2.getValue()), Formulas.DIVIDE);
    }

    public static LongValue quotient(DoubleValue number, DoubleValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.quotient((double)number.getValue(), (double)divisor.getValue()));
            return new LongValue(result, NumberOperations.QUOTIENT, null);
        }
        return null;
    }

    public static DoubleValue product(DoubleValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        double[] primitiveArray = DoubleValue.unwrap(values);
        double product = MathUtils.product((double[])primitiveArray);
        return new DoubleValue(new DoubleValue(product), NumberOperations.PRODUCT, null);
    }

    public static DoubleValue mod(DoubleValue number, DoubleValue divisor) {
        if (number != null && divisor != null) {
            DoubleValue result = new DoubleValue(MathUtils.mod((double)number.getValue(), (double)divisor.getValue()));
            return new DoubleValue(result, NumberOperations.MOD, new DoubleValue[]{number, divisor});
        }
        return null;
    }

    public static DoubleValue small(DoubleValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        double[] primitiveArray = DoubleValue.unwrap(values);
        double small = MathUtils.small((double[])primitiveArray, (int)position);
        return new DoubleValue((DoubleValue)DoubleValue.getAppropriateValue(values, new DoubleValue(small)), NumberOperations.SMALL, values);
    }

    public static DoubleValue big(DoubleValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        double[] primitiveArray = DoubleValue.unwrap(values);
        double big = MathUtils.big((double[])primitiveArray, (int)position);
        return new DoubleValue((DoubleValue)DoubleValue.getAppropriateValue(values, new DoubleValue(big)), NumberOperations.BIG, values);
    }

    public static DoubleValue pow(DoubleValue value1, DoubleValue value2) {
        if (value1 == null) {
            return value2 == null ? null : new DoubleValue(0.0);
        }
        if (value2 == null) {
            return value1;
        }
        return new DoubleValue(new DoubleValue(Operators.pow(value1.getValue(), value2.getValue())), NumberOperations.POW, new DoubleValue[]{value1, value2});
    }

    public static DoubleValue abs(DoubleValue value) {
        if (value == null) {
            return null;
        }
        DoubleValue result = new DoubleValue(Operators.abs(value.getValue()));
        return new DoubleValue(result, NumberOperations.ABS, new DoubleValue[]{value});
    }

    public static DoubleValue negative(DoubleValue value) {
        if (value == null) {
            return null;
        }
        return DoubleValue.multiply(value, MINUS_ONE);
    }

    public static DoubleValue inc(DoubleValue value) {
        return DoubleValue.add(value, ONE);
    }

    public static DoubleValue positive(DoubleValue value) {
        return value;
    }

    public static DoubleValue dec(DoubleValue value) {
        return DoubleValue.subtract(value, ONE);
    }

    public static DoubleValue autocast(byte x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(short x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(int x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(long x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(float x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(double x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public DoubleValue(double value) {
        this.value = value;
    }

    public DoubleValue(DoubleValue lv1, DoubleValue lv2, double value, Formulas operand) {
        super(lv1, lv2, operand);
        this.value = value;
    }

    public DoubleValue(double value, ExplanationNumberValue<?> beforeCastValue, boolean autocast) {
        super(beforeCastValue, new CastOperand("DoubleValue", autocast));
        this.value = value;
    }

    @Override
    public DoubleValue copy(String name) {
        return DoubleValue.copy(this, name);
    }

    @Override
    public String printValue() {
        return String.valueOf(this.value);
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleValue) {
            DoubleValue secondObj = (DoubleValue)obj;
            return Operators.eq(this.getValue(), secondObj.getValue());
        }
        if (obj instanceof String) {
            double d;
            try {
                d = Double.parseDouble((String)obj);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return Operators.eq(this.getValue(), d);
        }
        return false;
    }

    public static boolean isNumeric(String str) {
        try {
            double d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static DoubleValue[] sort(DoubleValue[] values) {
        DoubleValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new DoubleValue[values.length];
            Object[] notNullArray = (DoubleValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            for (int i = 0; i < notNullArray.length; ++i) {
                sortedArray[i] = notNullArray[i];
            }
        }
        return sortedArray;
    }

    public static DoubleValue autocast(Double x, DoubleValue y) {
        if (x == null) {
            return null;
        }
        return new DoubleValue(x);
    }

    public static BigDecimalValue autocast(DoubleValue x, BigDecimalValue y) {
        if (x == null) {
            return null;
        }
        return new BigDecimalValue(String.valueOf(x.getValue()), x, true);
    }

    public static String autocast(DoubleValue x, String y) {
        if (x == null) {
            return null;
        }
        return x.toString();
    }

    public static Integer distance(DoubleValue x, String y) {
        return 11;
    }

    public static DoubleValue autocast(String x, DoubleValue y) {
        if (x == null || "".equals(x)) {
            return null;
        }
        return new DoubleValue(Double.valueOf(x));
    }

    public static Integer distance(String x, DoubleValue y) {
        return 10;
    }

    public static byte cast(DoubleValue x, byte y) {
        return x.byteValue();
    }

    public static short cast(DoubleValue x, short y) {
        return x.shortValue();
    }

    public static char cast(DoubleValue x, char y) {
        return (char)x.doubleValue();
    }

    public static int cast(DoubleValue x, int y) {
        return x.intValue();
    }

    public static long cast(DoubleValue x, long y) {
        return x.longValue();
    }

    public static float cast(DoubleValue x, float y) {
        return x.floatValue();
    }

    public static double cast(DoubleValue x, double y) {
        return x.doubleValue();
    }

    public static Double cast(DoubleValue x, Double y) {
        if (x == null) {
            return null;
        }
        return x.doubleValue();
    }

    public static ByteValue cast(DoubleValue x, ByteValue y) {
        if (x == null) {
            return null;
        }
        return new ByteValue(x.byteValue(), x, false);
    }

    public static ShortValue cast(DoubleValue x, ShortValue y) {
        if (x == null) {
            return null;
        }
        return new ShortValue(x.shortValue(), x, false);
    }

    public static IntValue cast(DoubleValue x, IntValue y) {
        if (x == null) {
            return null;
        }
        return new IntValue(x.intValue(), x, false);
    }

    public static LongValue cast(DoubleValue x, LongValue y) {
        if (x == null) {
            return null;
        }
        return new LongValue(x.longValue(), x, false);
    }

    public static FloatValue cast(DoubleValue x, FloatValue y) {
        if (x == null) {
            return null;
        }
        return new FloatValue(x.floatValue(), x, false);
    }

    public static DoubleValue round(DoubleValue value) {
        if (value == null) {
            return null;
        }
        double ulp = Math.ulp(value.getValue());
        return new DoubleValue(new DoubleValue(Math.round(value.getValue() + ulp)), NumberOperations.ROUND, new DoubleValue[]{value});
    }

    public static DoubleValue round(DoubleValue value, int scale) {
        if (value == null) {
            return null;
        }
        double ulp = Math.ulp(value.getValue());
        DoubleValue returnValue = new DoubleValue(new DoubleValue(MathUtils.round((double)(value.doubleValue() + ulp), (int)scale, (int)4)), NumberOperations.ROUND, new DoubleValue[]{value, new DoubleValue(scale)});
        return returnValue;
    }

    public static DoubleValue round(DoubleValue value, int scale, int roundingMethod) {
        if (value == null) {
            return null;
        }
        return new DoubleValue(new DoubleValue(MathUtils.round((double)value.doubleValue(), (int)scale, (int)roundingMethod)), NumberOperations.ROUND, new DoubleValue[]{value, new DoubleValue(scale)});
    }

    @Deprecated
    public static DoubleValue round(DoubleValue d, DoubleValue p) {
        double preRoundedValue;
        int scale;
        DoubleValue.validate(d, p, NumberOperations.ROUND);
        if (p.doubleValue() == 0.0) {
            scale = 0;
            preRoundedValue = d.doubleValue();
        } else {
            scale = (int)MathUtils.round((double)(-Math.log10(p.doubleValue())), (int)0, (int)4);
            preRoundedValue = d.doubleValue();
        }
        double roundedValue = MathUtils.round((double)preRoundedValue, (int)scale, (int)4);
        return new DoubleValue(new DoubleValue(roundedValue), NumberOperations.ROUND, new DoubleValue[]{d, p});
    }

    public DoubleValue(String valueString) {
        this.value = Double.parseDouble(valueString);
    }

    public DoubleValue(DoubleValue result, NumberOperations function, DoubleValue[] params) {
        super(function, (ExplanationNumberValue[])params);
        this.value = result.doubleValue();
    }

    @Override
    public int compareTo(Number o) {
        return Double.compare(this.value, o.doubleValue());
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Deprecated
    public String getFormat() {
        return null;
    }

    @Deprecated
    public void setFormat(String format) {
    }

    public int hashCode() {
        return Double.valueOf(this.value).hashCode();
    }

    private static double[] unwrap(DoubleValue[] values) {
        values = (DoubleValue[])ArrayTool.removeNulls((Object[])values);
        double[] primitiveArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            primitiveArray[i] = values[i].getValue();
        }
        return primitiveArray;
    }

    public static class DoubleValueZero
    extends DoubleValue {
        private static final long serialVersionUID = 3329865368482848868L;

        private DoubleValueZero() {
            super(0.0);
        }

        public DoubleValue add(DoubleValue dv) {
            return dv;
        }

        public DoubleValue divide(DoubleValue dv) {
            return this;
        }

        public DoubleValue multiply(DoubleValue dv) {
            return this;
        }
    }

    public static class DoubleValueAdapter
    extends XmlAdapter<Double, DoubleValue> {
        public DoubleValue unmarshal(Double val) throws Exception {
            return new DoubleValue(val);
        }

        public Double marshal(DoubleValue val) throws Exception {
            return val.doubleValue();
        }
    }

    public static class DoubleValueOne
    extends DoubleValue {
        private static final long serialVersionUID = 6347462002516785250L;

        private DoubleValueOne() {
            super(1.0);
        }

        public DoubleValue multiply(DoubleValue dv) {
            return dv;
        }
    }
}

