/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.impl.Operators;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.explanation.ExplanationNumberValue;
import org.openl.meta.number.CastOperand;
import org.openl.meta.number.Formulas;
import org.openl.meta.number.LogicalExpressions;
import org.openl.meta.number.NumberOperations;
import org.openl.util.ArrayTool;
import org.openl.util.math.MathUtils;

@XmlRootElement
@XmlJavaTypeAdapter(value=FloatValueAdapter.class)
public class FloatValue
extends ExplanationNumberValue<FloatValue> {
    private static final long serialVersionUID = -8235832583740963916L;
    private static final FloatValue ZERO = new FloatValue(0.0f);
    private static final FloatValue ONE = new FloatValue(1.0f);
    private static final FloatValue MINUS_ONE = new FloatValue(-1.0f);
    private final float value;

    public static boolean eq(FloatValue value1, FloatValue value2) {
        if (value1 == null || value2 == null) {
            return value1 == value2;
        }
        return Operators.eq(value1.getValue(), value2.getValue());
    }

    public static boolean ge(FloatValue value1, FloatValue value2) {
        FloatValue.validate(value1, value2, LogicalExpressions.GE.toString());
        return Operators.ge(value1.getValue(), value2.getValue());
    }

    public static boolean gt(FloatValue value1, FloatValue value2) {
        FloatValue.validate(value1, value2, LogicalExpressions.GT.toString());
        return Operators.gt(value1.getValue(), value2.getValue());
    }

    public static boolean le(FloatValue value1, FloatValue value2) {
        FloatValue.validate(value1, value2, LogicalExpressions.LE.toString());
        return Operators.le(value1.getValue(), value2.getValue());
    }

    public static boolean lt(FloatValue value1, FloatValue value2) {
        FloatValue.validate(value1, value2, LogicalExpressions.LT.toString());
        return Operators.lt(value1.getValue(), value2.getValue());
    }

    public static boolean ne(FloatValue value1, FloatValue value2) {
        if (value1 == null || value2 == null) {
            return value1 != value2;
        }
        return Operators.ne(value1.getValue(), value2.getValue());
    }

    public static FloatValue avg(FloatValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        float[] primitiveArray = FloatValue.unwrap(values);
        float avg = MathUtils.avg((float[])primitiveArray);
        return new FloatValue(new FloatValue(avg), NumberOperations.AVG, values);
    }

    public static FloatValue sum(FloatValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        float[] primitiveArray = FloatValue.unwrap(values);
        float sum = MathUtils.sum((float[])primitiveArray);
        return new FloatValue(new FloatValue(sum), NumberOperations.SUM, values);
    }

    public static FloatValue median(FloatValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        float[] primitiveArray = FloatValue.unwrap(values);
        float median = MathUtils.median((float[])primitiveArray);
        return new FloatValue(new FloatValue(median), NumberOperations.MEDIAN, values);
    }

    public static FloatValue max(FloatValue value1, FloatValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new FloatValue(MathUtils.max((float)value1.getValue(), (float)value2.getValue()) ? value1 : value2, NumberOperations.MAX, new FloatValue[]{value1, value2});
    }

    public static FloatValue min(FloatValue value1, FloatValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new FloatValue(MathUtils.min((float)value1.getValue(), (float)value2.getValue()) ? value1 : value2, NumberOperations.MIN, new FloatValue[]{value1, value2});
    }

    public static FloatValue max(FloatValue[] values) {
        FloatValue result = (FloatValue)MathUtils.max((Object[])values);
        return new FloatValue((FloatValue)FloatValue.getAppropriateValue(values, result), NumberOperations.MAX_IN_ARRAY, values);
    }

    public static FloatValue min(FloatValue[] values) {
        FloatValue result = (FloatValue)MathUtils.min((Object[])values);
        return new FloatValue((FloatValue)FloatValue.getAppropriateValue(values, result), NumberOperations.MIN_IN_ARRAY, values);
    }

    public static FloatValue copy(FloatValue value, String name) {
        if (value.getName() == null) {
            value.setName(name);
            return value;
        }
        if (!value.getName().equals(name)) {
            FloatValue result = new FloatValue(value, NumberOperations.COPY, new FloatValue[]{value});
            result.setName(name);
            return result;
        }
        return value;
    }

    public static FloatValue rem(FloatValue value1, FloatValue value2) {
        if (value1 == null || value2 == null) {
            return ZERO;
        }
        return new FloatValue(value1, value2, Operators.rem(value1.getValue(), value2.getValue()), Formulas.REM);
    }

    public static FloatValue add(FloatValue value1, FloatValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new FloatValue(value1, value2, Operators.add(value1.getValue(), value2.getValue()), Formulas.ADD);
    }

    public static FloatValue multiply(FloatValue value1, FloatValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new FloatValue(value1, value2, Operators.multiply(value1.getValue(), value2.getValue()), Formulas.MULTIPLY);
    }

    public static FloatValue subtract(FloatValue value1, FloatValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null) {
            return FloatValue.negative(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return new FloatValue(value1, value2, Operators.subtract(value1.getValue(), value2.getValue()), Formulas.SUBTRACT);
    }

    public static FloatValue divide(FloatValue value1, FloatValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null && value2 != null && value2.doubleValue() != 0.0) {
            return new FloatValue(value1, value2, FloatValue.divide(ONE, value2).getValue(), Formulas.DIVIDE);
        }
        if (value2 == null) {
            return new FloatValue(value1, value2, value1.getValue(), Formulas.DIVIDE);
        }
        if (value2.doubleValue() == 0.0) {
            throw new OpenlNotCheckedException("Division by zero");
        }
        return new FloatValue(value1, value2, Operators.divide(value1.getValue(), value2.getValue()), Formulas.DIVIDE);
    }

    public static LongValue quotient(FloatValue number, FloatValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.quotient((float)number.getValue(), (float)divisor.getValue()));
            return new LongValue(result, NumberOperations.QUOTIENT, null);
        }
        return null;
    }

    public static DoubleValue product(FloatValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        float[] primitiveArray = FloatValue.unwrap(values);
        double product = MathUtils.product((float[])primitiveArray);
        return new DoubleValue(new DoubleValue(product), NumberOperations.PRODUCT, null);
    }

    public static FloatValue mod(FloatValue number, FloatValue divisor) {
        if (number != null && divisor != null) {
            FloatValue result = new FloatValue(MathUtils.mod((float)number.getValue(), (float)divisor.getValue()));
            return new FloatValue(result, NumberOperations.MOD, new FloatValue[]{number, divisor});
        }
        return null;
    }

    public static FloatValue small(FloatValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        float[] primitiveArray = FloatValue.unwrap(values);
        float small = MathUtils.small((float[])primitiveArray, (int)position);
        return new FloatValue((FloatValue)FloatValue.getAppropriateValue(values, new FloatValue(small)), NumberOperations.SMALL, values);
    }

    public static FloatValue big(FloatValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        float[] primitiveArray = FloatValue.unwrap(values);
        float big = MathUtils.big((float[])primitiveArray, (int)position);
        return new FloatValue((FloatValue)FloatValue.getAppropriateValue(values, new FloatValue(big)), NumberOperations.BIG, values);
    }

    public static FloatValue pow(FloatValue value1, FloatValue value2) {
        if (value1 == null) {
            return value2 == null ? null : new FloatValue(0.0f);
        }
        if (value2 == null) {
            return value1;
        }
        return new FloatValue(new FloatValue(Operators.pow(value1.getValue(), value2.getValue())), NumberOperations.POW, new FloatValue[]{value1, value2});
    }

    public static FloatValue abs(FloatValue value) {
        if (value == null) {
            return null;
        }
        FloatValue result = new FloatValue(Operators.abs(value.getValue()));
        return new FloatValue(result, NumberOperations.ABS, new FloatValue[]{value});
    }

    public static FloatValue negative(FloatValue value) {
        if (value == null) {
            return null;
        }
        return FloatValue.multiply(value, MINUS_ONE);
    }

    public static FloatValue inc(FloatValue value) {
        return FloatValue.add(value, ONE);
    }

    public static FloatValue positive(FloatValue value) {
        return value;
    }

    public static FloatValue dec(FloatValue value) {
        return FloatValue.subtract(value, ONE);
    }

    public static FloatValue autocast(byte x, FloatValue y) {
        return new FloatValue(x);
    }

    public static FloatValue autocast(short x, FloatValue y) {
        return new FloatValue(x);
    }

    public static FloatValue autocast(int x, FloatValue y) {
        return new FloatValue(x);
    }

    public static FloatValue autocast(long x, FloatValue y) {
        return new FloatValue(x);
    }

    public static FloatValue autocast(float x, FloatValue y) {
        return new FloatValue(x);
    }

    public FloatValue(float value) {
        this.value = value;
    }

    public FloatValue(FloatValue lv1, FloatValue lv2, float value, Formulas operand) {
        super(lv1, lv2, operand);
        this.value = value;
    }

    public FloatValue(float value, ExplanationNumberValue<?> beforeCastValue, boolean autocast) {
        super(beforeCastValue, new CastOperand("FloatValue", autocast));
        this.value = value;
    }

    @Override
    public FloatValue copy(String name) {
        return FloatValue.copy(this, name);
    }

    @Override
    public String printValue() {
        return String.valueOf(this.value);
    }

    public float getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FloatValue) {
            FloatValue secondObj = (FloatValue)obj;
            return Operators.eq(this.getValue(), secondObj.getValue());
        }
        return false;
    }

    public static FloatValue[] sort(FloatValue[] values) {
        FloatValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new FloatValue[values.length];
            Object[] notNullArray = (FloatValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            for (int i = 0; i < notNullArray.length; ++i) {
                sortedArray[i] = notNullArray[i];
            }
        }
        return sortedArray;
    }

    public static FloatValue autocast(Float x, FloatValue y) {
        if (x == null) {
            return null;
        }
        return new FloatValue(x.floatValue());
    }

    public static DoubleValue autocast(FloatValue x, DoubleValue y) {
        if (x == null) {
            return null;
        }
        return new DoubleValue(x.getValue(), x, true);
    }

    public static BigDecimalValue autocast(FloatValue x, BigDecimalValue y) {
        if (x == null) {
            return null;
        }
        return new BigDecimalValue(String.valueOf(x.getValue()), x, true);
    }

    public static String autocast(FloatValue x, String y) {
        if (x == null) {
            return null;
        }
        return x.toString();
    }

    public static Integer distance(FloatValue x, String y) {
        return 11;
    }

    public static FloatValue autocast(String x, FloatValue y) {
        if (x == null) {
            return null;
        }
        return new FloatValue(Float.valueOf(x).floatValue());
    }

    public static Integer distance(String x, FloatValue y) {
        return 10;
    }

    public static byte cast(FloatValue x, byte y) {
        return x.byteValue();
    }

    public static short cast(FloatValue x, short y) {
        return x.shortValue();
    }

    public static char cast(FloatValue x, char y) {
        return (char)x.floatValue();
    }

    public static int cast(FloatValue x, int y) {
        return x.intValue();
    }

    public static long cast(FloatValue x, long y) {
        return x.longValue();
    }

    public static float cast(FloatValue x, float y) {
        return x.floatValue();
    }

    public static double cast(FloatValue x, double y) {
        return x.doubleValue();
    }

    public static Float cast(FloatValue x, Float y) {
        if (x == null) {
            return null;
        }
        return Float.valueOf(x.floatValue());
    }

    public static ByteValue cast(FloatValue x, ByteValue y) {
        if (x == null) {
            return null;
        }
        return new ByteValue(x.byteValue(), x, false);
    }

    public static ShortValue cast(FloatValue x, ShortValue y) {
        if (x == null) {
            return null;
        }
        return new ShortValue(x.shortValue(), x, false);
    }

    public static IntValue cast(FloatValue x, IntValue y) {
        if (x == null) {
            return null;
        }
        return new IntValue(x.intValue(), x, false);
    }

    public static LongValue cast(FloatValue x, LongValue y) {
        if (x == null) {
            return null;
        }
        return new LongValue(x.longValue(), x, false);
    }

    public static FloatValue round(FloatValue value) {
        if (value == null) {
            return null;
        }
        return new FloatValue(new FloatValue(Math.round(value.getValue())), NumberOperations.ROUND, new FloatValue[]{value});
    }

    public static FloatValue round(FloatValue value, int scale) {
        if (value == null) {
            return null;
        }
        return new FloatValue(new FloatValue(MathUtils.round((float)value.floatValue(), (int)scale, (int)4)), NumberOperations.ROUND, new FloatValue[]{value, new FloatValue(scale)});
    }

    public static FloatValue round(FloatValue value, int scale, int roundingMethod) {
        if (value == null) {
            return null;
        }
        return new FloatValue(new FloatValue(MathUtils.round((float)value.floatValue(), (int)scale, (int)roundingMethod)), NumberOperations.ROUND, new FloatValue[]{value, new FloatValue(scale)});
    }

    public FloatValue(String valueString) {
        this.value = Float.parseFloat(valueString);
    }

    public FloatValue(FloatValue result, NumberOperations function, FloatValue[] params) {
        super(function, (ExplanationNumberValue[])params);
        this.value = result.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public int compareTo(Number o) {
        return Float.compare(this.value, o.floatValue());
    }

    public int hashCode() {
        return Float.valueOf(this.value).hashCode();
    }

    private static float[] unwrap(FloatValue[] values) {
        values = (FloatValue[])ArrayTool.removeNulls((Object[])values);
        float[] primitiveArray = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            primitiveArray[i] = values[i].getValue();
        }
        return primitiveArray;
    }

    public static class FloatValueAdapter
    extends XmlAdapter<Float, FloatValue> {
        public FloatValue unmarshal(Float val) throws Exception {
            return new FloatValue(val.floatValue());
        }

        public Float marshal(FloatValue val) throws Exception {
            return Float.valueOf(val.getValue());
        }
    }
}

