/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.impl.Operators;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.explanation.ExplanationNumberValue;
import org.openl.meta.number.CastOperand;
import org.openl.meta.number.Formulas;
import org.openl.meta.number.LogicalExpressions;
import org.openl.meta.number.NumberOperations;
import org.openl.util.ArrayTool;
import org.openl.util.math.MathUtils;

@XmlRootElement
@XmlJavaTypeAdapter(value=IntValueAdapter.class)
public class IntValue
extends ExplanationNumberValue<IntValue> {
    private static final long serialVersionUID = -3821702883606493390L;
    private static final IntValue ZERO = new IntValue(0);
    private static final IntValue ONE = new IntValue(1);
    private static final IntValue MINUS_ONE = new IntValue(-1);
    private final int value;

    public static boolean eq(IntValue value1, IntValue value2) {
        if (value1 == null || value2 == null) {
            return value1 == value2;
        }
        return Operators.eq(value1.getValue(), value2.getValue());
    }

    public static boolean ge(IntValue value1, IntValue value2) {
        IntValue.validate(value1, value2, LogicalExpressions.GE.toString());
        return Operators.ge(value1.getValue(), value2.getValue());
    }

    public static boolean gt(IntValue value1, IntValue value2) {
        IntValue.validate(value1, value2, LogicalExpressions.GT.toString());
        return Operators.gt(value1.getValue(), value2.getValue());
    }

    public static boolean le(IntValue value1, IntValue value2) {
        IntValue.validate(value1, value2, LogicalExpressions.LE.toString());
        return Operators.le(value1.getValue(), value2.getValue());
    }

    public static boolean lt(IntValue value1, IntValue value2) {
        IntValue.validate(value1, value2, LogicalExpressions.LT.toString());
        return Operators.lt(value1.getValue(), value2.getValue());
    }

    public static boolean ne(IntValue value1, IntValue value2) {
        if (value1 == null || value2 == null) {
            return value1 != value2;
        }
        return Operators.ne(value1.getValue(), value2.getValue());
    }

    public static IntValue avg(IntValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        int[] primitiveArray = IntValue.unwrap(values);
        int avg = MathUtils.avg((int[])primitiveArray);
        return new IntValue(new IntValue(avg), NumberOperations.AVG, values);
    }

    public static IntValue sum(IntValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        int[] primitiveArray = IntValue.unwrap(values);
        int sum = MathUtils.sum((int[])primitiveArray);
        return new IntValue(new IntValue(sum), NumberOperations.SUM, values);
    }

    public static IntValue median(IntValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        int[] primitiveArray = IntValue.unwrap(values);
        int median = MathUtils.median((int[])primitiveArray);
        return new IntValue(new IntValue(median), NumberOperations.MEDIAN, values);
    }

    public static IntValue max(IntValue value1, IntValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new IntValue(MathUtils.max((int)value1.getValue(), (int)value2.getValue()) ? value1 : value2, NumberOperations.MAX, new IntValue[]{value1, value2});
    }

    public static IntValue min(IntValue value1, IntValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new IntValue(MathUtils.min((int)value1.getValue(), (int)value2.getValue()) ? value1 : value2, NumberOperations.MIN, new IntValue[]{value1, value2});
    }

    public static IntValue max(IntValue[] values) {
        IntValue result = (IntValue)MathUtils.max((Object[])values);
        return new IntValue((IntValue)IntValue.getAppropriateValue(values, result), NumberOperations.MAX_IN_ARRAY, values);
    }

    public static IntValue min(IntValue[] values) {
        IntValue result = (IntValue)MathUtils.min((Object[])values);
        return new IntValue((IntValue)IntValue.getAppropriateValue(values, result), NumberOperations.MIN_IN_ARRAY, values);
    }

    public static IntValue copy(IntValue value, String name) {
        if (value.getName() == null) {
            value.setName(name);
            return value;
        }
        if (!value.getName().equals(name)) {
            IntValue result = new IntValue(value, NumberOperations.COPY, new IntValue[]{value});
            result.setName(name);
            return result;
        }
        return value;
    }

    public static IntValue rem(IntValue value1, IntValue value2) {
        if (value1 == null || value2 == null) {
            return ZERO;
        }
        return new IntValue(value1, value2, Operators.rem(value1.getValue(), value2.getValue()), Formulas.REM);
    }

    public static IntValue add(IntValue value1, IntValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new IntValue(value1, value2, Operators.add(value1.getValue(), value2.getValue()), Formulas.ADD);
    }

    public static IntValue multiply(IntValue value1, IntValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new IntValue(value1, value2, Operators.multiply(value1.getValue(), value2.getValue()), Formulas.MULTIPLY);
    }

    public static IntValue subtract(IntValue value1, IntValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null) {
            return IntValue.negative(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return new IntValue(value1, value2, Operators.subtract(value1.getValue(), value2.getValue()), Formulas.SUBTRACT);
    }

    public static IntValue divide(IntValue value1, IntValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null && value2 != null && value2.doubleValue() != 0.0) {
            return new IntValue(value1, value2, IntValue.divide(ONE, value2).getValue(), Formulas.DIVIDE);
        }
        if (value2 == null) {
            return new IntValue(value1, value2, value1.getValue(), Formulas.DIVIDE);
        }
        if (value2.doubleValue() == 0.0) {
            throw new OpenlNotCheckedException("Division by zero");
        }
        return new IntValue(value1, value2, Operators.divide(value1.getValue(), value2.getValue()), Formulas.DIVIDE);
    }

    public static LongValue quotient(IntValue number, IntValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.quotient((int)number.getValue(), (int)divisor.getValue()));
            return new LongValue(result, NumberOperations.QUOTIENT, null);
        }
        return null;
    }

    public static DoubleValue product(IntValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        int[] primitiveArray = IntValue.unwrap(values);
        double product = MathUtils.product((int[])primitiveArray);
        return new DoubleValue(new DoubleValue(product), NumberOperations.PRODUCT, null);
    }

    public static IntValue mod(IntValue number, IntValue divisor) {
        if (number != null && divisor != null) {
            IntValue result = new IntValue(MathUtils.mod((int)number.getValue(), (int)divisor.getValue()));
            return new IntValue(result, NumberOperations.MOD, new IntValue[]{number, divisor});
        }
        return null;
    }

    public static IntValue small(IntValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        int[] primitiveArray = IntValue.unwrap(values);
        int small = MathUtils.small((int[])primitiveArray, (int)position);
        return new IntValue((IntValue)IntValue.getAppropriateValue(values, new IntValue(small)), NumberOperations.SMALL, values);
    }

    public static IntValue big(IntValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        int[] primitiveArray = IntValue.unwrap(values);
        int big = MathUtils.big((int[])primitiveArray, (int)position);
        return new IntValue((IntValue)IntValue.getAppropriateValue(values, new IntValue(big)), NumberOperations.BIG, values);
    }

    public static IntValue pow(IntValue value1, IntValue value2) {
        if (value1 == null) {
            return value2 == null ? null : new IntValue(0);
        }
        if (value2 == null) {
            return value1;
        }
        return new IntValue(new IntValue(Operators.pow(value1.getValue(), value2.getValue())), NumberOperations.POW, new IntValue[]{value1, value2});
    }

    public static IntValue abs(IntValue value) {
        if (value == null) {
            return null;
        }
        IntValue result = new IntValue(Operators.abs(value.getValue()));
        return new IntValue(result, NumberOperations.ABS, new IntValue[]{value});
    }

    public static IntValue negative(IntValue value) {
        if (value == null) {
            return null;
        }
        return IntValue.multiply(value, MINUS_ONE);
    }

    public static IntValue inc(IntValue value) {
        return IntValue.add(value, ONE);
    }

    public static IntValue positive(IntValue value) {
        return value;
    }

    public static IntValue dec(IntValue value) {
        return IntValue.subtract(value, ONE);
    }

    public static IntValue autocast(byte x, IntValue y) {
        return new IntValue(x);
    }

    public static IntValue autocast(short x, IntValue y) {
        return new IntValue(x);
    }

    public static IntValue autocast(int x, IntValue y) {
        return new IntValue(x);
    }

    public IntValue(int value) {
        this.value = value;
    }

    public IntValue(IntValue lv1, IntValue lv2, int value, Formulas operand) {
        super(lv1, lv2, operand);
        this.value = value;
    }

    public IntValue(int value, ExplanationNumberValue<?> beforeCastValue, boolean autocast) {
        super(beforeCastValue, new CastOperand("IntValue", autocast));
        this.value = value;
    }

    @Override
    public IntValue copy(String name) {
        return IntValue.copy(this, name);
    }

    @Override
    public String printValue() {
        return String.valueOf(this.value);
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntValue) {
            IntValue secondObj = (IntValue)obj;
            return Operators.eq(this.getValue(), secondObj.getValue());
        }
        return false;
    }

    public static IntValue[] sort(IntValue[] values) {
        IntValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new IntValue[values.length];
            Object[] notNullArray = (IntValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            for (int i = 0; i < notNullArray.length; ++i) {
                sortedArray[i] = notNullArray[i];
            }
        }
        return sortedArray;
    }

    public static IntValue autocast(Integer x, IntValue y) {
        if (x == null) {
            return null;
        }
        return new IntValue(x);
    }

    public static LongValue autocast(IntValue x, LongValue y) {
        if (x == null) {
            return null;
        }
        return new LongValue(x.getValue(), x, true);
    }

    public static FloatValue autocast(IntValue x, FloatValue y) {
        if (x == null) {
            return null;
        }
        return new FloatValue(x.getValue(), x, true);
    }

    public static DoubleValue autocast(IntValue x, DoubleValue y) {
        if (x == null) {
            return null;
        }
        return new DoubleValue(x.getValue(), x, true);
    }

    public static BigIntegerValue autocast(IntValue x, BigIntegerValue y) {
        if (x == null) {
            return null;
        }
        return new BigIntegerValue(String.valueOf(x.getValue()), x, true);
    }

    public static BigDecimalValue autocast(IntValue x, BigDecimalValue y) {
        if (x == null) {
            return null;
        }
        return new BigDecimalValue(String.valueOf(x.getValue()), x, true);
    }

    public static String autocast(IntValue x, String y) {
        if (x == null) {
            return null;
        }
        return x.toString();
    }

    public static Integer distance(IntValue x, String y) {
        return 11;
    }

    public static IntValue autocast(String x, IntValue y) {
        if (x == null) {
            return null;
        }
        return new IntValue(Integer.valueOf(x));
    }

    public static Integer distance(String x, IntValue y) {
        return 10;
    }

    public static byte cast(IntValue x, byte y) {
        return x.byteValue();
    }

    public static short cast(IntValue x, short y) {
        return x.shortValue();
    }

    public static char cast(IntValue x, char y) {
        return (char)x.intValue();
    }

    public static int cast(IntValue x, int y) {
        return x.intValue();
    }

    public static long cast(IntValue x, long y) {
        return x.longValue();
    }

    public static float cast(IntValue x, float y) {
        return x.floatValue();
    }

    public static double cast(IntValue x, double y) {
        return x.doubleValue();
    }

    public static Integer cast(IntValue x, Integer y) {
        if (x == null) {
            return null;
        }
        return x.intValue();
    }

    public static ByteValue cast(IntValue x, ByteValue y) {
        if (x == null) {
            return null;
        }
        return new ByteValue(x.byteValue(), x, false);
    }

    public static ShortValue cast(IntValue x, ShortValue y) {
        if (x == null) {
            return null;
        }
        return new ShortValue(x.shortValue(), x, false);
    }

    public IntValue(String valueString) {
        this.value = Integer.parseInt(valueString);
    }

    public IntValue(IntValue result, NumberOperations function, IntValue[] params) {
        super(function, (ExplanationNumberValue[])params);
        this.value = result.intValue();
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int compareTo(Number o) {
        return this.value < o.intValue() ? -1 : (this.value == o.intValue() ? 0 : 1);
    }

    public int hashCode() {
        return Integer.valueOf(this.value).hashCode();
    }

    private static int[] unwrap(IntValue[] values) {
        values = (IntValue[])ArrayTool.removeNulls((Object[])values);
        int[] intArray = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            intArray[i] = values[i].getValue();
        }
        return intArray;
    }

    public static class IntValueAdapter
    extends XmlAdapter<Integer, IntValue> {
        public IntValue unmarshal(Integer val) throws Exception {
            return new IntValue(val);
        }

        public Integer marshal(IntValue val) throws Exception {
            return val.getValue();
        }
    }
}

