/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.impl.Operators;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.ShortValue;
import org.openl.meta.explanation.ExplanationNumberValue;
import org.openl.meta.number.CastOperand;
import org.openl.meta.number.Formulas;
import org.openl.meta.number.LogicalExpressions;
import org.openl.meta.number.NumberOperations;
import org.openl.util.ArrayTool;
import org.openl.util.math.MathUtils;

@XmlRootElement
@XmlJavaTypeAdapter(value=LongValueAdapter.class)
public class LongValue
extends ExplanationNumberValue<LongValue> {
    private static final long serialVersionUID = -437788531108803012L;
    private static final LongValue ZERO = new LongValue(0L);
    private static final LongValue ONE = new LongValue(1L);
    private static final LongValue MINUS_ONE = new LongValue(-1L);
    private final long value;

    public static boolean eq(LongValue value1, LongValue value2) {
        if (value1 == null || value2 == null) {
            return value1 == value2;
        }
        return Operators.eq(value1.getValue(), value2.getValue());
    }

    public static boolean ge(LongValue value1, LongValue value2) {
        LongValue.validate(value1, value2, LogicalExpressions.GE.toString());
        return Operators.ge(value1.getValue(), value2.getValue());
    }

    public static boolean gt(LongValue value1, LongValue value2) {
        LongValue.validate(value1, value2, LogicalExpressions.GT.toString());
        return Operators.gt(value1.getValue(), value2.getValue());
    }

    public static boolean le(LongValue value1, LongValue value2) {
        LongValue.validate(value1, value2, LogicalExpressions.LE.toString());
        return Operators.le(value1.getValue(), value2.getValue());
    }

    public static boolean lt(LongValue value1, LongValue value2) {
        LongValue.validate(value1, value2, LogicalExpressions.LT.toString());
        return Operators.lt(value1.getValue(), value2.getValue());
    }

    public static boolean ne(LongValue value1, LongValue value2) {
        if (value1 == null || value2 == null) {
            return value1 != value2;
        }
        return Operators.ne(value1.getValue(), value2.getValue());
    }

    public static LongValue avg(LongValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        long[] primitiveArray = LongValue.unwrap(values);
        long avg = MathUtils.avg((long[])primitiveArray);
        return new LongValue(new LongValue(avg), NumberOperations.AVG, values);
    }

    public static LongValue sum(LongValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        long[] primitiveArray = LongValue.unwrap(values);
        long sum = MathUtils.sum((long[])primitiveArray);
        return new LongValue(new LongValue(sum), NumberOperations.SUM, values);
    }

    public static LongValue median(LongValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        long[] primitiveArray = LongValue.unwrap(values);
        long median = MathUtils.median((long[])primitiveArray);
        return new LongValue(new LongValue(median), NumberOperations.MEDIAN, values);
    }

    public static LongValue max(LongValue value1, LongValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new LongValue(MathUtils.max((long)value1.getValue(), (long)value2.getValue()) ? value1 : value2, NumberOperations.MAX, new LongValue[]{value1, value2});
    }

    public static LongValue min(LongValue value1, LongValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new LongValue(MathUtils.min((long)value1.getValue(), (long)value2.getValue()) ? value1 : value2, NumberOperations.MIN, new LongValue[]{value1, value2});
    }

    public static LongValue max(LongValue[] values) {
        LongValue result = (LongValue)MathUtils.max((Object[])values);
        return new LongValue((LongValue)LongValue.getAppropriateValue(values, result), NumberOperations.MAX_IN_ARRAY, values);
    }

    public static LongValue min(LongValue[] values) {
        LongValue result = (LongValue)MathUtils.min((Object[])values);
        return new LongValue((LongValue)LongValue.getAppropriateValue(values, result), NumberOperations.MIN_IN_ARRAY, values);
    }

    public static LongValue copy(LongValue value, String name) {
        if (value.getName() == null) {
            value.setName(name);
            return value;
        }
        if (!value.getName().equals(name)) {
            LongValue result = new LongValue(value, NumberOperations.COPY, new LongValue[]{value});
            result.setName(name);
            return result;
        }
        return value;
    }

    public static LongValue rem(LongValue value1, LongValue value2) {
        if (value1 == null || value2 == null) {
            return ZERO;
        }
        return new LongValue(value1, value2, Operators.rem(value1.getValue(), value2.getValue()), Formulas.REM);
    }

    public static LongValue add(LongValue value1, LongValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new LongValue(value1, value2, Operators.add(value1.getValue(), value2.getValue()), Formulas.ADD);
    }

    public static LongValue multiply(LongValue value1, LongValue value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return new LongValue(value1, value2, Operators.multiply(value1.getValue(), value2.getValue()), Formulas.MULTIPLY);
    }

    public static LongValue subtract(LongValue value1, LongValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null) {
            return LongValue.negative(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return new LongValue(value1, value2, Operators.subtract(value1.getValue(), value2.getValue()), Formulas.SUBTRACT);
    }

    public static LongValue divide(LongValue value1, LongValue value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null && value2 != null && value2.doubleValue() != 0.0) {
            return new LongValue(value1, value2, LongValue.divide(ONE, value2).getValue(), Formulas.DIVIDE);
        }
        if (value2 == null) {
            return new LongValue(value1, value2, value1.getValue(), Formulas.DIVIDE);
        }
        if (value2.doubleValue() == 0.0) {
            throw new OpenlNotCheckedException("Division by zero");
        }
        return new LongValue(value1, value2, Operators.divide(value1.getValue(), value2.getValue()), Formulas.DIVIDE);
    }

    public static LongValue quotient(LongValue number, LongValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.quotient((long)number.getValue(), (long)divisor.getValue()));
            return new LongValue(result, NumberOperations.QUOTIENT, null);
        }
        return null;
    }

    public static DoubleValue product(LongValue[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        long[] primitiveArray = LongValue.unwrap(values);
        double product = MathUtils.product((long[])primitiveArray);
        return new DoubleValue(new DoubleValue(product), NumberOperations.PRODUCT, null);
    }

    public static LongValue mod(LongValue number, LongValue divisor) {
        if (number != null && divisor != null) {
            LongValue result = new LongValue(MathUtils.mod((long)number.getValue(), (long)divisor.getValue()));
            return new LongValue(result, NumberOperations.MOD, new LongValue[]{number, divisor});
        }
        return null;
    }

    public static LongValue small(LongValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        long[] primitiveArray = LongValue.unwrap(values);
        long small = MathUtils.small((long[])primitiveArray, (int)position);
        return new LongValue((LongValue)LongValue.getAppropriateValue(values, new LongValue(small)), NumberOperations.SMALL, values);
    }

    public static LongValue big(LongValue[] values, int position) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return null;
        }
        long[] primitiveArray = LongValue.unwrap(values);
        long big = MathUtils.big((long[])primitiveArray, (int)position);
        return new LongValue((LongValue)LongValue.getAppropriateValue(values, new LongValue(big)), NumberOperations.BIG, values);
    }

    public static LongValue pow(LongValue value1, LongValue value2) {
        if (value1 == null) {
            return value2 == null ? null : new LongValue(0L);
        }
        if (value2 == null) {
            return value1;
        }
        return new LongValue(new LongValue(Operators.pow(value1.getValue(), value2.getValue())), NumberOperations.POW, new LongValue[]{value1, value2});
    }

    public static LongValue abs(LongValue value) {
        if (value == null) {
            return null;
        }
        LongValue result = new LongValue(Operators.abs(value.getValue()));
        return new LongValue(result, NumberOperations.ABS, new LongValue[]{value});
    }

    public static LongValue negative(LongValue value) {
        if (value == null) {
            return null;
        }
        return LongValue.multiply(value, MINUS_ONE);
    }

    public static LongValue inc(LongValue value) {
        return LongValue.add(value, ONE);
    }

    public static LongValue positive(LongValue value) {
        return value;
    }

    public static LongValue dec(LongValue value) {
        return LongValue.subtract(value, ONE);
    }

    public static LongValue autocast(byte x, LongValue y) {
        return new LongValue(x);
    }

    public static LongValue autocast(short x, LongValue y) {
        return new LongValue(x);
    }

    public static LongValue autocast(int x, LongValue y) {
        return new LongValue(x);
    }

    public static LongValue autocast(long x, LongValue y) {
        return new LongValue(x);
    }

    public LongValue(long value) {
        this.value = value;
    }

    public LongValue(LongValue lv1, LongValue lv2, long value, Formulas operand) {
        super(lv1, lv2, operand);
        this.value = value;
    }

    public LongValue(long value, ExplanationNumberValue<?> beforeCastValue, boolean autocast) {
        super(beforeCastValue, new CastOperand("LongValue", autocast));
        this.value = value;
    }

    @Override
    public LongValue copy(String name) {
        return LongValue.copy(this, name);
    }

    @Override
    public String printValue() {
        return String.valueOf(this.value);
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongValue) {
            LongValue secondObj = (LongValue)obj;
            return Operators.eq(this.getValue(), secondObj.getValue());
        }
        return false;
    }

    public static LongValue[] sort(LongValue[] values) {
        LongValue[] sortedArray = null;
        if (values != null) {
            sortedArray = new LongValue[values.length];
            Object[] notNullArray = (LongValue[])ArrayTool.removeNulls((Object[])values);
            Arrays.sort(notNullArray);
            for (int i = 0; i < notNullArray.length; ++i) {
                sortedArray[i] = notNullArray[i];
            }
        }
        return sortedArray;
    }

    public static LongValue autocast(Long x, LongValue y) {
        if (x == null) {
            return null;
        }
        return new LongValue(x);
    }

    public static FloatValue autocast(LongValue x, FloatValue y) {
        if (x == null) {
            return null;
        }
        return new FloatValue(x.getValue(), x, true);
    }

    public static DoubleValue autocast(LongValue x, DoubleValue y) {
        if (x == null) {
            return null;
        }
        return new DoubleValue(x.getValue(), x, true);
    }

    public static BigIntegerValue autocast(LongValue x, BigIntegerValue y) {
        if (x == null) {
            return null;
        }
        return new BigIntegerValue(String.valueOf(x.getValue()), x, true);
    }

    public static BigDecimalValue autocast(LongValue x, BigDecimalValue y) {
        if (x == null) {
            return null;
        }
        return new BigDecimalValue(String.valueOf(x.getValue()), x, true);
    }

    public static String autocast(LongValue x, String y) {
        if (x == null) {
            return null;
        }
        return x.toString();
    }

    public static Integer distance(LongValue x, String y) {
        return 11;
    }

    public static LongValue autocast(String x, LongValue y) {
        if (x == null) {
            return null;
        }
        return new LongValue(Long.valueOf(x));
    }

    public static Integer distance(String x, LongValue y) {
        return 10;
    }

    public static byte cast(LongValue x, byte y) {
        return x.byteValue();
    }

    public static short cast(LongValue x, short y) {
        return x.shortValue();
    }

    public static char cast(LongValue x, char y) {
        return (char)x.longValue();
    }

    public static int cast(LongValue x, int y) {
        return x.intValue();
    }

    public static long cast(LongValue x, long y) {
        return x.longValue();
    }

    public static float cast(LongValue x, float y) {
        return x.floatValue();
    }

    public static double cast(LongValue x, double y) {
        return x.doubleValue();
    }

    public static Long cast(LongValue x, Long y) {
        if (x == null) {
            return null;
        }
        return x.longValue();
    }

    public static ByteValue cast(LongValue x, ByteValue y) {
        if (x == null) {
            return null;
        }
        return new ByteValue(x.byteValue(), x, false);
    }

    public static ShortValue cast(LongValue x, ShortValue y) {
        if (x == null) {
            return null;
        }
        return new ShortValue(x.shortValue(), x, false);
    }

    public static IntValue cast(LongValue x, IntValue y) {
        if (x == null) {
            return null;
        }
        return new IntValue(x.intValue(), x, false);
    }

    public LongValue(String valueString) {
        this.value = Long.parseLong(valueString);
    }

    public LongValue(LongValue result, NumberOperations function, LongValue[] params) {
        super(function, (ExplanationNumberValue[])params);
        this.value = result.longValue();
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int compareTo(Number o) {
        return this.value < o.longValue() ? -1 : (this.value == o.longValue() ? 0 : 1);
    }

    public int hashCode() {
        return Long.valueOf(this.value).hashCode();
    }

    private static long[] unwrap(LongValue[] values) {
        values = (LongValue[])ArrayTool.removeNulls((Object[])values);
        long[] longArray = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            longArray[i] = values[i].getValue();
        }
        return longArray;
    }

    public static class LongValueAdapter
    extends XmlAdapter<Long, LongValue> {
        public LongValue unmarshal(Long val) throws Exception {
            return new LongValue(val);
        }

        public Long marshal(LongValue val) throws Exception {
            return val.getValue();
        }
    }
}

