/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta.explanation;

import javax.xml.bind.annotation.XmlTransient;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.meta.IMetaInfo;
import org.openl.meta.explanation.CastExplanationValue;
import org.openl.meta.explanation.ExplanationForNumber;
import org.openl.meta.explanation.FormulaExplanationValue;
import org.openl.meta.explanation.FunctionExplanationValue;
import org.openl.meta.explanation.SingleValueExplanation;
import org.openl.meta.number.CastOperand;
import org.openl.meta.number.Formulas;
import org.openl.meta.number.NumberOperations;
import org.openl.util.tree.ITreeElement;

public abstract class ExplanationNumberValue<T extends ExplanationNumberValue<T>>
extends Number
implements Comparable<Number>,
ExplanationForNumber<T> {
    private static final long serialVersionUID = -5461468496220613277L;
    private transient ExplanationForNumber<T> explanation;

    public ExplanationNumberValue() {
    }

    public ExplanationNumberValue(T dv1, T dv2, Formulas operand) {
        this.explanation = new FormulaExplanationValue<T>(dv1, dv2, operand);
    }

    public ExplanationNumberValue(NumberOperations function, T[] params) {
        this.explanation = new FunctionExplanationValue(function, params);
    }

    public ExplanationNumberValue(ExplanationNumberValue<?> previousValue, CastOperand operand) {
        this.explanation = new CastExplanationValue(previousValue, operand);
    }

    public FormulaExplanationValue<T> getFormula() {
        return (FormulaExplanationValue)this.explanation;
    }

    public FunctionExplanationValue<T> getFunction() {
        return (FunctionExplanationValue)this.explanation;
    }

    public CastExplanationValue getCast() {
        return (CastExplanationValue)this.explanation;
    }

    public boolean isFormula() {
        return this.explanation instanceof FormulaExplanationValue;
    }

    public boolean isFunction() {
        return this.explanation instanceof FunctionExplanationValue;
    }

    public boolean isCast() {
        return this.explanation instanceof CastExplanationValue;
    }

    public abstract T copy(String var1);

    private ExplanationForNumber<T> getExplanation() {
        if (this.explanation == null) {
            this.explanation = new SingleValueExplanation();
        }
        return this.explanation;
    }

    @Override
    @XmlTransient
    public IMetaInfo getMetaInfo() {
        return this.getExplanation().getMetaInfo();
    }

    @Override
    public void setMetaInfo(IMetaInfo metaInfo) {
        this.getExplanation().setMetaInfo(metaInfo);
    }

    public String getName() {
        return this.getExplanation().getName();
    }

    public String getDisplayName(int mode) {
        return this.getExplanation().getDisplayName(mode);
    }

    @Override
    public void setFullName(String name) {
        this.getExplanation().setFullName(name);
    }

    @Override
    public void setName(String name) {
        this.getExplanation().setName(name);
    }

    public Iterable<? extends ITreeElement<T>> getChildren() {
        return this.getExplanation().getChildren();
    }

    public boolean isLeaf() {
        return this.getExplanation().isLeaf();
    }

    public String getType() {
        return this.getExplanation().getType();
    }

    public T getObject() {
        return (T)this;
    }

    public String toString() {
        return this.printValue();
    }

    protected static <T extends ExplanationNumberValue<T>> ExplanationNumberValue<T> getAppropriateValue(ExplanationNumberValue<T>[] values, ExplanationNumberValue<?> result) {
        for (ExplanationNumberValue<T> value : values) {
            if (value != result && (value == null || !value.equals(result))) continue;
            return value;
        }
        return null;
    }

    protected static OpenlNotCheckedException getTwoArgumentsException(String operation) {
        return new OpenlNotCheckedException(String.format("None of the arguments for '%s' operation can be null", operation));
    }

    protected static OpenlNotCheckedException getOneArgumentException(NumberOperations operation) {
        return new OpenlNotCheckedException(String.format("Argument couldn`t be null for '%s' operation", operation.toString()));
    }

    protected static void validate(ExplanationNumberValue<?> value1, ExplanationNumberValue<?> value2, NumberOperations operation) {
        if (value1 == null || value2 == null) {
            throw ExplanationNumberValue.getTwoArgumentsException(operation.toString());
        }
    }

    protected static void validate(ExplanationNumberValue<?> value, NumberOperations operation) {
        if (value == null) {
            throw ExplanationNumberValue.getOneArgumentException(operation);
        }
    }

    protected static void validate(ExplanationNumberValue<?> value1, ExplanationNumberValue<?> value2, String operation) {
        if (value1 == null || value2 == null) {
            throw ExplanationNumberValue.getTwoArgumentsException(operation);
        }
    }
}

