/*
 * Decompiled with CFR 0.152.
 */
package org.openl.runtime;

import java.io.File;
import java.net.URL;
import org.openl.CompiledOpenClass;
import org.openl.classloader.OpenLBundleClassLoader;
import org.openl.classloader.OpenLClassLoaderHelper;
import org.openl.classloader.SimpleBundleClassLoader;
import org.openl.conf.IUserContext;
import org.openl.dependency.IDependencyManager;
import org.openl.engine.OpenLManager;
import org.openl.runtime.AOpenLEngineFactory;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;

public abstract class ASourceCodeEngineFactory
extends AOpenLEngineFactory {
    private IOpenSourceCodeModule sourceCode;
    private boolean executionMode;
    private IDependencyManager dependencyManager;

    public ASourceCodeEngineFactory(String openlName, IOpenSourceCodeModule sourceCode, IUserContext userContext) {
        super(openlName, userContext);
        this.initSource(sourceCode);
    }

    public ASourceCodeEngineFactory(String openlName, IOpenSourceCodeModule sourceCode, String userHome) {
        super(openlName, userHome);
        this.initSource(sourceCode);
    }

    public ASourceCodeEngineFactory(String openlName, IOpenSourceCodeModule sourceCode) {
        super(openlName);
        this.initSource(sourceCode);
    }

    public ASourceCodeEngineFactory(String openlName, String sourceFile) {
        this(openlName, new FileSourceCodeModule(sourceFile, null));
    }

    public ASourceCodeEngineFactory(String openlName, String sourceFile, String userHome) {
        this(openlName, (IOpenSourceCodeModule)new FileSourceCodeModule(sourceFile, null), userHome);
    }

    public ASourceCodeEngineFactory(String openlName, File file) {
        this(openlName, new FileSourceCodeModule(file, null));
    }

    public ASourceCodeEngineFactory(String openlName, URL source) {
        this(openlName, new URLSourceCodeModule(source));
    }

    private void initSource(IOpenSourceCodeModule sourceCode) {
        this.sourceCode = sourceCode;
    }

    public boolean isExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(boolean executionMode) {
        this.executionMode = executionMode;
    }

    public IOpenSourceCodeModule getSourceCode() {
        return this.sourceCode;
    }

    public IDependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public void setDependencyManager(IDependencyManager dependencyManager) {
        this.dependencyManager = dependencyManager;
    }

    protected CompiledOpenClass initializeOpenClass() {
        ClassLoader oldClassLoader = OpenLClassLoaderHelper.getContextClassLoader();
        if (!(oldClassLoader instanceof OpenLBundleClassLoader)) {
            SimpleBundleClassLoader newClassLoader = new SimpleBundleClassLoader(oldClassLoader);
            Thread.currentThread().setContextClassLoader(newClassLoader);
        }
        try {
            CompiledOpenClass compiledOpenClass = OpenLManager.compileModuleWithErrors(this.getOpenL(), this.getSourceCode(), this.executionMode, this.dependencyManager);
            return compiledOpenClass;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

