/*
 * Decompiled with CFR 0.152.
 */
package org.openl.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.openl.runtime.IEngineWrapper;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.SimpleVM;

public class OpenLInvocationHandler
implements InvocationHandler,
IEngineWrapper {
    private Object openlInstance;
    private Map<Method, IOpenMember> methodMap;
    private ThreadLocal<IRuntimeEnv> env = new ThreadLocal<IRuntimeEnv>(){

        @Override
        protected IRuntimeEnv initialValue() {
            return OpenLInvocationHandler.this.makeRuntimeEnv();
        }
    };

    public OpenLInvocationHandler(Object openlInstance, Map<Method, IOpenMember> methodMap) {
        this.openlInstance = openlInstance;
        this.methodMap = methodMap;
    }

    public OpenLInvocationHandler(Object openlInstance, IRuntimeEnv openlEnv, Map<Method, IOpenMember> methodMap) {
        this(openlInstance, methodMap);
        this.setRuntimeEnv(openlEnv);
    }

    public IRuntimeEnv makeRuntimeEnv() {
        return new SimpleVM().getRuntimeEnv();
    }

    @Override
    public Object getInstance() {
        return this.openlInstance;
    }

    @Override
    public IRuntimeEnv getRuntimeEnv() {
        return this.env.get();
    }

    public void setRuntimeEnv(IRuntimeEnv runtimeEnv) {
        if (runtimeEnv != null) {
            this.env.set(runtimeEnv);
        }
    }

    protected Map<Method, IOpenMember> getMethodMap() {
        return this.methodMap;
    }

    @Override
    public void release() {
        this.env.remove();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == IEngineWrapper.class) {
            Method wrapperMethod = OpenLInvocationHandler.class.getDeclaredMethod(method.getName(), new Class[0]);
            return wrapperMethod.invoke((Object)this, args);
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            return method.invoke((Object)this, args);
        }
        IOpenMember member = this.methodMap.get(method);
        if (member instanceof IOpenMethod) {
            IOpenMethod openMethod = (IOpenMethod)member;
            return openMethod.invoke(this.openlInstance, args, this.getRuntimeEnv());
        }
        IOpenField openField = (IOpenField)member;
        return openField.get(this.openlInstance, this.getRuntimeEnv());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Proxy) {
            return obj.equals(this);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

