/*
 * Decompiled with CFR 0.152.
 */
package org.openl.source.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.util.RuntimeExceptionWrapper;

public abstract class ASourceCodeModule
implements IOpenSourceCodeModule {
    protected String code;
    protected String uri;
    protected int tabSize = 2;
    private Map<String, Object> params;

    @Override
    public synchronized String getCode() {
        if (this.code == null) {
            StringBuilder buf = new StringBuilder(4096);
            char[] c = new char[8192];
            BufferedReader br = new BufferedReader(this.getCharacterStream());
            try {
                int len;
                while ((len = br.read(c)) > 0) {
                    buf.append(c, 0, len);
                }
            }
            catch (IOException e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
            this.code = buf.toString();
        }
        return this.code;
    }

    @Override
    public int getStartPosition() {
        return 0;
    }

    @Override
    public int getTabSize() {
        return this.tabSize;
    }

    @Override
    public synchronized String getUri(int textpos) {
        if (this.uri == null) {
            this.uri = this.makeUri();
        }
        return this.uri;
    }

    protected abstract String makeUri();

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    @Override
    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public abstract void resetModified();
}

