/*
 * Decompiled with CFR 0.152.
 */
package org.openl.source.impl;

import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.util.fast.FastStringReader;

public class CompositeSourceCodeModule
implements IOpenSourceCodeModule {
    private IOpenSourceCodeModule[] modules;
    private String source;
    private int[] modulesCount;
    private Map<String, Object> params;

    public CompositeSourceCodeModule(IOpenSourceCodeModule[] modules, String separator) {
        this.modules = modules;
        this.modulesCount = new int[modules.length];
        this.makeCode(separator);
    }

    public IOpenSourceCodeModule[] getModules() {
        return this.modules;
    }

    private void makeCode(String separator) {
        StringBuilder buf = new StringBuilder(100);
        for (int i = 0; i < this.modules.length; ++i) {
            if (this.modules[i] == null) continue;
            String code = this.modules[i].getCode();
            this.modulesCount[i] = code.length() + separator.length();
            buf.append(code);
            buf.append(separator);
        }
        this.source = buf.toString();
    }

    @Override
    public InputStream getByteStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream() {
        return new FastStringReader(this.source);
    }

    @Override
    public String getCode() {
        return this.source;
    }

    @Override
    public int getStartPosition() {
        return 0;
    }

    @Override
    public int getTabSize() {
        return 2;
    }

    @Override
    public String getUri(int textpos) {
        int relPos = textpos;
        int sum = 0;
        int pos = -1;
        for (int i = 0; i < this.modulesCount.length; ++i) {
            if (sum + this.modulesCount[i] > textpos) {
                pos = i;
                relPos = textpos - sum;
                break;
            }
            sum += this.modulesCount[i];
        }
        return pos < 0 ? null : this.modules[pos].getUri(relPos);
    }

    @Override
    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    @Override
    public boolean isModified() {
        for (IOpenSourceCodeModule module : this.modules) {
            if (!module.isModified()) continue;
            return true;
        }
        return false;
    }
}

