/*
 * Decompiled with CFR 0.152.
 */
package org.openl.syntax.exception;

import java.util.HashMap;
import java.util.Map;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.formatter.ExceptionMessageFormatter;
import org.openl.syntax.exception.formatter.IndexOutOfBoundsExceptionFormatter;
import org.openl.syntax.exception.formatter.NullPointerExceptionFormatter;
import org.openl.util.text.ILocation;

public class SyntaxNodeExceptionUtils {
    private static Map<Class<?>, ExceptionMessageFormatter> formatters = new HashMap();

    private SyntaxNodeExceptionUtils() {
    }

    public static SyntaxNodeException createError(String message, IOpenSourceCodeModule source) {
        return SyntaxNodeExceptionUtils.createError(message, null, null, source);
    }

    public static SyntaxNodeException createError(String message, ISyntaxNode syntaxNode) {
        return SyntaxNodeExceptionUtils.createError(message, null, syntaxNode);
    }

    public static SyntaxNodeException createError(String message, Throwable throwable, ILocation location, IOpenSourceCodeModule source) {
        return new SyntaxNodeException(message, throwable, location, source);
    }

    public static SyntaxNodeException createError(String message, Throwable throwable, ISyntaxNode syntaxNode) {
        return new SyntaxNodeException(message, throwable, syntaxNode);
    }

    public static SyntaxNodeException createError(Throwable throwable, ISyntaxNode syntaxNode) {
        return SyntaxNodeExceptionUtils.createError(SyntaxNodeExceptionUtils.formatErrorMessage(throwable), throwable, syntaxNode);
    }

    private static String formatErrorMessage(Throwable throwable) {
        String formattedMessage = throwable.getMessage();
        ExceptionMessageFormatter filter = formatters.get(throwable.getClass());
        if (filter != null) {
            formattedMessage = filter.format(throwable);
        }
        return formattedMessage;
    }

    static {
        formatters.put(ArrayIndexOutOfBoundsException.class, new IndexOutOfBoundsExceptionFormatter());
        formatters.put(NullPointerException.class, new NullPointerExceptionFormatter());
    }
}

