/*
 * Decompiled with CFR 0.152.
 */
package org.openl.syntax.impl;

import java.util.Iterator;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.util.AIndexedIterator;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInterval;
import org.openl.util.tree.TreeIterator;

public abstract class ASyntaxNode
implements ISyntaxNode {
    public static final TreeIterator.TreeAdaptor<ISyntaxNode> TREE_ADAPTOR = new SyntaxTreeAdaptor();
    private String type;
    private IOpenSourceCodeModule module;
    private ISyntaxNode parent;
    private ILocation location;

    private static void printSpace(int level, StringBuilder buf) {
        for (int j = 0; j < level; ++j) {
            buf.append("  ");
        }
    }

    public ASyntaxNode(String type, ILocation location, IOpenSourceCodeModule module) {
        this.type = type;
        this.location = location;
        this.module = module;
    }

    public ILocation getLocation() {
        return this.location;
    }

    @Override
    public IOpenSourceCodeModule getModule() {
        if (this.module != null) {
            return this.module;
        }
        if (this.parent != null) {
            return this.parent.getModule();
        }
        return null;
    }

    @Override
    public ISyntaxNode getParent() {
        return this.parent;
    }

    @Override
    public ILocation getSourceLocation() {
        if (this.location == null) {
            int n = this.getNumberOfChildren();
            switch (n) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.getChild(0).getSourceLocation();
                }
            }
            ILocation startLocation = this.getChild(0).getSourceLocation();
            if (startLocation == null) {
                return null;
            }
            ILocation endLocation = this.getChild(n - 1).getSourceLocation();
            if (endLocation == null) {
                return null;
            }
            return new TextInterval(startLocation.getStart(), endLocation.getEnd());
        }
        return this.location;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void print(int level, StringBuilder buf) {
        int nkids = this.getNumberOfChildren();
        this.printMySelf(level, buf);
        buf.append('\n');
        for (int i = 0; i < nkids; ++i) {
            ISyntaxNode ch = this.getChild(i);
            if (ch == null) {
                ASyntaxNode.printSpace(level + 1, buf);
                buf.append("null\n");
                continue;
            }
            ch.print(level + 1, buf);
        }
    }

    protected void printMySelf(int level, StringBuilder buf) {
        ASyntaxNode.printSpace(level, buf);
        buf.append(this.getType());
    }

    @Override
    public void setParent(ISyntaxNode parent) {
        this.parent = parent;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.print(0, buf);
        return buf.toString();
    }

    private static class SyntaxTreeAdaptor
    implements TreeIterator.TreeAdaptor<ISyntaxNode> {
        private SyntaxTreeAdaptor() {
        }

        public Iterator<ISyntaxNode> children(ISyntaxNode syntaxNode) {
            return new SyntaxNodeChildrenIterator(syntaxNode);
        }

        private static class SyntaxNodeChildrenIterator
        extends AIndexedIterator<ISyntaxNode> {
            private ISyntaxNode node;

            public SyntaxNodeChildrenIterator(ISyntaxNode node) {
                super(0, node.getNumberOfChildren(), 1);
                this.node = node;
            }

            protected ISyntaxNode indexedElement(int i) {
                return this.node.getChild(i);
            }
        }
    }
}

